/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.group;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.group.GroupRelationLoader;
import kd.scmc.ism.model.group.rel.IGroupRelation;
import kd.scmc.ism.model.group.rel.collect.IGroupDataCollector;

public class DataGroupClassfier {
    private GroupRelationLoader relationLoader;

    public static DataGroupClassfier create() {
        DataGroupClassfier classfier = new DataGroupClassfier();
        return classfier;
    }

    private DataGroupClassfier() {
    }

    public void loadCollectData(IGroupDataCollector collector) {
        if (collector == null || !collector.isContainGroup()) {
            return;
        }
        Map<Long, IGroupRelation> relations = this.getRelationLoader().getRelations();
        if (relations.isEmpty()) {
            return;
        }
        for (IGroupRelation relation : relations.values()) {
            Set<Long> ids = collector.getDataIds(relation.getDataEntityType());
            Set<Long> collectGroupIds = collector.getGroupIds(relation.getGroupEntityType());
            if (CommonUtils.collectionIsEmpty(ids) || CommonUtils.collectionIsEmpty(collectGroupIds)) continue;
            HashSet<Long> groupIds = new HashSet<Long>(16);
            Map<Long, List<Long>> directGroup = this.relationLoader.getDataDirectGroup(ids, relation.getId());
            for (List<Long> directGroupIds : directGroup.values()) {
                groupIds.addAll(directGroupIds);
            }
            groupIds.addAll(collectGroupIds);
            this.relationLoader.getGroupLongNumber(groupIds, relation.getId());
        }
    }

    public boolean isDataOnGroup(Long dataId, Long groupId, Long relationId) {
        if (CommonUtils.idIsNull(groupId)) {
            return true;
        }
        if (CommonUtils.idIsNull(dataId)) {
            return false;
        }
        Map<Long, List<Long>> dataDGroups = this.getRelationLoader().getDataDirectGroup(Collections.singleton(dataId), relationId);
        List<Long> dgroups = dataDGroups.get(dataId);
        if (CommonUtils.collectionIsEmpty(dgroups)) {
            return false;
        }
        return this.checkIsOnGroup(groupId, dgroups, relationId);
    }

    private boolean checkIsOnGroup(long tgtGroupId, List<Long> checkGroups, long relationId) {
        if (checkGroups.contains(tgtGroupId)) {
            return true;
        }
        HashSet<Long> allId = new HashSet<Long>(16);
        allId.addAll(checkGroups);
        allId.add(tgtGroupId);
        Map<Long, String> groupLongNumbers = this.getRelationLoader().getGroupLongNumber(allId, relationId);
        String tgtGroupNum = groupLongNumbers.get(tgtGroupId);
        if (StringUtils.isEmpty((CharSequence)tgtGroupNum)) {
            return false;
        }
        String dlm = this.getRelationLoader().getRelation(relationId).getLongNumberDLM();
        String tgtGroupNumPre = tgtGroupNum + dlm;
        for (Long checkgroupId : checkGroups) {
            String checkGroupNum = groupLongNumbers.get(checkgroupId);
            if (!StringUtils.isNotEmpty((CharSequence)checkGroupNum) || !checkGroupNum.startsWith(tgtGroupNumPre)) continue;
            return true;
        }
        return false;
    }

    private GroupRelationLoader getRelationLoader() {
        if (this.relationLoader == null) {
            this.relationLoader = GroupRelationLoader.create();
        }
        return this.relationLoader;
    }

    public Collection<IGroupRelation> getRelations() {
        GroupRelationLoader loader = this.getRelationLoader();
        if (loader != null) {
            return loader.getRelations().values();
        }
        return new HashSet<IGroupRelation>(0);
    }
}

