/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.group;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.business.helper.filter.CommonFilterHelper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.group.rel.IGroupRelation;
import kd.scmc.ism.model.group.rel.impl.AbstractGroupRelation;
import kd.scmc.ism.model.group.rel.impl.DataFieldRelation;
import kd.scmc.ism.model.group.rel.impl.TableRelation;

public class GroupRelationLoader {
    private Map<Long, IGroupRelation> relations = new HashMap<Long, IGroupRelation>(16);
    private Map<Long, Map<Long, List<Long>>> dataDirectGroupCache = new HashMap<Long, Map<Long, List<Long>>>(64);
    private Map<Long, Map<Long, String>> groupLongNumberCache = new HashMap<Long, Map<Long, String>>(64);

    private GroupRelationLoader() {
    }

    public static GroupRelationLoader create() {
        GroupRelationLoader loader = new GroupRelationLoader();
        loader.buildGroupRelations();
        return loader;
    }

    private void buildGroupRelations() {
        Map objs = BusinessDataServiceHelper.loadFromCache((String)"msmod_datagrouprelation", (QFilter[])CommonFilterHelper.getAllFilters());
        for (DynamicObject obj : objs.values()) {
            String relType = obj.getString("relationtype");
            AbstractGroupRelation groupRelation = null;
            if ("in".equals(relType)) {
                groupRelation = DataFieldRelation.build(obj);
            } else {
                if (!"out".equals(relType)) continue;
                groupRelation = TableRelation.build(obj);
            }
            this.relations.put(DynamicObjectUtil.getPkValue(obj), groupRelation);
        }
    }

    public Map<Long, List<Long>> getDataDirectGroup(Collection<Long> dataIds, Long relationId) {
        IGroupRelation relation = this.relations.get(relationId);
        HashMap<Long, List<Long>> result = new HashMap<Long, List<Long>>(dataIds.size());
        if (relation != null) {
            Map<Long, List<Long>> dataDirectGroups = CommonUtils.mapGetMapValue(this.dataDirectGroupCache, relationId);
            HashSet<Long> needQueryDataId = new HashSet<Long>(dataIds.size());
            for (Long dataId : dataIds) {
                List<Long> groups = dataDirectGroups.get(dataId);
                if (groups == null) {
                    needQueryDataId.add(dataId);
                    dataDirectGroups.put(dataId, new ArrayList(16));
                    continue;
                }
                result.put(dataId, groups);
            }
            if (!needQueryDataId.isEmpty()) {
                Map<Long, List<Long>> groupIds = relation.getGroupIds(dataIds);
                for (Map.Entry<Long, List<Long>> groupIdEntry : groupIds.entrySet()) {
                    Long dataId = groupIdEntry.getKey();
                    List<Long> dGroupIds = groupIdEntry.getValue();
                    dataDirectGroups.put(dataId, dGroupIds);
                    result.put(dataId, dGroupIds);
                }
            }
        }
        return result;
    }

    public Map<Long, String> getGroupLongNumber(Collection<Long> groupIds, Long relationId) {
        IGroupRelation relation = this.relations.get(relationId);
        HashMap<Long, String> result = new HashMap<Long, String>(groupIds.size());
        if (relation != null) {
            Map<Long, String> groupLongNumbers = CommonUtils.mapGetMapValue(this.groupLongNumberCache, relationId);
            HashSet<Long> needQueryGroupId = new HashSet<Long>(groupIds.size());
            for (Long groupId : groupIds) {
                String longNubmer = groupLongNumbers.get(groupId);
                if (longNubmer == null) {
                    needQueryGroupId.add(groupId);
                    continue;
                }
                result.put(groupId, longNubmer);
            }
            if (!needQueryGroupId.isEmpty()) {
                Map<Long, String> groupLongNumber = relation.getGroupLongNumber(groupIds);
                groupLongNumbers.putAll(groupLongNumber);
                result.putAll(groupLongNumber);
            }
        }
        return result;
    }

    public Map<Long, IGroupRelation> getRelations() {
        return this.relations;
    }

    public IGroupRelation getRelation(Long relationId) {
        return this.relations.get(relationId);
    }
}

