/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.group.rel.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.scmc.ism.business.helper.CtrlInfoChecker;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.group.rel.collect.AbstractDataCollector;

public class GroupConditionCollector
extends AbstractDataCollector {
    private GroupConditionCollector() {
    }

    public static GroupConditionCollector create(CtrlInfoChecker checker) {
        GroupConditionCollector collector = new GroupConditionCollector();
        collector.setChecker(checker);
        return collector;
    }

    @Override
    public void collect(Collection<SettleBillModel> models, Collection<DynamicObject> dynaObjs) {
        HashSet<String> dimField = new HashSet<String>(16);
        for (DynamicObject groupCondtionObj : dynaObjs) {
            DynamicObjectCollection groupEntries = groupCondtionObj.getDynamicObjectCollection("gmatchconditions");
            for (DynamicObject entry : groupEntries) {
                String dimKey = entry.getString("gconditiondimkey");
                dimField.add(dimKey);
                String conditionValueStr = entry.getString("gconditionvaluestr_tag");
                List list = SerializationUtils.fromJsonStringToList((String)conditionValueStr, Object.class);
                ArrayList<Long> groupIds = new ArrayList<Long>(list.size());
                for (Object groupId : list) {
                    groupIds.add(Long.valueOf(String.valueOf(groupId)));
                }
                DynamicObject relObj = entry.getDynamicObject("grouprelation");
                String groupEntity = relObj.getString("groupobj.number");
                CommonUtils.mapGetSetValue(this.getGroupIdsMap(), groupEntity).addAll(groupIds);
            }
        }
        this.getModelDataFields().addAll(dimField);
        this.collectData(models);
    }
}

