/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.log;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.scmc.ism.business.helper.BillBusinessHelper;
import kd.scmc.ism.common.utils.CommonUtils;

public class SettleLogBatchChecker {
    public static final String LOG_CHECK_SE_VPE = "SE-VPE";
    public static final String LOG_CHECK_SE_VANE = "SE-VANE";
    public static final String LOG_CHECK_SNE_VAE = "SNE-AE";
    public static final String LOG_CHECK_SNE_VPE = "SNE-VPE";
    public static final String LOG_CHECK_SNE_VANE = "SNE-VANE";
    private Map<Long, Long> logIdToSrcBillIds = new HashMap<Long, Long>(128);
    private Map<Long, List<Long>> logIdToSettleBillIds = new HashMap<Long, List<Long>>(128);
    private Map<String, Set<Long>> entityToIds = new HashMap<String, Set<Long>>(128);

    public void addLogSrcInfo(long logid, long srcbillid, String entity) {
        this.logIdToSrcBillIds.put(logid, srcbillid);
        CommonUtils.mapGetSetValue(this.entityToIds, entity).add(srcbillid);
    }

    public void addLogSettleInfo(long logid, long settlebillid, String entity) {
        CommonUtils.mapGetListValue(this.logIdToSettleBillIds, logid).add(settlebillid);
        CommonUtils.mapGetSetValue(this.entityToIds, entity).add(settlebillid);
    }

    public Map<Long, String> doCheck() {
        HashMap<Long, String> logChecks = new HashMap<Long, String>(1024);
        Map<Long, String> billInfo = BillBusinessHelper.getBillStatusInfo(this.entityToIds);
        for (Map.Entry<Long, List<Long>> checkEntry : this.logIdToSettleBillIds.entrySet()) {
            Long logid = checkEntry.getKey();
            Long srcbillId = this.logIdToSrcBillIds.get(logid);
            List<Long> settleBillIds = checkEntry.getValue();
            boolean srcExist = billInfo.get(srcbillId) != null;
            boolean vBillExist = false;
            boolean vBillDelete = false;
            for (Long settleBillId : settleBillIds) {
                if (billInfo.get(settleBillId) != null) {
                    vBillExist = true;
                    continue;
                }
                vBillDelete = true;
            }
            String checkType = null;
            if (srcExist) {
                if (!vBillDelete) continue;
                checkType = vBillExist ? LOG_CHECK_SE_VPE : LOG_CHECK_SE_VANE;
            } else {
                checkType = !vBillDelete ? LOG_CHECK_SNE_VAE : (vBillExist ? LOG_CHECK_SNE_VPE : LOG_CHECK_SNE_VANE);
            }
            logChecks.put(logid, checkType);
        }
        return logChecks;
    }
}

