/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.log;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.scmc.ism.business.helper.BillBusinessHelper;
import kd.scmc.ism.business.helper.SettleLogHelper;
import kd.scmc.ism.common.result.BatchBillOpResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.flow.BillBatchFlowExecutor;

public class SettleLogBatchFixer {
    private Map<String, List<Long>> handleFixLogs = new HashMap<String, List<Long>>(64);

    public void addErroLogInfo(long logid, String checkType) {
        List<Long> logIds = CommonUtils.mapGetListValue(this.handleFixLogs, checkType);
        logIds.add(logid);
    }

    public Map<Long, String> doFix() {
        ArrayList<Long> updateLogStatusIds = new ArrayList<Long>(64);
        ArrayList<Long> doUnSettleIds = new ArrayList<Long>(64);
        for (Map.Entry<String, List<Long>> entryFixs : this.handleFixLogs.entrySet()) {
            String checkType;
            switch (checkType = entryFixs.getKey()) {
                case "SE-VANE": 
                case "SNE-VANE": {
                    updateLogStatusIds.addAll((Collection<Long>)entryFixs.getValue());
                    break;
                }
                default: {
                    doUnSettleIds.addAll((Collection<Long>)entryFixs.getValue());
                }
            }
            entryFixs.getValue();
        }
        SettleLogBatchFixer.doLogUpdate(updateLogStatusIds);
        return SettleLogBatchFixer.doUnsettle(doUnSettleIds);
    }

    public static Map<Long, String> doUnsettle(List<Long> logIds) {
        if (CommonUtils.collectionIsEmpty(logIds)) {
            return new HashMap<Long, String>(0);
        }
        DynamicObject[] logs = SettleLogHelper.getSimpleLogInfo(new QFilter("id", "in", logIds));
        Map<String, Set<Object>> generateBills = SettleLogHelper.getGenerateBillsFromLogs(Arrays.asList(logs));
        BillBatchFlowExecutor executor = new BillBatchFlowExecutor();
        for (Map.Entry<String, Set<Object>> billtypeIds : generateBills.entrySet()) {
            DynamicObject[] simpleBillInfo = BillBusinessHelper.getSimpleBillInfo(billtypeIds.getKey(), new QFilter("id", "in", billtypeIds.getValue()));
            executor.addBills(Arrays.asList(simpleBillInfo));
        }
        BatchBillOpResult positiveExecute = executor.negativeExecute();
        OperationServiceHelper.executeOperate((String)"logupdate", (String)"ism_settlelog", (Object[])logIds.toArray(), (OperateOption)OperateOption.create());
        if (positiveExecute.isSuccess()) {
            return new HashMap<Long, String>(0);
        }
        return positiveExecute.getFailReasonInfo();
    }

    public static void doLogUpdate(List<Long> logIds) {
        if (CommonUtils.collectionIsEmpty(logIds)) {
            return;
        }
        String sql = "update t_ism_settlelog set fcreatestatus = 'D', fbillfailcause = ' ' where " + new QFilter("fid", "in", logIds).toString();
        DBRoute dbRoute = new DBRoute(EntityMetadataCache.getDataEntityType((String)"ism_settlelog").getDBRouteKey());
        try (TXHandle txHandle = TX.requiresNew((String)"SettleLogBatchFixer.doLogUpdate");){
            DB.execute((DBRoute)dbRoute, (String)sql);
        }
    }
}

