/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.log;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.scmc.ism.common.utils.SettleLogUtils;
import kd.scmc.ism.model.log.SettleLogStatusCalculator;

public class SettleLogBatchUpdater {
    private Map<Long, SettleLogStatusCalculator> headStatus = new HashMap<Long, SettleLogStatusCalculator>(16);
    private List<Object[]> updateEntryParams = new ArrayList<Object[]>(16);

    public void addSettleStatusInfo(Long srcbillId, Long settleBillId, String status, String failReason) {
        SettleLogStatusCalculator calculator = this.getStatusCalculator(srcbillId);
        calculator.addSettleBillAndStatus(settleBillId, status);
        this.updateEntryParams.add(new Object[]{SettleLogUtils.tansferToLogStatus(status), SettleLogUtils.entryErroMsgCutDown(failReason), settleBillId});
    }

    public String getLogStatus(Long srcbillId) {
        return this.getStatusCalculator(srcbillId).calStatus();
    }

    private SettleLogStatusCalculator getStatusCalculator(Long srcbillId) {
        SettleLogStatusCalculator statusCalculator = this.headStatus.get(srcbillId);
        if (statusCalculator == null) {
            statusCalculator = new SettleLogStatusCalculator(srcbillId);
            this.headStatus.put(srcbillId, statusCalculator);
        }
        return statusCalculator;
    }

    public void updateLogInfo() {
        DBRoute dbRoute = new DBRoute(EntityMetadataCache.getDataEntityType((String)"ism_settlelog").getDBRouteKey());
        ArrayList<Object[]> updateHeadParams = new ArrayList<Object[]>(64);
        for (Map.Entry<Long, SettleLogStatusCalculator> entry : this.headStatus.entrySet()) {
            updateHeadParams.add(new Object[]{entry.getValue().calStatus(), entry.getKey()});
        }
        try (TXHandle txHandle = TX.requiresNew((String)this.getClass().getName());){
            if (!updateHeadParams.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)"update t_ism_settlelog set fcreatestatus = ?, fbillfailcause = ' ' where fsourceid = ?", updateHeadParams);
            }
            if (!this.updateEntryParams.isEmpty()) {
                DB.executeBatch((DBRoute)dbRoute, (String)"update t_ism_settlelog_detail set fbillstatus = ? , ffailcause = ? where fsettlebillid = ?", this.updateEntryParams);
                this.updateEntryParams.clear();
            }
        }
    }
}

