/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.mapcfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.bos.entity.property.TimeProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.mapcfg.fieldinfo.BillFieldInfo;

public class SettleBillMapCfg {
    private Map<String, Map<String, BillFieldInfo>> tgtfieldMap = new HashMap<String, Map<String, BillFieldInfo>>(16);
    private BasedataEntityType modelEntity = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)"ism_billmapcfg");

    private SettleBillMapCfg() {
    }

    public static SettleBillMapCfg buildAll() {
        QFilter qFilter1 = new QFilter("targetobj", "=", (Object)"ism_billmapcfg");
        QFilter qFilter2 = new QFilter("bizapp", "=", (Object)"057C+RJ/1S7U");
        QFilter qFilter3 = new QFilter("isenable", "=", (Object)Boolean.TRUE);
        Map billFieldsMap = BusinessDataReader.loadFromCache((String)"sbs_billfieldmapping", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3});
        if (billFieldsMap == null) {
            return null;
        }
        SettleBillMapCfg cfg = new SettleBillMapCfg();
        cfg.init(billFieldsMap.values());
        return cfg;
    }

    public void init(Collection<DynamicObject> billFieldsMap) {
        for (DynamicObject dynamicObject : billFieldsMap) {
            this.loadFieldMapData(dynamicObject);
        }
        for (Map.Entry entry : this.tgtfieldMap.entrySet()) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)((String)entry.getKey()));
            BillFieldInfo fieldMap = (BillFieldInfo)((Map)entry.getValue()).get("billentry");
            if (fieldMap != null && this.billEntryFieldValidate(entityType.getAllEntities(), fieldMap.getSrcBillFieldKey())) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u4e3a\u201c%s\u201d\u7684\u7ed3\u7b97\u5355\u636e\u6620\u5c04\u914d\u7f6e\u7684\u5206\u5f55\u6807\u8bc6\u914d\u7f6e\u9519\u8bef\uff0c\u8bf7\u914d\u7f6e\u6b63\u786e\u7684\u5355\u636e\u5206\u5f55\u6807\u8bc6\u3002", (String)"ISM-W-810120", (String)"scmc-ism-form", (Object[])new Object[]{entityType.getDisplayName().getLocaleValue()}));
        }
    }

    private void loadFieldMapData(DynamicObject billFields) {
        String sourceBillEntity = billFields.getString("sourcebill.number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)sourceBillEntity);
        HashMap<String, BillFieldInfo> billFieldMap = new HashMap<String, BillFieldInfo>(16);
        DynamicObjectCollection colsMap = billFields.getDynamicObjectCollection("colsmap");
        for (DynamicObject cols : colsMap) {
            String key = cols.getString("targetobjcol");
            String value = cols.getString("sourcebillcol");
            BillFieldInfo fieldInfo = BillFieldInfo.build(value);
            IDataEntityProperty property = (IDataEntityProperty)entityType.getAllFields().get(fieldInfo.getBillFieldKey());
            fieldInfo.setProp(property);
            billFieldMap.put(key, fieldInfo);
        }
        this.tgtfieldMap.put(sourceBillEntity, billFieldMap);
    }

    private boolean billEntryFieldValidate(Map<String, EntityType> entities, String value) {
        Class<?> classType;
        return entities.containsKey(value) && EntryType.class.equals(classType = entities.get(value).getClass());
    }

    public BillFieldInfo getSrcFieldInfo(String srcBillEntityType, String fieldKey) {
        Map<String, BillFieldInfo> srcFields = this.getBillFieldInfoMap(srcBillEntityType);
        if (CommonUtils.mapIsEmpty(srcFields)) {
            return null;
        }
        return srcFields.get(fieldKey);
    }

    public String getFieldSrcKey(String srcBillEntityType, String fieldKey) {
        BillFieldInfo fieldInfo = this.getSrcFieldInfo(srcBillEntityType, fieldKey);
        if (fieldInfo == null) {
            return null;
        }
        return fieldInfo.getSrcBillFieldKey();
    }

    public String getFieldKey(String srcBillEntityType, String fieldKey) {
        BillFieldInfo fieldInfo = this.getSrcFieldInfo(srcBillEntityType, fieldKey);
        if (fieldInfo == null) {
            return null;
        }
        return fieldInfo.getBillFieldKey();
    }

    public int getFieldLoc(String srcBillEntityType, String fieldKey) {
        BillFieldInfo fieldInfo = this.getSrcFieldInfo(srcBillEntityType, fieldKey);
        if (fieldInfo == null) {
            return 0;
        }
        return fieldInfo.getKeyloc();
    }

    public Map<String, BillFieldInfo> getBillFieldInfoMap(String srcBillEntityType) {
        return this.tgtfieldMap.get(srcBillEntityType);
    }

    public List<String> getSelectFields(String srcBillEntityType, Collection<String> modelfields) {
        Map<String, BillFieldInfo> srcBillDataMap = this.getBillFieldInfoMap(srcBillEntityType);
        ArrayList<String> selectFields = new ArrayList<String>();
        for (String modelField : modelfields) {
            BillFieldInfo billField = srcBillDataMap.get(modelField);
            IDataEntityProperty modelProp = this.modelEntity.findProperty(modelField);
            if (modelProp == null) continue;
            if (billField == null) {
                if (modelProp instanceof BasedataProp || modelProp instanceof DecimalProp) {
                    selectFields.add("0 as " + modelField);
                    continue;
                }
                if (modelProp instanceof TextProp) {
                    selectFields.add("'' as " + modelField);
                    continue;
                }
                if (!(modelProp instanceof TimeProp)) continue;
                selectFields.add("'' as " + modelField);
                continue;
            }
            selectFields.add(billField.getSrcBillFieldKey() + " as " + modelField);
        }
        return selectFields;
    }

    public BasedataEntityType getModelEntity() {
        return this.modelEntity;
    }

    public Set<String> getBillEntitys() {
        return this.tgtfieldMap.keySet();
    }

    public boolean isContain(String name) {
        return this.tgtfieldMap.containsKey(name);
    }
}

