/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.groupstrategy.IMatchGroupStrategy;
import kd.scmc.ism.model.match.groupstrategy.impl.NoGroupStrategy;
import kd.scmc.ism.model.match.unit.AbstractMatchUnit;

public abstract class AbstractMatchEngine<T extends AbstractMatchUnit> {
    private Map<String, List<T>> units = new HashMap<String, List<T>>(16);
    private Map<Long, T> idToObj = new HashMap<Long, T>(16);
    private final IMatchGroupStrategy groupStrategy;
    private Comparator<AbstractMatchUnit> comparator = null;

    protected AbstractMatchEngine(IMatchGroupStrategy groupStrategy) {
        if (groupStrategy == null) {
            groupStrategy = new NoGroupStrategy();
        }
        this.groupStrategy = groupStrategy;
    }

    public void loadObjs(Collection<DynamicObject> objs) {
        for (DynamicObject dynamicObject : objs) {
            Long objId = DynamicObjectUtil.getPkValue(dynamicObject);
            if (this.idToObj.containsKey(objId)) continue;
            T unit = this.buildUnit(dynamicObject);
            this.idToObj.put(objId, unit);
            if (!this.isInMatchList(unit)) continue;
            String key = this.groupStrategy.buildGroupKey((AbstractMatchUnit)unit);
            List<T> unitList = this.units.get(key);
            if (unitList == null) {
                unitList = new ArrayList<T>(16);
                this.units.put(key, unitList);
            }
            unitList.add(unit);
        }
        if (this.comparator != null) {
            for (List list : this.units.values()) {
                Collections.sort(list, this.comparator);
            }
        }
    }

    protected boolean isInMatchList(T obj) {
        return obj != null;
    }

    protected abstract T buildUnit(DynamicObject var1);

    public MatchResult<T> doMatch(MatchArgs args) {
        Object unit = null;
        unit = args.getResultId() != 0L ? (Object)this.directMatch(args) : (Object)this.groupMatch(args);
        return new MatchResult<Object>(args, unit);
    }

    private T directMatch(MatchArgs args) {
        return this.getResultById(args.getResultId());
    }

    private T groupMatch(MatchArgs args) {
        String key = this.groupStrategy.parseToGroupKey(args);
        List<T> indexedUnits = this.units.get(key);
        if (CommonUtils.collectionIsEmpty(indexedUnits)) {
            return null;
        }
        for (AbstractMatchUnit unit : indexedUnits) {
            boolean match = unit.isMatch(args);
            if (!match) continue;
            return (T)unit;
        }
        return null;
    }

    public T getResultById(Long id) {
        return (T)((AbstractMatchUnit)this.idToObj.get(id));
    }

    protected void setUnitsComparator(Comparator<AbstractMatchUnit> comparator) {
        this.comparator = comparator;
    }

    protected Map<String, List<T>> getUnits() {
        return this.units;
    }

    public Collection<DynamicObject> getAllObjs() {
        ArrayList<DynamicObject> objs = new ArrayList<DynamicObject>(this.idToObj.size());
        Collection<T> values = this.idToObj.values();
        for (AbstractMatchUnit t : values) {
            objs.add(t.getResultObject());
        }
        return objs;
    }
}

