/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.engine.impl;

import java.util.Map;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.business.helper.CtrlInfoChecker;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.group.DataGroupClassfier;
import kd.scmc.ism.model.match.engine.impl.SettleRelationMatchEngine;
import kd.scmc.ism.model.match.groupstrategy.IMatchGroupStrategy;
import kd.scmc.ism.model.match.groupstrategy.impl.DynaRelationGroupStrategy;
import kd.scmc.ism.model.match.unit.compare.CombineCompartor;
import kd.scmc.ism.model.match.unit.compare.EffectiveDayCompartor;
import kd.scmc.ism.model.match.unit.compare.PriorityPropCompartor;

public class DynaRelationMatchEngine
extends SettleRelationMatchEngine {
    public static DynaRelationMatchEngine build(DataGroupClassfier classfier, CtrlInfoChecker checker) {
        DynaRelationMatchEngine engine = new DynaRelationMatchEngine(new DynaRelationGroupStrategy());
        engine.setClassfier(classfier);
        CombineCompartor compartors = new CombineCompartor();
        compartors.addComparator(PriorityPropCompartor.getInstance());
        compartors.addComparator(EffectiveDayCompartor.getInstance());
        engine.setUnitsComparator(compartors);
        engine.setCtrlChecker(checker);
        engine.loadDynaRelation();
        return engine;
    }

    protected DynaRelationMatchEngine(IMatchGroupStrategy groupStrategy) {
        super(groupStrategy);
    }

    private void loadDynaRelation() {
        QFilter supDmdFilter = new QFilter("settleorg", "=", (Object)0L).and("owner", "=", (Object)0L);
        QFilter commonQFilter = new QFilter("enable", "=", (Object)Boolean.TRUE).and("isdynapath", "=", (Object)Boolean.TRUE);
        QFilter[] filters = new QFilter[]{supDmdFilter, commonQFilter};
        Map settleRelationObjs = BusinessDataServiceHelper.loadFromCache((String)"ism_settlerelations", (QFilter[])filters);
        if (CommonUtils.mapIsNotEmpty(settleRelationObjs)) {
            this.loadObjs(settleRelationObjs.values());
        }
    }
}

