/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.engine.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.PlainObjBillModel;
import kd.scmc.ism.model.match.engine.AbstractMatchEngine;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.groupstrategy.IMatchGroupStrategy;
import kd.scmc.ism.model.match.groupstrategy.impl.BillTypePropGroupStrategy;
import kd.scmc.ism.model.match.unit.compare.PriorityPropCompartor;
import kd.scmc.ism.model.match.unit.impl.SettleJudgeMatchUnit;

public class SettleJudgeMatchEngine
extends AbstractMatchEngine<SettleJudgeMatchUnit> {
    private boolean isIgnoreStatus = false;

    public static SettleJudgeMatchEngine buildIgnoreStatus(String ... billTypes) {
        SettleJudgeMatchEngine engine = new SettleJudgeMatchEngine(new BillTypePropGroupStrategy());
        engine.isIgnoreStatus = true;
        engine.setUnitsComparator(PriorityPropCompartor.getInstance());
        engine.loadObjs(SettleJudgeMatchEngine.getObjects(billTypes));
        return engine;
    }

    public static SettleJudgeMatchEngine build(String ... billTypes) {
        SettleJudgeMatchEngine engine = new SettleJudgeMatchEngine(new BillTypePropGroupStrategy());
        engine.setUnitsComparator(PriorityPropCompartor.getInstance());
        engine.loadObjs(SettleJudgeMatchEngine.getObjects(billTypes));
        return engine;
    }

    private static Collection<DynamicObject> getObjects(String[] billTypes) {
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        if (CommonUtils.arrayIsNotEmpty(billTypes)) {
            filter.and("bill", "in", (Object)billTypes);
        }
        Map settleJudgements = BusinessDataServiceHelper.loadFromCache((String)"ism_interorgsettlecfg", (String)"id, bill, number, balanceorg, ownerorg, settlerelation, billfilterstr, billfilterstr_tag, priority", (QFilter[])filter.toArray());
        return settleJudgements.values();
    }

    protected SettleJudgeMatchEngine(IMatchGroupStrategy groupStrategy) {
        super(groupStrategy);
    }

    @Override
    protected SettleJudgeMatchUnit buildUnit(DynamicObject obj) {
        DynamicObject billObj = obj.getDynamicObject("bill");
        if (billObj == null) {
            return null;
        }
        if (this.isIgnoreStatus) {
            return SettleJudgeMatchUnit.buildIgnoreStatus(obj);
        }
        return SettleJudgeMatchUnit.build(obj);
    }

    public Map<String, Set<String>> getAllFilterField() {
        HashMap<String, Set<String>> fieldsMap = new HashMap<String, Set<String>>(16);
        Map units = this.getUnits();
        for (Map.Entry entry : units.entrySet()) {
            HashSet<String> fields = new HashSet<String>(32);
            for (SettleJudgeMatchUnit unit : entry.getValue()) {
                fields.addAll(unit.getDimKeys());
            }
            fields.remove(null);
            fields.remove("");
            fieldsMap.put(entry.getKey(), fields);
        }
        return fieldsMap;
    }

    public Map<String, Set<String>> getJudgeFields() {
        HashMap<String, Set<String>> fieldsMap = new HashMap<String, Set<String>>(16);
        Map units = this.getUnits();
        for (Map.Entry entry : units.entrySet()) {
            String entityKey = entry.getKey();
            List<SettleJudgeMatchUnit> judgeUnits = entry.getValue();
            Set<String> fields = this.geJudgeFields(entityKey, judgeUnits);
            fieldsMap.put(entityKey, fields);
        }
        return fieldsMap;
    }

    public Set<String> getJudgeFields(String entity) {
        List<SettleJudgeMatchUnit> list = this.getUnits().get(entity);
        return this.geJudgeFields(entity, list);
    }

    private Set<String> geJudgeFields(String entityKey, List<SettleJudgeMatchUnit> judgeUnits) {
        HashSet<String> fields = new HashSet<String>(32);
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)entityKey);
        for (SettleJudgeMatchUnit unit : judgeUnits) {
            if (unit.isConfigSettleRelation()) {
                fields.add(unit.getSettleRelationKey().getBillFieldKey());
            }
            if (!unit.isConfigSupAndDem()) continue;
            String settleOrgKey = unit.getSettleOrgKey().getBillFieldKey();
            String ownerKey = unit.getOwnerOrgKey().getBillFieldKey();
            fields.addAll(DynamicObjectUtil.getItemClassType(dataEntityType.findProperty(settleOrgKey), dataEntityType.findProperty(ownerKey)));
        }
        return fields;
    }

    public Map<Long, SettleJudgeMatchUnit> quickJudge(String billEntityType, Collection<Long> billIds) {
        HashMap<Long, SettleJudgeMatchUnit> result = new HashMap<Long, SettleJudgeMatchUnit>(billIds.size());
        Set<String> allDimField = this.getAllFilterField().get(billEntityType);
        if (allDimField == null) {
            return result;
        }
        allDimField.add("id");
        String selectFields = CommonUtils.transToStr(allDimField);
        DynamicObjectCollection billInfoObjs = QueryServiceHelper.query((String)billEntityType, (String)selectFields, (QFilter[])new QFilter("id", "in", billIds).toArray());
        for (DynamicObject billInfoObj : billInfoObjs) {
            PlainObjBillModel billModel = new PlainObjBillModel(billInfoObj, billEntityType);
            MatchArgs matchArgs = MatchArgs.buildMatch(billModel);
            MatchResult doSJMatch = this.doMatch(matchArgs);
            if (!doSJMatch.isMatch()) continue;
            result.put(billModel.getId(), (SettleJudgeMatchUnit)doSJMatch.getMatchedUnit());
        }
        return result;
    }
}

