/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.unit.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.ism.business.helper.CtrlInfoChecker;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.ISettleBillModel;
import kd.scmc.ism.model.match.entity.MatchArgs;
import kd.scmc.ism.model.match.unit.AbstractMatchUnit;

public abstract class AbstractExpressionUnit
extends AbstractMatchUnit {
    public static final Log log = LogFactory.getLog(AbstractExpressionUnit.class);
    private CtrlInfoChecker ctrlChecker;
    private BOSExpression expr;

    protected AbstractExpressionUnit(DynamicObject resultObject) {
        super(resultObject);
    }

    @Override
    public boolean isMatch(MatchArgs args) {
        if (this.expr == null) {
            return true;
        }
        Set vars = this.expr.getVars();
        if (vars.isEmpty()) {
            return true;
        }
        Map<String, Object> param = this.buildMatchParam(args, vars);
        boolean result = (Boolean)FormulaEngine.execExcelFormula((Expr)this.expr.getExpr(), param, null);
        return result;
    }

    public Set<String> getDimKeys() {
        HashSet<String> fields = new HashSet<String>(32);
        if (this.expr != null) {
            fields.addAll(this.expr.getVars());
        }
        return fields;
    }

    public void setExpr(BOSExpression expr) {
        this.expr = expr;
    }

    protected Map<String, Object> buildMatchParam(MatchArgs args, Set<String> vars) {
        if (CommonUtils.collectionIsEmpty(vars)) {
            return new HashMap<String, Object>(0);
        }
        HashMap<String, Object> info = new HashMap<String, Object>(vars.size());
        ISettleBillModel billModel = args.getBillModel();
        if (billModel == null) {
            return info;
        }
        for (String var : vars) {
            Object value = billModel.getValue(var);
            if (value instanceof DynamicObject) {
                DynamicObject dynaObj = (DynamicObject)value;
                value = this.getMasterObjectId(dynaObj);
            } else if (value instanceof ILocaleString) {
                ILocaleString localValue = (ILocaleString)value;
                value = localValue.getLocaleValue();
            }
            info.put(var, value);
        }
        return info;
    }

    public void setChecker(CtrlInfoChecker ctrlChecker) {
        this.ctrlChecker = ctrlChecker;
    }

    public CtrlInfoChecker getCtrlChecker() {
        return this.ctrlChecker;
    }

    protected Object getMasterObjectId(DynamicObject dynaObj) {
        CtrlInfoChecker ctrlChecker = this.getCtrlChecker();
        if (ctrlChecker == null) {
            return DynamicObjectUtil.getPkValue(dynaObj);
        }
        return ctrlChecker.getMasterId(dynaObj);
    }
}

