/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.unit.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.utils.control.FilterGridUtils;
import kd.scmc.ism.model.mapcfg.fieldinfo.BillFieldInfo;
import kd.scmc.ism.model.match.unit.impl.AbstractExpressionUnit;
import org.apache.commons.lang.StringUtils;

public class SettleJudgeMatchUnit
extends AbstractExpressionUnit {
    private String billEntityType;
    private BillFieldInfo settleOrgKey;
    private BillFieldInfo ownerOrgKey;
    private BillFieldInfo settleRelationKey;

    public static SettleJudgeMatchUnit build(DynamicObject obj) {
        SettleJudgeMatchUnit settleJudgeMatchUnit = new SettleJudgeMatchUnit(obj);
        settleJudgeMatchUnit.parseBillFilter();
        return settleJudgeMatchUnit;
    }

    public static SettleJudgeMatchUnit buildIgnoreStatus(DynamicObject obj) {
        SettleJudgeMatchUnit settleJudgeMatchUnit = new SettleJudgeMatchUnit(obj);
        settleJudgeMatchUnit.parseBillFilterIgnoreStatus();
        return settleJudgeMatchUnit;
    }

    private SettleJudgeMatchUnit(DynamicObject resultObj) {
        super(resultObj);
        String billtype;
        this.billEntityType = billtype = resultObj.getDynamicObject("bill").getString("number");
        this.settleOrgKey = BillFieldInfo.build(resultObj.getString("balanceorg"));
        this.ownerOrgKey = BillFieldInfo.build(resultObj.getString("ownerorg"));
        this.settleRelationKey = BillFieldInfo.build(resultObj.getString("settlerelation"));
    }

    private void parseBillFilterIgnoreStatus() {
        String filterStr = this.getResultObject().getString("billfilterstr_tag");
        if (StringUtils.isNotEmpty((String)filterStr)) {
            this.setExpr(FilterGridUtils.filterTextToExpressionByAudit(this.getBillEntityType(), filterStr));
        }
    }

    private void parseBillFilter() {
        String filterStr = this.getResultObject().getString("billfilterstr_tag");
        if (StringUtils.isNotEmpty((String)filterStr)) {
            this.setExpr(FilterGridUtils.filterTextToExpression(this.getBillEntityType(), filterStr));
        }
    }

    public BillFieldInfo getSettleOrgKey() {
        return this.settleOrgKey;
    }

    public BillFieldInfo getOwnerOrgKey() {
        return this.ownerOrgKey;
    }

    public BillFieldInfo getSettleRelationKey() {
        return this.settleRelationKey;
    }

    public String getBillEntityType() {
        return this.billEntityType;
    }

    public boolean isConfigSettleRelation() {
        return this.settleRelationKey != null;
    }

    public boolean isConfigSupAndDem() {
        return this.ownerOrgKey != null && this.settleOrgKey != null;
    }
}

