/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.match.unit.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.model.bill.impl.AbstractSettleBillModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;
import kd.scmc.ism.model.match.unit.impl.AbstractConditionMatchUnit;
import kd.scmc.ism.model.vs.IDynaObjHandler;
import kd.scmc.ism.model.vs.IValueSetter;
import kd.scmc.ism.model.vs.ValueSetterFactory;
import kd.scmc.ism.model.vs.impl.BackUpValueSetter;

public class SettleParamMatchUnit
extends AbstractConditionMatchUnit {
    private Map<String, IValueSetter> commonParams = new HashMap<String, IValueSetter>(16);
    private Map<String, IValueSetter> supplierParams = new HashMap<String, IValueSetter>(16);
    private Map<String, IValueSetter> demandParams = new HashMap<String, IValueSetter>(16);

    public static SettleParamMatchUnit build(SettleBillMapCfg mapCfg, DynamicObject resultObject) {
        SettleParamMatchUnit unit = new SettleParamMatchUnit(resultObject);
        unit.initCondition();
        unit.initParamInfo(mapCfg);
        return unit;
    }

    protected SettleParamMatchUnit(DynamicObject resultObject) {
        super(resultObject);
    }

    private void initParamInfo(SettleBillMapCfg mapCfg) {
        BasedataEntityType modelEntity = mapCfg.getModelEntity();
        DynamicObjectCollection entries = this.getResultObject().getDynamicObjectCollection("datainfo");
        for (DynamicObject dataInfoEntry : entries) {
            String columnType;
            String valueStr;
            String valueType;
            String targetType = dataInfoEntry.getString("targetfieldkey");
            IDataEntityProperty property = modelEntity.findProperty(targetType);
            IValueSetter valueSetter = ValueSetterFactory.create((MainEntityType)modelEntity, property, valueType = dataInfoEntry.getString("valuetype"), valueStr = dataInfoEntry.getString("constants_tag"));
            if (valueSetter == null) continue;
            switch (columnType = dataInfoEntry.getString("columntype")) {
                case "sup": {
                    this.supplierParams.put(targetType, valueSetter);
                    break;
                }
                case "dem": {
                    this.demandParams.put(targetType, valueSetter);
                    break;
                }
                case "com": {
                    this.commonParams.put(targetType, valueSetter);
                    break;
                }
            }
        }
    }

    public Map<String, Set<Long>> getDataBaseIds() {
        ArrayList<Collection<IValueSetter>> list = new ArrayList<Collection<IValueSetter>>(3);
        list.add(this.commonParams.values());
        list.add(this.supplierParams.values());
        list.add(this.demandParams.values());
        HashMap<String, Set<Long>> dataIds = new HashMap<String, Set<Long>>(16);
        for (Collection collection : list) {
            for (IValueSetter iValueSetter : collection) {
                if (!(iValueSetter instanceof IDynaObjHandler)) continue;
                IDynaObjHandler dynaHandler = (IDynaObjHandler)((Object)iValueSetter);
                CommonUtils.mapGetSetValue(dataIds, dynaHandler.getEntityType()).addAll(dynaHandler.getIds());
            }
        }
        return dataIds;
    }

    public void setParamToBillModel(SettleBillModel condtionBillModel, SettleBillModel setValueModel, String type) {
        Map<String, IValueSetter> paramsByType = this.getParamsByType(type);
        HashMap<String, IValueSetter> headParams = new HashMap<String, IValueSetter>(paramsByType.size());
        HashMap<String, IValueSetter> entryParams = new HashMap<String, IValueSetter>(paramsByType.size());
        for (Map.Entry<String, IValueSetter> entryInfo : paramsByType.entrySet()) {
            String key = entryInfo.getKey();
            int fieldLoc = setValueModel.getMapCfg().getFieldLoc(setValueModel.getBillEntityType(), key);
            if (1 == fieldLoc) {
                headParams.put(key, entryInfo.getValue());
                continue;
            }
            if (2 != fieldLoc) continue;
            entryParams.put(key, entryInfo.getValue());
        }
        this.setValue(condtionBillModel, setValueModel, headParams);
        List<SettleBillEntryModel> entries = setValueModel.getEntries();
        for (SettleBillEntryModel entry : entries) {
            Long srcEntryId = (Long)entry.getValue("srcbillentryid");
            SettleBillEntryModel srcEntryModel = condtionBillModel.getEntryModel(srcEntryId);
            this.setValue(srcEntryModel, entry, entryParams);
        }
    }

    private Map<String, IValueSetter> getParamsByType(String type) {
        if ("sup".equals(type)) {
            return this.valueSetterCombine(this.supplierParams, this.commonParams);
        }
        if ("dem".equals(type)) {
            return this.valueSetterCombine(this.demandParams, this.commonParams);
        }
        return this.commonParams;
    }

    private Map<String, IValueSetter> valueSetterCombine(Map<String, IValueSetter> main, Map<String, IValueSetter> back) {
        HashMap<String, IValueSetter> newMap = new HashMap<String, IValueSetter>(16);
        newMap.putAll(back);
        for (Map.Entry<String, IValueSetter> entryInfo : main.entrySet()) {
            String key = entryInfo.getKey();
            IValueSetter valueSetter = (IValueSetter)newMap.get(key);
            if (valueSetter != null) {
                newMap.put(key, new BackUpValueSetter(entryInfo.getValue(), valueSetter));
                continue;
            }
            newMap.put(key, entryInfo.getValue());
        }
        return newMap;
    }

    private void setValue(AbstractSettleBillModel condtionBillModel, AbstractSettleBillModel setValueModel, Map<String, IValueSetter> settes) {
        Map<String, Object> valueMap = this.getParamValueMap(condtionBillModel, settes.values());
        for (Map.Entry<String, IValueSetter> entrySet : settes.entrySet()) {
            String key = entrySet.getKey();
            Object value = entrySet.getValue().getValue(valueMap);
            if (value == null) continue;
            setValueModel.setValue(key, value);
        }
    }

    private Map<String, Object> getParamValueMap(AbstractSettleBillModel model, Collection<IValueSetter> setters) {
        HashMap<String, Object> paramToValue = new HashMap<String, Object>(16);
        HashSet<String> paramKeys = new HashSet<String>(16);
        for (IValueSetter iValueSetter : setters) {
            paramKeys.addAll(iValueSetter.getParamKey());
        }
        if (paramKeys.isEmpty() || model == null) {
            return paramToValue;
        }
        for (String paramKey : paramKeys) {
            String[] split = paramKey.split("\\.");
            Object value = null;
            if (split.length == 1) {
                value = model.getValue(split[0]);
            } else if (split.length == 2) {
                DynamicObject obj = (DynamicObject)model.getValue(split[0]);
                value = obj.get(split[1]);
            }
            paramToValue.put(paramKey, value);
        }
        return paramToValue;
    }
}

