/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.relation;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.ism.common.utils.DynamicObjectUtil;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.match.entity.MatchResult;
import kd.scmc.ism.model.match.unit.impl.SettleRelationMatchUnit;
import kd.scmc.ism.model.relation.AbstractRelationModel;
import kd.scmc.ism.model.relation.impl.CommonRelationModel;
import kd.scmc.ism.model.relation.impl.DynaRelationModel;

public class RelationModelFactory {
    public static String buildKey(MatchResult<SettleRelationMatchUnit> matchResult) {
        SettleRelationMatchUnit unit = matchResult.getMatchedUnit();
        Map<String, Object> args = matchResult.getArgs().getAdditonInfo();
        Long supplierId = (Long)args.get("settleorg");
        Long demandId = (Long)args.get("owner");
        return RelationModelFactory.buildKey(supplierId, demandId, unit);
    }

    private static String buildKey(Long defSupId, Long defDemId, SettleRelationMatchUnit unit) {
        DynamicObject relationObj = unit.getResultObject();
        String mark = null;
        Long supplierId = 0L;
        Long demandId = 0L;
        if (relationObj.getBoolean("isdynapath")) {
            mark = "DYNA";
            supplierId = defSupId;
            demandId = defDemId;
        } else {
            mark = "STAT";
            supplierId = DynamicObjectUtil.getPkValue(relationObj.getDynamicObject("settleorg"));
            demandId = DynamicObjectUtil.getPkValue(relationObj.getDynamicObject("owner"));
        }
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(mark);
        keyBuilder.append('-');
        keyBuilder.append(DynamicObjectUtil.getPkValue(relationObj));
        keyBuilder.append('-');
        keyBuilder.append(supplierId);
        keyBuilder.append('-');
        keyBuilder.append(demandId);
        return keyBuilder.toString();
    }

    public static AbstractRelationModel create(MatchResult<SettleRelationMatchUnit> matchResult, SettleBillModel billModel) {
        SettleRelationMatchUnit unit = matchResult.getMatchedUnit();
        DynamicObject relationObj = unit.getResultObject();
        boolean isDynaPath = relationObj.getBoolean("isdynapath");
        if (isDynaPath) {
            Map<String, Object> args = matchResult.getArgs().getAdditonInfo();
            Long supplierId = (Long)args.get("settleorg");
            Long demandId = (Long)args.get("owner");
            return new DynaRelationModel(relationObj, billModel, supplierId, demandId);
        }
        return new CommonRelationModel(relationObj, billModel);
    }
}

