/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.vs;

import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.TextProp;
import kd.scmc.ism.model.vs.IValueSetter;
import kd.scmc.ism.model.vs.impl.AbstractCondtionValueSetter;
import kd.scmc.ism.model.vs.impl.AbstractConstsValueSetter;
import kd.scmc.ism.model.vs.impl.BooleanConstsValueSetter;
import kd.scmc.ism.model.vs.impl.DateTimeConstsValueSetter;
import kd.scmc.ism.model.vs.impl.DecimalConstsValueSetter;
import kd.scmc.ism.model.vs.impl.DynaObjDummyConditionValueSetter;
import kd.scmc.ism.model.vs.impl.DynaObjDummyConstsValueSetter;
import kd.scmc.ism.model.vs.impl.TextConditionValueSetter;
import kd.scmc.ism.model.vs.impl.TextConstsValueSetter;

public class ValueSetterFactory {
    public static IValueSetter create(MainEntityType conditionEntity, IDataEntityProperty prop, String type, String valueStr) {
        IValueSetter valueSetter = null;
        if ("c".equals(type)) {
            valueSetter = ValueSetterFactory.createCondition(conditionEntity, prop, valueStr);
        } else if ("e".equals(type)) {
            valueSetter = ValueSetterFactory.createConsts(prop, valueStr);
        }
        return valueSetter;
    }

    public static IValueSetter createConsts(IDataEntityProperty prop, String valueStr) {
        AbstractConstsValueSetter valueSetter = null;
        if (prop instanceof BasedataProp) {
            valueSetter = new DynaObjDummyConstsValueSetter(((BasedataProp)prop).getBaseEntityId(), valueStr);
        } else if (prop instanceof DecimalProp) {
            valueSetter = new DecimalConstsValueSetter(valueStr);
        } else if (prop instanceof DateTimeProp) {
            valueSetter = new DateTimeConstsValueSetter(valueStr);
        } else if (prop instanceof BooleanProp) {
            valueSetter = new BooleanConstsValueSetter(valueStr);
        } else if (prop instanceof TextProp || prop instanceof ComboProp) {
            valueSetter = new TextConstsValueSetter(valueStr);
        }
        return valueSetter;
    }

    public static IValueSetter createCondition(MainEntityType conditionEntity, IDataEntityProperty prop, String valueStr) {
        AbstractCondtionValueSetter valueSetter = null;
        if (prop instanceof BasedataProp) {
            BasedataProp bdProp = (BasedataProp)prop;
            valueSetter = new DynaObjDummyConditionValueSetter(conditionEntity, bdProp.getBaseEntityId(), valueStr);
        } else if (prop instanceof TextProp || prop instanceof ComboProp) {
            valueSetter = new TextConditionValueSetter(conditionEntity, valueStr);
        }
        return valueSetter;
    }
}

