/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.model.vs.condition;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.botp.CRFormula;
import kd.bos.entity.botp.CRValByCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;

public class CondtionValExpressionUnit {
    private int seq = 999;
    private BOSExpression conExpr = null;
    private String valExpr = null;

    public static CondtionValExpressionUnit create(MainEntityType conditionEntityType, CRValByCondition condtion) {
        if (condtion == null || conditionEntityType == null) {
            return null;
        }
        BOSExpression condtionExpr = null;
        CRCondition condition = condtion.getCondition();
        if (condition != null) {
            FilterBuilder filterBuilder = new FilterBuilder(conditionEntityType, condition.getFilterCondition());
            String conditionStr = filterBuilder.buildFilterScript()[0];
            condtionExpr = new BOSExpression(conditionStr);
        }
        String valExpr = null;
        CRFormula formula = condtion.getFormula();
        if (formula != null) {
            valExpr = formula.getExpression();
        }
        CondtionValExpressionUnit unit = new CondtionValExpressionUnit(condtion.getSeq(), condtionExpr, valExpr);
        return unit;
    }

    private CondtionValExpressionUnit(int seq, BOSExpression conExpr, String valExpr) {
        this.seq = seq;
        this.conExpr = conExpr;
        this.valExpr = valExpr;
    }

    public Set<String> getParamKeys() {
        HashSet<String> keys = new HashSet<String>(16);
        if (this.conExpr != null) {
            keys.addAll(this.conExpr.getVars());
        }
        return keys;
    }

    public boolean isMatch(Map<String, Object> params) {
        if (this.conExpr != null) {
            return (Boolean)FormulaEngine.execExcelFormula((Expr)this.conExpr.getExpr(), params, null);
        }
        return true;
    }

    public BOSExpression getConExpr() {
        return this.conExpr;
    }

    public int getSeq() {
        return this.seq;
    }

    public String getValExpr() {
        return this.valExpr;
    }
}

