/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.mservice.settlebill;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.ism.business.action.SettleActionFactory;
import kd.scmc.ism.business.action.SettleActionProcessor;
import kd.scmc.ism.common.model.ISMRequestContext;
import kd.scmc.ism.common.model.ISMServiceContext;
import kd.scmc.ism.common.model.assist.MainBillAssistant;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.lang.MServiceLang;
import kd.scmc.ism.model.batexec.BizBatchProcessor;
import kd.scmc.ism.model.batexec.handle.IBizExecutor;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillEntriesModel;
import kd.scmc.ism.model.bill.impl.CoupleSettleBillsModel;
import kd.scmc.ism.model.bill.impl.SelfCoupleSettleBilModel;
import kd.scmc.ism.model.bill.impl.SettleBillEntryModel;
import kd.scmc.ism.model.bill.impl.SettleBillModel;
import kd.scmc.ism.model.mapcfg.SettleBillMapCfg;
import kd.scmc.ism.mservice.api.SettlePriceRuleService;

public class SettlePriceRuleServiceImpl
implements SettlePriceRuleService {
    public static final Log log = LogFactory.getLog(SettlePriceRuleService.class);
    private ISMServiceContext serviceContext = null;

    @Override
    public Map<Long, Map<String, Object>> doBillPricing(final String entity, List<Long> billIds) {
        BizBatchProcessor<Long, Map<Long, Map<String, Object>>> processor = new BizBatchProcessor<Long, Map<Long, Map<String, Object>>>(new IBizExecutor<Long, Map<Long, Map<String, Object>>>(){

            @Override
            public Map<Long, Map<String, Object>> execute(List<Long> elements) {
                return SettlePriceRuleServiceImpl.this.billPrice(entity, elements);
            }
        });
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(16);
        processor.addAllAndExec(billIds);
        List<Map<Long, Map<String, Object>>> doProcess = processor.doProcess();
        for (Map<Long, Map<String, Object>> map : doProcess) {
            result.putAll(map);
        }
        return result;
    }

    private Map<Long, Map<String, Object>> billPrice(String entity, List<Long> billIds) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entity);
        SettleBillMapCfg mapCfg = this.getServiceContext().getMapCfg();
        if (!mapCfg.getBillEntitys().contains(entity)) {
            log.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u53d6\u4ef7\u63a5\u53e3\uff1a\u5355\u636e\u5b9e\u4f53%s\u672a\u914d\u7f6e\u7ed3\u7b97\u5355\u636e\u6620\u5c04\u3002", entity));
            throw new KDBizException(MServiceLang.billNotConfigMapping(entity));
        }
        ArrayList<Long> ids = new ArrayList<Long>(16);
        for (Long billId : billIds) {
            ids.add(billId);
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])ids.toArray(new Object[ids.size()]), (DynamicObjectType)type);
        if (bills == null || bills.length == 0) {
            String failNoReson = String.valueOf(billIds);
            log.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u53d6\u4ef7\u63a5\u53e3\uff1a\u5355\u636e%s\u4e0d\u5b58\u5728\u3002", failNoReson));
            throw new KDBizException(MServiceLang.billNotExist(failNoReson));
        }
        ISMRequestContext req = ISMRequestContext.create(entity, billIds);
        for (DynamicObject bill : bills) {
            req.addSrcBillModel(SettleBillModel.build(bill, mapCfg));
        }
        SettleActionProcessor.build(SettleActionFactory.buildBillPricingActions(), this.getServiceContext()).doProcess(req);
        return this.parsePriceInfo(req);
    }

    private Map<Long, Map<String, Object>> parsePriceInfo(ISMRequestContext req) {
        HashMap<Long, Map<String, Object>> billInfos = new HashMap<Long, Map<String, Object>>(16);
        List<CoupleSettleBillsModel> supDemBillInfos = req.getSupDemBillInfos();
        for (CoupleSettleBillsModel cpModel : supDemBillInfos) {
            billInfos.putAll(this.parsePriceModelInfo(cpModel));
        }
        return billInfos;
    }

    private Map<Long, Map<String, Object>> parsePriceModelInfo(CoupleSettleBillsModel cpModel) {
        HashMap<Long, Map<String, Object>> mapInfo = new HashMap<Long, Map<String, Object>>(2);
        DynamicObject priceRuleObj = cpModel.getPriceRuleObj();
        Long settleCurrencyId = cpModel.getSettleCurrencyId();
        Date exRateDate = cpModel.getExRateDate();
        for (CoupleSettleBillEntriesModel cpentry : cpModel.getEntries()) {
            HashMap<String, Object> paramInfo = new HashMap<String, Object>();
            if (priceRuleObj != null) {
                paramInfo.put("priceruleid", priceRuleObj.getPkValue());
                if (settleCurrencyId != null) {
                    paramInfo.put("settlecy", settleCurrencyId);
                }
                if (exRateDate != null) {
                    paramInfo.put("exratedate", exRateDate);
                }
            } else {
                paramInfo.put("failreason", MServiceLang.noMatchedPriceRule());
                mapInfo.put(cpentry.getId(), paramInfo);
                continue;
            }
            DynamicObject priceRuleEntryObj = cpentry.getPriceRuleEntryObj();
            if (priceRuleEntryObj != null) {
                long taxRateId;
                paramInfo.put("priceruleentryid", priceRuleEntryObj.getPkValue());
                if (cpentry.getPriceCurrencyId() != 0L && (cpentry.getRePrice() != null || cpentry.getRePriceWithTax() != null)) {
                    BigDecimal price = cpentry.getCalPrice();
                    BigDecimal taxPrice = cpentry.getCalPriceWithTax();
                    paramInfo.put("price", price);
                    paramInfo.put("priceandtax", taxPrice);
                }
                if ((taxRateId = cpentry.getTaxRateId()) != 0L) {
                    paramInfo.put("taxrateid", taxRateId);
                }
            } else {
                paramInfo.put("failreason", MServiceLang.noMatchedPriceRuleEntry());
            }
            mapInfo.put(cpentry.getId(), paramInfo);
        }
        return mapInfo;
    }

    @Override
    public Map<Long, Map<String, Object>> batchDoPricing(final String entity, List<Map<String, Long>> billInfos) {
        BizBatchProcessor<Map<String, Long>, Map<Long, Map<String, Object>>> bizBatchProcessor = new BizBatchProcessor<Map<String, Long>, Map<Long, Map<String, Object>>>(new IBizExecutor<Map<String, Long>, Map<Long, Map<String, Object>>>(){

            @Override
            public Map<Long, Map<String, Object>> execute(List<Map<String, Long>> elements) {
                return SettlePriceRuleServiceImpl.this.doPrice(entity, elements);
            }
        });
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(16);
        bizBatchProcessor.addAllAndExec(billInfos);
        List<Map<Long, Map<String, Object>>> doProcess = bizBatchProcessor.doProcess();
        for (Map<Long, Map<String, Object>> map : doProcess) {
            result.putAll(map);
        }
        return result;
    }

    private Map<Long, Map<String, Object>> doPrice(String entity, List<Map<String, Long>> billInfos) {
        HashMap<Long, Long> billsupIds = new HashMap<Long, Long>(billInfos.size());
        HashMap<Long, Long> billdemIds = new HashMap<Long, Long>(billInfos.size());
        for (Map<String, Long> billInfoMap : billInfos) {
            Long billId = billInfoMap.get("id");
            Long supId = billInfoMap.get("supid");
            Long demId = billInfoMap.get("demid");
            billsupIds.put(billId, supId);
            billdemIds.put(billId, demId);
        }
        SettleBillMapCfg mapCfg = this.getServiceContext().getMapCfg();
        if (!mapCfg.getBillEntitys().contains(entity)) {
            log.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u53d6\u4ef7\u63a5\u53e3\uff1a\u5355\u636e\u5b9e\u4f53%s\u672a\u914d\u7f6e\u7ed3\u7b97\u5355\u636e\u6620\u5c04\u3002", entity));
            throw new KDBizException(MServiceLang.billNotConfigMapping(entity));
        }
        Map billObjs = BusinessDataServiceHelper.loadFromCache((String)entity, (QFilter[])new QFilter("id", "in", billsupIds.keySet()).toArray());
        if (billObjs.isEmpty()) {
            String failNoReson = billsupIds.keySet().toString();
            log.info(String.format("\u7ec4\u7ec7\u95f4\u7ed3\u7b97\u53d6\u4ef7\u63a5\u53e3\uff1a\u5355\u636e%s\u4e0d\u5b58\u5728\u3002", failNoReson));
            throw new KDBizException(MServiceLang.billNotExist(failNoReson));
        }
        ISMRequestContext req = ISMRequestContext.create();
        MainBillAssistant billAssistant = this.getServiceContext().getBillAssistant();
        for (DynamicObject bill : billObjs.values()) {
            SettleBillModel billModel = SettleBillModel.build(bill, mapCfg);
            long billId = billModel.getId();
            String srcBillEntity = (String)billModel.getValue("srcbillentity");
            Long srcBillId = (Long)billModel.getValue("srcbillid");
            billAssistant.preLoadData(srcBillEntity, srcBillId);
            SelfCoupleSettleBilModel cpModel = SelfCoupleSettleBilModel.buildSingle(billModel);
            cpModel.setSupplierId((Long)billsupIds.get(billId));
            cpModel.setDemandId((Long)billdemIds.get(billId));
            req.addSupDemBillInfo(cpModel);
        }
        for (CoupleSettleBillsModel cpModel : req.getSupDemBillInfos()) {
            String srcBillEntity = (String)cpModel.getValue("srcbillentity");
            Long srcBillId = (Long)cpModel.getValue("srcbillid");
            if (StringUtils.isEmpty((CharSequence)srcBillEntity) || CommonUtils.idIsNull(srcBillId)) continue;
            List<CoupleSettleBillEntriesModel> entries = cpModel.getEntries();
            for (CoupleSettleBillEntriesModel entry : entries) {
                SettleBillModel billModel = billAssistant.getMainBillObj(entry.getSrcBillEntity(), entry.getSrcBillId());
                if (billModel == null) continue;
                SettleBillEntryModel srcEntryModel = billModel.getEntryModel(entry.getSrcEntryId());
                entry.setSrcBillModel(srcEntryModel);
            }
        }
        SettleActionProcessor.build(SettleActionFactory.buildPricingActions(), this.getServiceContext()).doProcess(req);
        return this.parseMapInfo(req);
    }

    private Map<Long, Map<String, Object>> parseMapInfo(ISMRequestContext req) {
        HashMap<Long, Map<String, Object>> billInfos = new HashMap<Long, Map<String, Object>>(16);
        List<CoupleSettleBillsModel> supDemBillInfos = req.getSupDemBillInfos();
        for (CoupleSettleBillsModel cpModel : supDemBillInfos) {
            billInfos.putAll(this.parseModelInfo(cpModel));
        }
        return billInfos;
    }

    private Map<Long, Map<String, Object>> parseModelInfo(CoupleSettleBillsModel cpModel) {
        HashMap<Long, Map<String, Object>> mapInfo = new HashMap<Long, Map<String, Object>>(2);
        DynamicObject priceRuleObj = cpModel.getPriceRuleObj();
        for (SettleBillModel billModel : cpModel.getModels()) {
            Long billId = billModel.getId();
            Map<String, Object> paramInfo = CommonUtils.mapGetMapValue(mapInfo, billId);
            if (priceRuleObj != null) {
                Date exRateDate;
                Long settleCurrencyId = cpModel.getSettleCurrencyId();
                if (settleCurrencyId != null) {
                    paramInfo.put("settlecy", settleCurrencyId);
                }
                if ((exRateDate = cpModel.getExRateDate()) == null) continue;
                paramInfo.put("exratedate", exRateDate);
                continue;
            }
            paramInfo.put("failreason", MServiceLang.noMatchedPriceRule());
        }
        for (CoupleSettleBillEntriesModel cpentry : cpModel.getEntries()) {
            DynamicObject priceRuleEntryObj = cpentry.getPriceRuleEntryObj();
            for (SettleBillEntryModel entryModel : cpentry.getModels()) {
                long billId = entryModel.getBillModel().getId();
                Map<String, Object> billInfo = CommonUtils.mapGetMapValue(mapInfo, billId);
                HashMap entriesInfo = (HashMap)billInfo.get("billentry");
                if (entriesInfo == null) {
                    entriesInfo = new HashMap(16);
                    billInfo.put("billentry", entriesInfo);
                }
                HashMap<String, Object> priceInfo = new HashMap<String, Object>(3);
                if (priceRuleEntryObj != null) {
                    long taxRateId;
                    if (cpentry.getPriceCurrencyId() != 0L && (cpentry.getRePrice() != null || cpentry.getRePriceWithTax() != null)) {
                        BigDecimal price = (BigDecimal)entryModel.getValueFromSrcObj("price");
                        BigDecimal taxPrice = (BigDecimal)entryModel.getValueFromSrcObj("priceandtax");
                        priceInfo.put("price", price);
                        priceInfo.put("priceandtax", taxPrice);
                    }
                    if ((taxRateId = cpentry.getTaxRateId()) != 0L) {
                        priceInfo.put("taxrateid", taxRateId);
                    }
                } else {
                    priceInfo.put("failreason", MServiceLang.noMatchedPriceRuleEntry());
                }
                entriesInfo.put(entryModel.getId(), priceInfo);
            }
        }
        return mapInfo;
    }

    public ISMServiceContext getServiceContext() {
        if (this.serviceContext == null) {
            this.serviceContext = ISMServiceContext.buildOnlyService();
        }
        return this.serviceContext;
    }
}

