/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.ism.common.utils.control.FilterGridUtils;
import kd.scmc.ism.lang.ValidateLang;

public class FilterControlExprLegalValidator
extends AbstractValidator {
    private final String billTypeKey;
    private final String filterControlKey;

    public FilterControlExprLegalValidator(String bill, String filterControlKey) {
        this.filterControlKey = filterControlKey;
        this.billTypeKey = bill;
    }

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject object = dataEntity.getDataEntity();
            DynamicObject billtypeObj = object.getDynamicObject(this.billTypeKey);
            if (billtypeObj == null) continue;
            String filterStr = object.getString(this.filterControlKey);
            String billtype = billtypeObj.getString("number");
            try {
                BOSExpression expression = FilterGridUtils.filterTextToExpression(billtype, filterStr);
                if (!expression.isError()) continue;
                this.addErrorMessage(dataEntity, ValidateLang.billFilterTagParseErro(expression.getErrMessage()));
            }
            catch (Exception e) {
                this.addErrorMessage(dataEntity, ValidateLang.billFilterTagParseErro(e.getMessage()));
            }
        }
    }
}

