/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;
import kd.scmc.ism.business.helper.MatchConditionHelper;
import kd.scmc.ism.lang.ValidateLang;

public class MatchConditionExprLegalValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject entity = dataEntity.getDataEntity();
            String msg = this.conditionValidate(entity.getDynamicObjectCollection("matchconditions"));
            if (StringUtils.isNotEmpty((String)msg)) {
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            String expression = MatchConditionHelper.buildExpression(entity.getDynamicObjectCollection("matchconditions"));
            try {
                BOSExpression expr = new BOSExpression(expression);
                if (!expr.isError()) continue;
                this.addErrorMessage(dataEntity, ValidateLang.matchConditionParseErro());
            }
            catch (Exception e) {
                this.addErrorMessage(dataEntity, ValidateLang.matchConditionParseErro(e.getMessage()));
            }
        }
    }

    private String conditionValidate(DynamicObjectCollection entrys) {
        StringBuilder sb = new StringBuilder();
        for (DynamicObject entry : entrys) {
            String key = entry.getString("conditiondimkey");
            if (!StringUtils.isEmpty((String)key)) continue;
            sb.append(ValidateLang.matchConditionParseError());
            break;
        }
        return sb.toString();
    }
}

