/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.report.form;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.IReportListModel;
import kd.bos.form.IFormView;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.bos.report.events.SortAndFilterEvent;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.business.selectlistener.billmainentity.BillEnableBFM;
import kd.scmc.ism.business.selectlistener.billmainentity.BillEnableSettleJudge;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.control.FormUtils;
import kd.scmc.ism.report.form.AbstractIsmReport;

public abstract class AbstractSrcAndVirtualBillReport
extends AbstractIsmReport
implements HyperLinkClickListener {
    private static final String[] NOT_NULL_PARAMS = new String[]{"srcbillobjfilter", "srcbiztimerange", "vbillobjsfilter"};

    @Override
    protected String[] notNullQueryParams() {
        return NOT_NULL_PARAMS;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.addF7Listener(BillEnableSettleJudge.getInstance(), "srcbillobjfilter");
        this.addF7Listener(BillEnableBFM.getInstance(), "vbillobjsfilter");
        FormUtils.addHyperClickListener((HyperLinkClickListener)this, "reportlistap");
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "srcbillfrom": {
                this.changeBillNoFrom(e, "srcbillto");
                break;
            }
            case "vbillfrom": {
                this.changeBillNoFrom(e, "vbillto");
            }
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        DynamicObject rowData = this.getHyperClickRow(e);
        switch (fieldName) {
            case "billno": {
                this.billNoHyperClick(rowData);
                break;
            }
        }
    }

    private void billNoHyperClick(DynamicObject rowData) {
        PageShowHelper.showBillEdit((IFormView)this.getView(), rowData.getDynamicObject("billentitytype"), (Object)rowData.getLong("billid"));
    }

    protected Set<String> getVBillTypes() {
        DynamicObjectCollection vbiltypes = this.getQueryParam().getFilter().getDynamicObjectCollection("vbillobjsfilter");
        return CommonUtils.getNumberList(vbiltypes);
    }

    protected DynamicObject getHyperClickRow(HyperLinkClickEvent e) {
        ReportList reportList = (ReportList)e.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        return reportModel.getRowData(e.getRowIndex());
    }

    protected List<DynamicObject> getSelectRows() {
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        int[] selectedRows = reportList.getEntryState().getSelectedRows();
        IReportListModel reportModel = reportList.getReportModel();
        ArrayList<DynamicObject> rowDatas = new ArrayList<DynamicObject>(selectedRows.length);
        for (int index : selectedRows) {
            rowDatas.add(reportModel.getRowData(index));
        }
        return rowDatas;
    }

    public void setSortAndFilter(List<SortAndFilterEvent> list) {
        super.setSortAndFilter(list);
        Object[] sortFilter = this.sortFilterColumns();
        if (CommonUtils.arrayIsEmpty(sortFilter)) {
            return;
        }
        HashSet<Object> columns = new HashSet<Object>(Arrays.asList(sortFilter));
        for (SortAndFilterEvent event : list) {
            if (!columns.contains(event.getColumnName())) continue;
            event.setFilter(true);
        }
    }

    protected String[] sortFilterColumns() {
        return null;
    }
}

