/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.report.form;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.ItemClickEvent;
import kd.scmc.ism.business.helper.PageShowHelper;
import kd.scmc.ism.common.model.settlebill.SettleBillGenerator;
import kd.scmc.ism.common.result.SettleOperResult;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.control.DataRangeUtils;
import kd.scmc.ism.lang.ModelLang;
import kd.scmc.ism.report.form.AbstractSrcAndVirtualBillReport;

public class UnSettleSrcBillAnalysisReport
extends AbstractSrcAndVirtualBillReport {
    private static final String[] NOT_NULL_PARAMS = new String[]{"srcbillobjfilter", "srcbiztimerange", "srcbillstatusfilter"};

    @Override
    protected String[] notNullQueryParams() {
        return NOT_NULL_PARAMS;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object value = this.getModel().getValue("srcbiztimefrom");
        if (value == null) {
            DataRangeUtils.setOneMonth(this.getModel(), "srcbiztimefrom", "srcbiztimeto");
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "settle": {
                this.doSettle();
                break;
            }
        }
    }

    private void doSettle() {
        List<DynamicObject> selectRows = this.getSelectRows();
        if (CommonUtils.collectionIsEmpty(selectRows)) {
            return;
        }
        HashMap<Long, String> IdToBillNos = new HashMap<Long, String>(16);
        HashMap billInfos = new HashMap(16);
        for (DynamicObject rows : selectRows) {
            String billEntityType = rows.getDynamicObject("billentitytype").getString("number");
            long billId = rows.getLong("billid");
            String billNo = rows.getString("billno");
            CommonUtils.mapGetSetValue(billInfos, billEntityType).add(billId);
            IdToBillNos.put(billId, billNo);
        }
        SettleOperResult result = new SettleOperResult();
        for (Map.Entry billInfoEntry : billInfos.entrySet()) {
            SettleBillGenerator generator = new SettleBillGenerator();
            SettleOperResult curResult = generator.generate((String)billInfoEntry.getKey(), new ArrayList<Long>((Collection)billInfoEntry.getValue()));
            result.combine(curResult);
        }
        if (result.isSuccess()) {
            this.getView().showSuccessNotification(ModelLang.settleSuccess());
        } else {
            PageShowHelper.showOperResult((IFormView)this.getView(), result.getFailReasonsWithNo(IdToBillNos));
        }
        this.getView().invokeOperation("refresh");
    }
}

