/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.report.query;

import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.helper.BillModelDataSetHelper;
import kd.scmc.ism.common.model.entity.ModelFilter;
import kd.scmc.ism.common.model.handler.BillFieldMapCfg;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DataSetUtils;
import kd.scmc.ism.report.query.AbstractSrcAndVirtualBillQuery;

public class SettledSrcBillAnalysisQuery
extends AbstractSrcAndVirtualBillQuery {
    private static final String[] SRCBILL_QUERY_FIELD = new String[]{"mainbizorg", "status", "biztime", "bookdate", "biztype"};
    private static final String[] VBILL_QUERY_FIELD = new String[]{"srcbillid"};

    @Override
    public DataSet reportQuery(ReportQueryParam rqparam, Object paramObject) throws Throwable {
        BillFieldMapCfg mapCfg = BillFieldMapCfg.buildAll();
        FilterInfo filterInfo = rqparam.getFilter();
        DataSet srcBillDS = this.getSrcBillDS(mapCfg, filterInfo);
        DataSet vBillDS = this.getVBillDS(mapCfg, filterInfo);
        srcBillDS = srcBillDS.join(vBillDS, JoinType.LEFT).on("billid", "srcbillid").select(srcBillDS.getRowMeta().getFieldNames(), new String[]{"vbillcount"}).finish();
        return srcBillDS.filter("vbillcount > 0");
    }

    private DataSet getSrcBillDS(BillFieldMapCfg mapCfg, FilterInfo filterInfo) {
        Set<String> srcBillTyps = CommonUtils.getNumberList(filterInfo.getDynamicObjectCollection("srcbillobjfilter"));
        List<ModelFilter> srcModelFilters = this.getSrcBillModelFilter(filterInfo);
        DataSet srcBillInfo = BillModelDataSetHelper.parallelGetDataWithModelFilter(srcBillTyps, mapCfg, SRCBILL_QUERY_FIELD, srcModelFilters);
        DataSet logDataSet = QueryServiceHelper.queryDataSet((String)"SettledSrcBillAnalysisQuery.getSrcBillDS", (String)"ism_settlelog", (String)"sourceid", (QFilter[])new QFilter("sourcetype", "in", srcBillTyps).and("sourceid", "in", DataSetUtils.getValuesFromDataSet(srcBillInfo, "billid")).and("createstatus", "in", (Object)new String[]{"E", "A", "N"}).toArray(), null);
        srcBillInfo = srcBillInfo.leftJoin(logDataSet).on("billid", "sourceid").select(srcBillInfo.getRowMeta().getFieldNames(), new String[]{"sourceid"}).finish();
        return srcBillInfo.filter("sourceid is not null");
    }

    private DataSet getVBillDS(BillFieldMapCfg mapCfg, FilterInfo filterInfo) {
        Set<String> vBillTyps = CommonUtils.getNumberList(filterInfo.getDynamicObjectCollection("vbillobjsfilter"));
        List<ModelFilter> vModelFilters = this.getVBillModelFilter(filterInfo);
        vModelFilters.add(new ModelFilter("srcbillid", "is not null", null));
        DataSet vBillInfo = BillModelDataSetHelper.parallelGetDataWithModelFilter(vBillTyps, mapCfg, VBILL_QUERY_FIELD, vModelFilters);
        vBillInfo = vBillInfo.groupBy(vBillInfo.getRowMeta().getFieldNames()).finish();
        return vBillInfo.groupBy(new String[]{"srcbillid"}).count("billid").finish().select(new String[]{"srcbillid", "billid as vbillcount"});
    }
}

