/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.report.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.JoinType;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scmc.ism.business.helper.BillModelDataSetHelper;
import kd.scmc.ism.common.model.entity.ModelFilter;
import kd.scmc.ism.common.model.handler.BillFieldMapCfg;
import kd.scmc.ism.common.utils.CommonUtils;
import kd.scmc.ism.common.utils.DataSetUtils;
import kd.scmc.ism.model.core.judge.SettleNeoJudgeHandler;
import kd.scmc.ism.model.core.judge.SettleNeoJudgement;
import kd.scmc.ism.report.query.AbstractSrcAndVirtualBillQuery;

public class UnSettleSrcBillAnalysisQuery
extends AbstractSrcAndVirtualBillQuery {
    private static final String[] SRCBILL_QUERY_FIELD = new String[]{"mainbizorg", "status", "biztime", "bookdate", "biztype"};

    @Override
    public DataSet reportQuery(ReportQueryParam rqparam, Object paramObject) throws Throwable {
        BillFieldMapCfg mapCfg = BillFieldMapCfg.buildAll();
        FilterInfo filterInfo = rqparam.getFilter();
        DataSet srcBillDS = this.getSrcBillDS(mapCfg, filterInfo);
        DataSet settleCheckDS = this.getSettleCheckDS(srcBillDS);
        return DataSetUtils.joinDataSet(srcBillDS, "billid", settleCheckDS, "cbillid", JoinType.LEFT).filter("judgeid is not null");
    }

    private DataSet getSrcBillDS(BillFieldMapCfg mapCfg, FilterInfo filterInfo) {
        Set<String> srcBillTyps = CommonUtils.getNumberList(filterInfo.getDynamicObjectCollection("srcbillobjfilter"));
        List<ModelFilter> srcModelFilters = this.getSrcBillModelFilter(filterInfo);
        DataSet srcBillInfo = BillModelDataSetHelper.parallelGetDataWithModelFilter(srcBillTyps, mapCfg, SRCBILL_QUERY_FIELD, srcModelFilters);
        DataSet logDataSet = QueryServiceHelper.queryDataSet((String)"UnSettleSrcBillAnalysisQuery.getSrcBillDS", (String)"ism_settlelog", (String)"sourceid", (QFilter[])new QFilter("sourcetype", "in", srcBillTyps).and("sourceid", "in", DataSetUtils.getValuesFromDataSet(srcBillInfo, "billid")).and("createstatus", "in", (Object)new String[]{"E", "A", "N"}).toArray(), null);
        srcBillInfo = srcBillInfo.leftJoin(logDataSet).on("billid", "sourceid").select(srcBillInfo.getRowMeta().getFieldNames(), new String[]{"sourceid"}).finish();
        return srcBillInfo.filter("sourceid is null");
    }

    private DataSet getSettleCheckDS(DataSet srcBillDS) {
        String billentity;
        HashMap billMaps = new HashMap(128);
        DataSet copyDataSet = srcBillDS.copy();
        for (Object row : copyDataSet) {
            Long l = row.getLong("billid");
            billentity = row.getString("billentitytype");
            CommonUtils.mapGetSetValue(billMaps, billentity).add(l);
        }
        ArrayList<Object[]> valueObjs = new ArrayList<Object[]>(16);
        for (Map.Entry entry : billMaps.entrySet()) {
            billentity = (String)entry.getKey();
            Set billIds = (Set)entry.getValue();
            SettleNeoJudgement judgement = SettleNeoJudgement.create(billentity);
            Map<Long, SettleNeoJudgeHandler> billHandler = judgement.getBillHandler(billIds);
            for (Map.Entry<Long, SettleNeoJudgeHandler> entry2 : billHandler.entrySet()) {
                valueObjs.add(new Object[]{entry2.getKey(), entry2.getValue().getId()});
            }
        }
        HashMap<String, DataType> metaInfos = new HashMap<String, DataType>(2);
        metaInfos.put("cbillid", (DataType)DataType.LongType);
        metaInfos.put("judgeid", (DataType)DataType.LongType);
        return DataSetUtils.buildDataSet(metaInfos, valueObjs);
    }
}

