/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.ism.task;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.util.ExceptionUtils;
import kd.scmc.ism.business.helper.BizFlowServiceHelper;
import kd.scmc.ism.lang.TaskLang;

public class ExecuteBizFlowTask
extends AbstractTask {
    public void execute(RequestContext req, Map<String, Object> param) throws KDException {
        String billType = (String)param.get("entityType");
        String billId = (String)param.get("id");
        String flowNumber = (String)param.get("bizFlowKey");
        String object = (String)param.get("params");
        HashMap<String, Object> bizFlowParam = null;
        bizFlowParam = object != null ? (HashMap<String, Object>)SerializationUtils.fromJsonString((String)object, Map.class) : new HashMap<String, Object>(0);
        if (BizFlowServiceHelper.isRunningBizFlow(billId, flowNumber)) {
            throw new KDBizException(TaskLang.bizflowIsRunning());
        }
        if (BizFlowServiceHelper.isFinishedBizFlow(billId, flowNumber)) {
            throw new KDBizException(TaskLang.bizflowIsFinished());
        }
        try {
            BizFlowServiceHelper.triggerBizFlow(billType, billId, flowNumber, bizFlowParam);
        }
        catch (Exception e) {
            String template = ResManager.loadKDString((String)"\u6267\u884c\u4e1a\u52a1\u6d41\u7a0b\u5931\u8d25\uff1a\u5355\u636e\u7c7b\u578b\u3010%1s\u3011, \u5355\u636eID\u3010%2s\u3011, \u4e1a\u52a1\u6d41\u7a0b\u6807\u8bc6\u3010%3s\u3011, \u4e1a\u52a1\u53c2\u6570\u3010%4s\u3011\n\u5931\u8d25\u4fe1\u606f\u5982:%5s", (String)"bizFlowTaskErroTemplate", (String)"scmc-ism-form", (Object[])new Object[0]);
            String info = String.format(template, billType, billId, flowNumber, bizFlowParam, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw new KDBizException(info);
        }
    }
}

