/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.ai.util.JsonUtil;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.org.model.OrgViewTypeEnum;
import kd.scmc.mobim.business.helper.PermissionHelper;

public class AppHomePermissionHelper {
    private static final String INV_APP_ID = "=9Q86DR2P+Q";
    private static final String PM_APP_ID = "/JJVO8XV9MVB";
    private static final String ROUTE_META = "sys.meta";
    private static final String SM_APP_KEY = "sm";
    private static final String ENTITY_NUM = "entityNum";
    private static final String PERM_ITEM_ID = "permItemId";

    public static Map<String, Boolean> checkPermission(IFormView view) {
        Set<String> keys;
        DynamicObject org = (DynamicObject)view.getModel().getValue("org");
        Long orgId = org == null ? 0L : org.getLong("id");
        Map<String, Boolean> permMap = new HashMap<String, Boolean>(38);
        if (org == null || org.equals(0L)) {
            return permMap;
        }
        permMap = AppHomePermissionHelper.checkPermission(orgId);
        String orgUnit = view.getPageCache().get("userOrgUnit");
        List userOrgList = (List)JsonUtil.decodeFromString((String)orgUnit, List.class);
        Map<Boolean, Set<String>> visibleMap = AppHomePermissionHelper.handleMenu(orgId, userOrgList, permMap);
        Set<String> isPermKeys = visibleMap.get(Boolean.TRUE);
        HashMap<String, Boolean> returnMap = new HashMap<String, Boolean>(36);
        if (isPermKeys != null && !isPermKeys.isEmpty()) {
            for (String key : isPermKeys) {
                returnMap.put(key, Boolean.TRUE);
            }
        }
        if ((keys = visibleMap.get(Boolean.FALSE)) != null && !keys.isEmpty()) {
            for (String key : keys) {
                returnMap.put(key, Boolean.FALSE);
            }
        }
        return returnMap;
    }

    public static Map<String, Boolean> checkPermission(Long org) {
        Map<String, Map<String, String>> permItems = AppHomePermissionHelper.getCheckPerm();
        HashMap<String, Boolean> permMap = new HashMap<String, Boolean>(permItems.size());
        if (org != null && !org.equals(0L)) {
            RequestContext requestContext = RequestContext.get();
            long userId = requestContext.getCurrUserId();
            for (Map.Entry<String, Map<String, String>> perms : permItems.entrySet()) {
                Map<String, String> perm = perms.getValue();
                String permKey = perms.getKey();
                boolean b = PermissionHelper.checkPermission(userId, org, INV_APP_ID, perm.get(ENTITY_NUM), perm.get(PERM_ITEM_ID));
                permMap.put(permKey, b);
            }
        }
        return permMap;
    }

    public static Map<Boolean, Set<String>> handleMenu(Long org, List<Object> ownOrg, Map<String, Boolean> permMap) {
        HashMap<Boolean, Set<String>> visibleMap = new HashMap<Boolean, Set<String>>(8);
        Map<String, HashSet<String>> menuPerms = AppHomePermissionHelper.getCheckPermMenu();
        for (Map.Entry<String, HashSet<String>> perms : menuPerms.entrySet()) {
            HashSet<String> items;
            HashSet<String> permSet = perms.getValue();
            String menuKey = perms.getKey();
            Boolean isPerm = Boolean.TRUE;
            Boolean orgType = AppHomePermissionHelper.handleMenuOrgType(menuKey, org, ownOrg);
            if (orgType.booleanValue()) {
                if (!"mobim_invquery".equals(menuKey)) {
                    for (String permKey : permSet) {
                        Boolean permValue = permMap.get(permKey);
                        if (permValue.booleanValue()) continue;
                        isPerm = Boolean.FALSE;
                        break;
                    }
                }
            } else {
                isPerm = orgType;
            }
            if ((items = (HashSet<String>)visibleMap.get(isPerm)) == null) {
                items = new HashSet<String>(8);
            }
            items.add(menuKey);
            visibleMap.put(isPerm, items);
        }
        return visibleMap;
    }

    public static Map<String, HashSet<String>> getCheckPermMenu() {
        HashMap<String, HashSet<String>> menuPerms = new HashMap<String, HashSet<String>>(12);
        HashSet<String> purInMenu = new HashSet<String>(2);
        purInMenu.add("purinbill_view");
        menuPerms.put("mobim_purinbill", purInMenu);
        HashSet<String> purRecMenu = new HashSet<String>(2);
        purRecMenu.add("purrecbill_view");
        menuPerms.put("mobim_purreceivebill", purRecMenu);
        HashSet<String> saleOutMenu = new HashSet<String>(2);
        saleOutMenu.add("saleoutbill_view");
        menuPerms.put("out_order_list", saleOutMenu);
        HashSet<String> materialReqMenu = new HashSet<String>(2);
        materialReqMenu.add("materialreqbill_view");
        menuPerms.put("mobim_materialreqbill", materialReqMenu);
        HashSet<String> otherOutMenu = new HashSet<String>(2);
        otherOutMenu.add("otheroutbill_view");
        menuPerms.put("mobim_otheroutbill", otherOutMenu);
        HashSet<String> otherInMenu = new HashSet<String>(2);
        otherInMenu.add("otherinbill_view");
        menuPerms.put("mobim_otherinbill", otherInMenu);
        HashSet<String> proInMenu = new HashSet<String>(2);
        proInMenu.add("proinbill_view");
        menuPerms.put("mobim_productinbill", proInMenu);
        HashSet<String> materReqOutMenu = new HashSet<String>(2);
        materReqOutMenu.add("materialreqoutbill_view");
        menuPerms.put("mobim_materialreqoutbill", materReqOutMenu);
        HashSet<String> transDirMenu = new HashSet<String>(2);
        transDirMenu.add("transdirbill_view");
        menuPerms.put("mobim_transdirbill", transDirMenu);
        HashSet<String> transOutMenu = new HashSet<String>(2);
        transOutMenu.add("transoutbill_view");
        transOutMenu.add("transoutbill_new");
        menuPerms.put("mobim_transoutbill", transOutMenu);
        HashSet<String> transInMenu = new HashSet<String>(2);
        transInMenu.add("transinbill_view");
        transInMenu.add("transinbill_new");
        menuPerms.put("mobim_transinbill", transInMenu);
        HashSet<String> locationTransMenu = new HashSet<String>(2);
        locationTransMenu.add("locationtrans_view");
        menuPerms.put("mobim_locationtransfer", locationTransMenu);
        HashSet<String> invAccReportMenu = new HashSet<String>(2);
        invAccReportMenu.add("invaccreport_view");
        menuPerms.put("mobim_invquery", invAccReportMenu);
        HashSet<String> manufactureInMenu = new HashSet<String>(2);
        manufactureInMenu.add("manufactureinmenu_view");
        menuPerms.put("mobim_mdc_mftmanuinlist", manufactureInMenu);
        HashSet<String> producePickMenu = new HashSet<String>(2);
        producePickMenu.add("producepick_view");
        menuPerms.put("mobim_producepickout", producePickMenu);
        HashSet<String> adjustMenu = new HashSet<String>(2);
        adjustMenu.add("adjustbill_view");
        menuPerms.put("mobim_adjustbilll", adjustMenu);
        HashSet<String> adjustNewMenu = new HashSet<String>(2);
        adjustNewMenu.add("adjustbill_new");
        adjustNewMenu.add("adjustbill_view");
        menuPerms.put("mobim_adjustbillnew", adjustNewMenu);
        HashSet<String> ageReportMenu = new HashSet<String>(2);
        ageReportMenu.add("invagereport_view");
        menuPerms.put("mobim_invagereport", ageReportMenu);
        HashSet<String> transApplyMenu = new HashSet<String>(2);
        transApplyMenu.add("transapplybill_view");
        menuPerms.put("mobim_transapply", transApplyMenu);
        HashSet<String> scanPickOutMenu = new HashSet<String>(2);
        scanPickOutMenu.add("producepick_view");
        menuPerms.put("mobim_scanpickout", scanPickOutMenu);
        HashSet<String> countBillMenu = new HashSet<String>(2);
        countBillMenu.add("countbill_view");
        menuPerms.put("mobim_countbill", countBillMenu);
        HashSet<String> locationTransferNewMenu = new HashSet<String>(2);
        locationTransferNewMenu.add("locationtrans_new");
        locationTransferNewMenu.add("locationtrans_view");
        menuPerms.put("mobim_locationtransnew", locationTransferNewMenu);
        return menuPerms;
    }

    public static Map<String, Map<String, String>> getCheckPerm() {
        HashMap<String, Map<String, String>> permItems = new HashMap<String, Map<String, String>>(12);
        HashMap<String, String> purInPerms = new HashMap<String, String>(3);
        purInPerms.put(ENTITY_NUM, "im_purinbill");
        purInPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("purinbill_view", purInPerms);
        HashMap<String, String> purRecPerms = new HashMap<String, String>(3);
        purRecPerms.put(ENTITY_NUM, "im_purreceivebill");
        purRecPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("purrecbill_view", purRecPerms);
        HashMap<String, String> saleOutPerms = new HashMap<String, String>(3);
        saleOutPerms.put(ENTITY_NUM, "im_saloutbill");
        saleOutPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("saleoutbill_view", saleOutPerms);
        HashMap<String, String> saleOutNewPerms = new HashMap<String, String>(3);
        saleOutNewPerms.put(ENTITY_NUM, "im_saloutbill");
        saleOutNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        permItems.put("saleoutbill_new", saleOutNewPerms);
        HashMap<String, String> purInNewPerms = new HashMap<String, String>(3);
        purInNewPerms.put(ENTITY_NUM, "im_purinbill");
        purInNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        permItems.put("purinbill_new", purInNewPerms);
        HashMap<String, String> purRecNewPerms = new HashMap<String, String>(3);
        purRecNewPerms.put(ENTITY_NUM, "im_purreceivebill");
        purRecNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        permItems.put("purrecbill_new", purRecNewPerms);
        HashMap<String, String> materialReqPerms = new HashMap<String, String>(3);
        materialReqPerms.put(ENTITY_NUM, "im_materialreqbill");
        materialReqPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("materialreqbill_view", materialReqPerms);
        HashMap<String, String> otherOutPerms = new HashMap<String, String>(3);
        otherOutPerms.put(ENTITY_NUM, "im_otheroutbill");
        otherOutPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("otheroutbill_view", otherOutPerms);
        HashMap<String, String> otherInPerms = new HashMap<String, String>(3);
        otherInPerms.put(ENTITY_NUM, "im_otherinbill");
        otherInPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("otherinbill_view", otherInPerms);
        HashMap<String, String> proInPerms = new HashMap<String, String>(3);
        proInPerms.put(ENTITY_NUM, "im_productinbill");
        proInPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("proinbill_view", proInPerms);
        HashMap<String, String> materReqOutPerms = new HashMap<String, String>(3);
        materReqOutPerms.put(ENTITY_NUM, "im_materialreqoutbill");
        materReqOutPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("materialreqoutbill_view", materReqOutPerms);
        HashMap<String, String> materReqOutNewPerms = new HashMap<String, String>(3);
        materReqOutNewPerms.put(ENTITY_NUM, "im_materialreqoutbill");
        materReqOutNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        permItems.put("materialreqoutbill_new", materReqOutNewPerms);
        HashMap<String, String> transDirPerms = new HashMap<String, String>(3);
        transDirPerms.put(ENTITY_NUM, "im_transdirbill");
        transDirPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("transdirbill_view", transDirPerms);
        HashMap<String, String> transOutPerms = new HashMap<String, String>(3);
        transOutPerms.put(ENTITY_NUM, "im_transoutbill");
        transOutPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("transoutbill_view", transOutPerms);
        HashMap<String, String> transInPerms = new HashMap<String, String>(3);
        transInPerms.put(ENTITY_NUM, "im_transinbill");
        transInPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("transinbill_view", transInPerms);
        HashMap<String, String> locationTransPerms = new HashMap<String, String>(3);
        locationTransPerms.put(ENTITY_NUM, "im_locationtransfer");
        locationTransPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("locationtrans_view", locationTransPerms);
        HashMap<String, String> locationTransNewPerms = new HashMap<String, String>(3);
        locationTransNewPerms.put(ENTITY_NUM, "im_locationtransfer");
        locationTransNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        permItems.put("locationtrans_new", locationTransNewPerms);
        HashMap<String, String> invAccReportPerms = new HashMap<String, String>(3);
        invAccReportPerms.put(ENTITY_NUM, "im_invaccreport");
        invAccReportPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("invaccreport_view", invAccReportPerms);
        HashMap<String, String> manufactureInPerms = new HashMap<String, String>(3);
        manufactureInPerms.put(ENTITY_NUM, "im_mdc_mftmanuinbill");
        manufactureInPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("manufactureinmenu_view", manufactureInPerms);
        HashMap<String, String> manufactureNewPerms = new HashMap<String, String>(3);
        manufactureNewPerms.put(ENTITY_NUM, "im_mdc_mftmanuinbill");
        manufactureNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        permItems.put("manufactureinmenu_new", manufactureNewPerms);
        HashMap<String, String> producePickPerms = new HashMap<String, String>(3);
        producePickPerms.put(ENTITY_NUM, "im_mdc_mftproorder");
        producePickPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("producepick_view", producePickPerms);
        HashMap<String, String> mftOrderPerms = new HashMap<String, String>(3);
        mftOrderPerms.put(ENTITY_NUM, "pom_mftorder");
        mftOrderPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("mftorder_view", mftOrderPerms);
        HashMap<String, String> transapplyPerms = new HashMap<String, String>(3);
        transapplyPerms.put(ENTITY_NUM, "im_transapply");
        transapplyPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("transapplybill_view", transapplyPerms);
        HashMap<String, String> transapplyNewPerms = new HashMap<String, String>(3);
        transapplyNewPerms.put(ENTITY_NUM, "im_transapply");
        transapplyNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        permItems.put("transapplybill_new", transapplyNewPerms);
        HashMap<String, String> transOutNewPerms = new HashMap<String, String>(3);
        transOutNewPerms.put(ENTITY_NUM, "im_transoutbill");
        transOutNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        permItems.put("transoutbill_new", transOutNewPerms);
        HashMap<String, String> transInNewPerms = new HashMap<String, String>(3);
        transInNewPerms.put(ENTITY_NUM, "im_transinbill");
        transInNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        permItems.put("transinbill_new", transInNewPerms);
        HashMap<String, String> adjustPerms = new HashMap<String, String>(3);
        adjustPerms.put(ENTITY_NUM, "im_adjustbill");
        adjustPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("adjustbill_view", adjustPerms);
        HashMap<String, String> adjustNewPerms = new HashMap<String, String>(3);
        adjustNewPerms.put(ENTITY_NUM, "im_adjustbill");
        adjustNewPerms.put(PERM_ITEM_ID, "47156aff000000ac");
        permItems.put("adjustbill_new", adjustNewPerms);
        HashMap<String, String> invAgeReportPerms = new HashMap<String, String>(3);
        invAgeReportPerms.put(ENTITY_NUM, "im_invagereport");
        invAgeReportPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("invagereport_view", invAgeReportPerms);
        HashMap<String, String> countBillPerms = new HashMap<String, String>(3);
        countBillPerms.put(ENTITY_NUM, "im_invcountbill");
        countBillPerms.put(PERM_ITEM_ID, "47150e89000000ac");
        permItems.put("countbill_view", countBillPerms);
        return permItems;
    }

    private static Boolean handleMenuOrgType(String menuKey, Long orgId, List<Object> ownOrg) {
        switch (menuKey) {
            case "out_order_list": 
            case "mobim_purinbill": 
            case "purrec_purin_add": 
            case "scan_purrec_purin": 
            case "mobim_purreceivebill": 
            case "mobim_otheroutbill": 
            case "mobim_otherinbill": 
            case "mobim_transoutbill": 
            case "mobim_transinbill": 
            case "mobim_materialreqoutbill": 
            case "mobim_transdirbill": 
            case "mobim_productinbill": 
            case "mobim_locationtransfer": 
            case "mobim_mdc_mftmanuinlist": 
            case "mobim_producepickout": 
            case "mobim_transapplybilllist": 
            case "mobim_adjustbilll": 
            case "mobim_adjustbillnew": 
            case "mobim_transapply": 
            case "mobim_scanpickout": 
            case "mobim_countbill": 
            case "mobim_locationtransnew": {
                return AppHomePermissionHelper.checkOrgInventory(orgId);
            }
            case "purorder_purinbill_add": 
            case "mobim_purreceivebilladd": {
                return AppHomePermissionHelper.checkViewPermOfOrg(orgId, "pm_purorderbill", OrgViewTypeEnum.IS_PURCHASE.getViewType(), PM_APP_ID, ownOrg);
            }
            case "mobim_invquery": {
                return AppHomePermissionHelper.checkInvQuery(ownOrg);
            }
        }
        return Boolean.TRUE;
    }

    private static Boolean checkInvQuery(List<Object> ownOrg) {
        RequestContext requestContext = RequestContext.get();
        long userId = requestContext.getCurrUserId();
        Boolean isOwn = Boolean.FALSE;
        if (ownOrg != null && !ownOrg.isEmpty()) {
            for (Object orgId : ownOrg) {
                boolean isPerm = PermissionHelper.checkPermission(userId, Long.parseLong(String.valueOf(orgId)), INV_APP_ID, "im_invaccreport", "47150e89000000ac");
                if (!isPerm) continue;
                isOwn = Boolean.TRUE;
                break;
            }
        }
        return isOwn;
    }

    private static Boolean checkViewPermOfOrg(Long orgId, String pcEntityKey, String fromOrgType, String entrustedAppId, List<Object> ownOrg) {
        boolean isInv = AppHomePermissionHelper.checkOrgInventory(orgId);
        if (!isInv) {
            return Boolean.FALSE;
        }
        List orgList = OrgUnitServiceHelper.getFromOrgs((String)OrgViewTypeEnum.IS_INVENTORY.getViewType(), (Long)orgId, (String)fromOrgType, (boolean)true);
        if (orgList == null || orgList.isEmpty()) {
            return Boolean.FALSE;
        }
        return AppHomePermissionHelper.checkEntrustedOrgPerm(orgList, entrustedAppId, pcEntityKey, "47150e89000000ac", ownOrg);
    }

    private static Boolean checkEntrustedOrgPerm(List<Long> entrustedOrgs, String entrustedAppId, String entrustedEntityKey, String permItem, List<Object> ownOrg) {
        ArrayList<Long> userPermList = new ArrayList<Long>(entrustedOrgs.size());
        for (Long pmOrg : entrustedOrgs) {
            for (Object userOrg : ownOrg) {
                if (!String.valueOf(userOrg).equals(String.valueOf(pmOrg))) continue;
                userPermList.add(pmOrg);
            }
        }
        if (userPermList.isEmpty()) {
            return Boolean.FALSE;
        }
        RequestContext requestContext = RequestContext.get();
        long userId = requestContext.getCurrUserId();
        Boolean hasPerm = Boolean.FALSE;
        for (Long permOrgId : userPermList) {
            boolean result = PermissionHelper.checkPermission(userId, permOrgId, entrustedAppId, entrustedEntityKey, permItem);
            if (!result) continue;
            hasPerm = Boolean.TRUE;
            break;
        }
        return hasPerm;
    }

    private static Boolean checkOrgInventory(Long orgId) {
        List list = OrgUnitServiceHelper.filterOrgDuty(Collections.singletonList(orgId), (String)"05");
        if (list == null || list.isEmpty()) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

