/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.business.helper.WarehouseHelper;

public class BeforeSelectF7Helper {
    private static final Log log = LogFactory.getLog(BeforeSelectF7Helper.class);

    public static void beforeF7SelectOrg(ListShowParameter showParameter, IFormView view) {
        String pkSet = (String)view.getFormShowParameter().getCustomParams().get("HasPermissionAndStartedInvOrg");
        Object filter = StringUtils.isNotEmpty((CharSequence)pkSet) ? SerializationUtils.fromJsonString((String)pkSet, List.class) : new ArrayList(10);
        showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", filter));
    }

    public static void beforeF7Warehouse(ListShowParameter showParameter, String orgKey, boolean orgIsRequired, IFormView view) {
        Object org = view.getModel().getValue(orgKey);
        if (!orgIsRequired && BeforeSelectF7Helper.orgIsNull(org)) {
            return;
        }
        if (org instanceof DynamicObject) {
            Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(((DynamicObject)org).getPkValue().toString()));
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)allWhs));
            return;
        }
        if (org instanceof DynamicObjectCollection) {
            ArrayList<Object> listOrgId = new ArrayList<Object>();
            for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                listOrgId.add(dynamicObject.get("fbasedataid_id"));
            }
            List allWhs = WarehouseHelper.getAllWarehouse(listOrgId);
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)allWhs));
            return;
        }
    }

    public static void beforeF7Location(ListShowParameter showParameter, String orgKey, boolean orgIsRequired, IFormView view) {
        ArrayList<Long> qFilter = new ArrayList<Long>();
        Object warehouseData = view.getModel().getValue("warehouse");
        List qFilters = showParameter.getListFilterParameter().getQFilters();
        if (warehouseData == null) {
            return;
        }
        DynamicObjectCollection warehouseCol = (DynamicObjectCollection)warehouseData;
        ArrayList<String> warehouseNumList = new ArrayList<String>(10);
        for (DynamicObject warehouse : warehouseCol) {
            DynamicObject warehouseObj = warehouse.getDynamicObject(1);
            if (warehouseObj == null) continue;
            String warehouseNum = warehouseObj.getString("number");
            warehouseNumList.add(warehouseNum);
        }
        QFilter warehouseFilter = new QFilter("number", "in", warehouseNumList);
        DynamicObject[] warehouses = BusinessDataServiceHelper.load((String)"bd_warehouse", (String)"id,entryentity,entryentity.location", (QFilter[])warehouseFilter.toArray());
        if (warehouses == null || warehouses.length == 0) {
            return;
        }
        List<Object> warehouseList = new ArrayList();
        Object org = view.getModel().getValue(orgKey);
        if (!orgIsRequired && BeforeSelectF7Helper.orgIsNull(org)) {
            for (int i = 0; i < warehouses.length; ++i) {
                DynamicObject warehouse = warehouses[i];
                DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
                List<Long> ids = BeforeSelectF7Helper.getLocationIdList(locationCol);
                qFilter.addAll(ids);
            }
            qFilters.add(new QFilter("id", "in", qFilter));
            return;
        }
        if (org instanceof DynamicObject) {
            Long[] allWhs = WarehouseHelper.getAllWarehouseIDs((Long)Long.valueOf(((DynamicObject)org).getPkValue().toString()));
            warehouseList = Arrays.asList(allWhs);
        } else if (org instanceof DynamicObjectCollection) {
            ArrayList<Object> listOrgId = new ArrayList<Object>();
            for (DynamicObject dynamicObject : (DynamicObjectCollection)org) {
                listOrgId.add(dynamicObject.get("fbasedataid_id"));
            }
            warehouseList = WarehouseHelper.getAllWarehouse(listOrgId);
        }
        for (int i = 0; i < warehouses.length; ++i) {
            Iterator warehouse = warehouses[i];
            if (!warehouseList.contains(warehouse.getPkValue())) continue;
            DynamicObjectCollection locationCol = warehouse.getDynamicObjectCollection("entryentity");
            List<Long> ids = BeforeSelectF7Helper.getLocationIdList(locationCol);
            qFilter.addAll(ids);
        }
        qFilters.add(new QFilter("id", "in", qFilter));
    }

    private static List<Long> getLocationIdList(DynamicObjectCollection locationCol) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (locationCol == null || locationCol.size() == 0) {
            return ids;
        }
        for (DynamicObject locDym : locationCol) {
            DynamicObject location = locDym.getDynamicObject("location");
            ids.add(Long.valueOf(location.getPkValue().toString()));
        }
        return ids;
    }

    public static void beforeF7AccountOwner(ListShowParameter showParameter, String orgKey, boolean orgIsRequired, IFormView view) {
        ArrayList<Object> list = new ArrayList<Object>(10);
        Object orgLogObject = view.getModel().getValue(orgKey);
        if (!orgIsRequired && BeforeSelectF7Helper.orgIsNull(orgLogObject)) {
            String pkSet = (String)view.getFormShowParameter().getCustomParams().get("HasPermissionAndStartedInvOrg");
            List createOrgIds = SerializationUtils.fromJsonStringToList((String)pkSet, Long.class);
            for (Long orgId : createOrgIds) {
                list.addAll(OwnerHelper.getOwners((Long)orgId));
                long defaultOwner = OwnerHelper.getDefaultOwner((Long)orgId);
                if (defaultOwner != 0L) {
                    list.add(defaultOwner);
                }
                Map company = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
                list.add(company.get("id"));
            }
            showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", list));
            return;
        }
        BeforeSelectF7Helper.getDefaultOwner(orgLogObject, list, showParameter);
    }

    public static boolean orgIsNull(Object org) {
        return org == null || org instanceof DynamicObjectCollection && ((DynamicObjectCollection)org).size() == 0;
    }

    public static void getDefaultOwner(Object orgLogObject, List<Object> list, ListShowParameter showParameter) {
        if (orgLogObject instanceof DynamicObject) {
            long orgId = (Long)((DynamicObject)orgLogObject).getPkValue();
            list = OwnerHelper.getOwners((Long)orgId);
            long defaultOwner = OwnerHelper.getDefaultOwner((Long)orgId);
            if (defaultOwner != 0L) {
                list.add(defaultOwner);
            }
            list.add(OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE).get("id"));
        } else if (orgLogObject instanceof DynamicObjectCollection) {
            for (DynamicObject dynamicObject : (DynamicObjectCollection)orgLogObject) {
                long orgId = dynamicObject.getLong("fbasedataid_id");
                list.addAll(OwnerHelper.getOwners((Long)orgId));
                long defaultOwner = OwnerHelper.getDefaultOwner((Long)orgId);
                if (defaultOwner != 0L) {
                    list.add(defaultOwner);
                }
                list.add(OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE).get("id"));
            }
        }
        if (list.size() == 0) {
            log.info("\u8be5\u5e93\u5b58\u7ec4\u7ec7\u6ca1\u6709\u76f8\u5173\u8054\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002");
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5e93\u5b58\u7ec4\u7ec7\u6ca1\u6709\u76f8\u5173\u8054\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"BeforeSelectF7Helper_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        showParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)list));
        showParameter.setCustomParam("orgFuncId", (Object)"10");
    }
}

