/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.UnitConvertDirEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.BillQtyAndUnitHelper;
import kd.scmc.im.business.helper.MaterialHelper;
import kd.scmc.im.business.helper.PrecisionAccountHelper;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.msmob.pojo.QrCodeResult;

public class CountBillHelper {
    private static final String GAIN_QTY = "gainqty";
    private static final String LOSS_QTY = "lossqty";

    public static void setUnit(String unit, List<Label> labels) {
        for (Label label : labels) {
            label.setText(unit);
        }
    }

    public static boolean verifyParsingBarCode(IFormView view, QrCodeResult qrCodeResult) {
        String entityId;
        String type = qrCodeResult.getCodeType();
        if (("material".equals(type) || "warehouse".equals(type) || "location".equals(type)) && ("bd_material".equals(entityId = qrCodeResult.getEntityId()) || "bd_warehouse".equals(entityId) || "bd_location".equals(entityId))) {
            String num = (String)qrCodeResult.getAttribute("number");
            QFilter qFilter = new QFilter("number", "=", (Object)num);
            DynamicObject baseData = BusinessDataServiceHelper.loadSingleFromCache((String)entityId, (String)"name", (QFilter[])qFilter.toArray());
            return baseData != null;
        }
        view.showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u7801\u7c7b\u578b\uff0c\u8bf7\u91cd\u65b0\u626b\u63cf\u3002", (String)"CountScanFilterPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
        return false;
    }

    public static Map<String, BigDecimal> calGainAndLossQtyByQty(BigDecimal qty, BigDecimal accQty, BigDecimal adjustQty) {
        HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(2);
        BigDecimal calQty = qty.subtract(accQty).subtract(adjustQty);
        BigDecimal countAcc = accQty.add(adjustQty);
        if (qty.compareTo(BigDecimal.ZERO) >= 0 && countAcc.compareTo(BigDecimal.ZERO) < 0) {
            resultMap.put(GAIN_QTY, calQty);
            resultMap.put(LOSS_QTY, BigDecimal.ZERO);
        }
        if (qty.compareTo(countAcc) >= 0 && countAcc.compareTo(BigDecimal.ZERO) >= 0) {
            resultMap.put(GAIN_QTY, calQty);
            resultMap.put(LOSS_QTY, BigDecimal.ZERO);
        }
        if (qty.compareTo(countAcc) < 0 && countAcc.compareTo(BigDecimal.ZERO) >= 0) {
            resultMap.put(GAIN_QTY, BigDecimal.ZERO);
            resultMap.put(LOSS_QTY, calQty.abs());
        }
        return resultMap;
    }

    public static void calByQty(DynamicObject entryRow, boolean enableCheck) {
        DynamicObject materialInvInfo = entryRow.getDynamicObject("material");
        DynamicObject material = MaterialHelper.getMaterialByMatBiz((DynamicObject)materialInvInfo);
        if (material != null) {
            boolean isConvert;
            DynamicObject unit = entryRow.getDynamicObject("unit");
            DynamicObject baseUnit = entryRow.getDynamicObject("baseunit");
            DynamicObject unit2nd = entryRow.getDynamicObject("unit2nd");
            BigDecimal baseUnitRate = BillQtyAndUnitHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)(unit == null ? null : (Long)unit.getPkValue()), baseUnit == null ? null : (Long)baseUnit.getPkValue());
            BigDecimal unit2ndRate = BillQtyAndUnitHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)(unit == null ? null : (Long)unit.getPkValue()), unit2nd == null ? null : (Long)unit2nd.getPkValue());
            BigDecimal qty = entryRow.getBigDecimal("qty");
            BigDecimal qtyAcc = entryRow.getBigDecimal("qtyacc");
            BigDecimal checkqty = entryRow.getBigDecimal("checkqty");
            BigDecimal adjustQty = entryRow.getBigDecimal("adjustqty");
            BigDecimal baseQty = qty.multiply(baseUnitRate);
            baseQty = PrecisionAccountHelper.dealWithprecision((DynamicObject)baseUnit, (BigDecimal)baseQty);
            entryRow.set("baseqty", (Object)baseQty);
            BigDecimal checkBaseQty = checkqty.multiply(baseUnitRate);
            checkBaseQty = PrecisionAccountHelper.dealWithprecision((DynamicObject)baseUnit, (BigDecimal)checkBaseQty);
            entryRow.set("checkbaseqty", (Object)checkBaseQty);
            BigDecimal baseQtyAcc = qtyAcc.multiply(baseUnitRate);
            baseQtyAcc = PrecisionAccountHelper.dealWithprecision((DynamicObject)baseUnit, (BigDecimal)baseQtyAcc);
            entryRow.set("baseqtyacc", (Object)baseQtyAcc);
            String unitConvertDir = material.getString("unitconvertdir");
            CountBillHelper.changeGainAndLossQty(qty, "qtyacc", GAIN_QTY, LOSS_QTY, "adjustqty", "checkqty", enableCheck, entryRow);
            boolean bl = isConvert = UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
            if (isConvert) {
                BigDecimal qtyUnit2nd = qty.multiply(unit2ndRate);
                qtyUnit2nd = PrecisionAccountHelper.dealWithprecision((DynamicObject)unit2nd, (BigDecimal)qtyUnit2nd);
                CountBillHelper.showBigDecimalErrorTip("qtyunit2nd", qtyUnit2nd, entryRow);
                entryRow.set("qtyunit2nd", (Object)qtyUnit2nd);
                BigDecimal qty2ndAcc = qtyAcc.multiply(unit2ndRate);
                qty2ndAcc = PrecisionAccountHelper.dealWithprecision((DynamicObject)unit2nd, (BigDecimal)qty2ndAcc);
                entryRow.set("qty2ndacc", (Object)qty2ndAcc);
                BigDecimal checkQtyUnit2nd = checkqty.multiply(unit2ndRate);
                checkQtyUnit2nd = PrecisionAccountHelper.dealWithprecision((DynamicObject)unit2nd, (BigDecimal)checkQtyUnit2nd);
                entryRow.set("checkqtyunit2nd", (Object)checkQtyUnit2nd);
                BigDecimal adjustQtyUnit2nd = adjustQty.multiply(unit2ndRate);
                adjustQtyUnit2nd = PrecisionAccountHelper.dealWithprecision((DynamicObject)unit2nd, (BigDecimal)adjustQtyUnit2nd);
                entryRow.set("adjustqtyunit2nd", (Object)adjustQtyUnit2nd);
                CountBillHelper.changeGainAndLossQty(qtyUnit2nd, "qty2ndacc", "gainqty2nd", "lossqty2nd", "adjustqtyunit2nd", "checkqtyunit2nd", enableCheck, entryRow);
            }
            CountBillHelper.changeGainAndLossQty(qty.multiply(baseUnitRate), "baseqtyacc", "basegainqty", "baselossqty", "adjustbaseqty", "checkbaseqty", enableCheck, entryRow);
        }
    }

    private static void changeGainAndLossQty(BigDecimal qty, String accField, String gainField, String lossField, String adjustField, String checkField, boolean enableCheck, DynamicObject entryRow) {
        BigDecimal lossQty;
        BigDecimal checkQty = entryRow.getBigDecimal(checkField);
        BigDecimal adjustQty = entryRow.getBigDecimal(adjustField);
        BigDecimal acc = entryRow.getBigDecimal(accField);
        BigDecimal countAcc = acc.add(adjustQty);
        if (enableCheck) {
            qty = checkQty;
        }
        BigDecimal gainQty = lossQty = qty.subtract(acc).subtract(adjustQty);
        if (qty.compareTo(BigDecimal.ZERO) >= 0 && countAcc.compareTo(BigDecimal.ZERO) < 0) {
            entryRow.set(gainField, (Object)gainQty);
            entryRow.set(lossField, (Object)BigDecimal.ZERO);
        }
        if (qty.compareTo(countAcc) >= 0 && countAcc.compareTo(BigDecimal.ZERO) >= 0) {
            entryRow.set(gainField, (Object)gainQty);
            entryRow.set(lossField, (Object)BigDecimal.ZERO);
        }
        if (qty.compareTo(countAcc) < 0 && countAcc.compareTo(BigDecimal.ZERO) >= 0) {
            entryRow.set(gainField, (Object)BigDecimal.ZERO);
            entryRow.set(lossField, (Object)lossQty.abs());
        }
    }

    public static void initDataByMaterial(DynamicObject entryRow) {
        DynamicObject material = entryRow.getDynamicObject("material");
        if (material != null) {
            DynamicObject masterMaterial = MaterialHelper.getMaterialByMatBiz((DynamicObject)material);
            DynamicObject baseUnit = masterMaterial.getDynamicObject("baseunit");
            DynamicObject unit = material.getDynamicObject("inventoryunit");
            entryRow.set("unit", (Object)unit);
            entryRow.set("baseunit", (Object)baseUnit);
            DynamicObject auxptyUnit = masterMaterial.getDynamicObject("auxptyunit");
            if (auxptyUnit != null) {
                entryRow.set("unit2nd", (Object)auxptyUnit);
            }
        }
    }

    public static List<Map<String, Object>> getProfitLossData(DynamicObjectCollection dynamicObjectCollection) {
        int size = dynamicObjectCollection.size();
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(size);
        for (DynamicObject entry : dynamicObjectCollection) {
            HashMap<String, Object> map = new HashMap<String, Object>(5);
            DynamicObject material = entry.getDynamicObject("material");
            if (material == null) continue;
            DynamicObject unit = entry.getDynamicObject("unit");
            BigDecimal gainQty = entry.getBigDecimal(GAIN_QTY);
            BigDecimal lossQty = entry.getBigDecimal(LOSS_QTY);
            DynamicObject warehouse = entry.getDynamicObject("warehouse");
            DynamicObject location = entry.getDynamicObject("location");
            map.put("material", material.getPkValue());
            if (unit != null) {
                map.put("unit", unit.getPkValue());
            }
            if (warehouse != null) {
                map.put("warehouse", warehouse.getPkValue());
            }
            if (location != null) {
                map.put("location", location.getPkValue());
            }
            map.put(GAIN_QTY, gainQty);
            map.put(LOSS_QTY, lossQty);
            list.add(map);
        }
        return list;
    }

    public static void showBigDecimalErrorTip(String qtyKey, BigDecimal qty, DynamicObject entryRow) {
        String displayName = null;
        String langName = RequestContext.get().getLang().name();
        DynamicProperty property = entryRow.getDynamicObjectType().getProperty(qtyKey);
        displayName = (String)property.getDisplayName().get((Object)langName);
        if (displayName != null && qty.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_BY_DISPLAYNAME(displayName)));
        }
    }
}

