/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;

public class FarmProductsHelper {
    private static final String FARMPURBILLTYPENUM = "im_PurInBill_FARM_BT_S";
    private static final String FARMPURRECBILLTYPENUM = "im_PurRecBill_FARM_BT_S";

    public static void materialSelect(DynamicObject bill, ListShowParameter showParameter) {
        boolean isFarmBillType = FarmProductsHelper.isFarmBillType(bill);
        if (!isFarmBillType) {
            return;
        }
        QFilter qFilter = new QFilter("masterid.farmproducts", "=", (Object)Boolean.TRUE);
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    public static void changeMaterial(DynamicObject bill, DynamicObject material, DynamicObject entry) {
        boolean isFarmBillType = FarmProductsHelper.isFarmBillType(bill);
        if (!isFarmBillType) {
            return;
        }
        if (material == null) {
            entry.set("deductiblerate", null);
            return;
        }
        DynamicObject masterId = material.getDynamicObject("masterid");
        Object deductibleRate = masterId.get("deductiblerate");
        entry.set("deductiblerate", deductibleRate);
    }

    public static void setDeductibleRate(DynamicObject data) {
        String formId = data.getDataEntityType().getName();
        if (!"im_purinbill".equals(formId)) {
            return;
        }
        boolean isFarmBillType = FarmProductsHelper.isFarmBillType(data);
        if (!isFarmBillType) {
            return;
        }
        DynamicObjectCollection entryList = data.getDynamicObjectCollection("billentry");
        for (DynamicObject entry : entryList) {
            DynamicObject material;
            Object deductibleRate;
            BigDecimal entryDeductibleRate;
            DynamicObject materialInfo = entry.getDynamicObject("material");
            if (materialInfo == null || null != (entryDeductibleRate = entry.getBigDecimal("deductiblerate")) && entryDeductibleRate.compareTo(BigDecimal.ZERO) != 0 || null == (deductibleRate = (material = materialInfo.getDynamicObject("masterid")).get("deductiblerate"))) continue;
            entry.set("deductiblerate", deductibleRate);
        }
    }

    public static boolean isFarmBillType(DynamicObject bill) {
        String formId = bill.getDataEntityType().getName();
        if (!"im_purinbill".equals(formId) && !"im_purreceivebill".equals(formId)) {
            return false;
        }
        DynamicObject billType = bill.getDynamicObject("billtype");
        if (null == billType) {
            return false;
        }
        String billTypeNum = billType.getString("number");
        return FARMPURBILLTYPENUM.equals(billTypeNum) || FARMPURRECBILLTYPENUM.equals(billTypeNum);
    }
}

