/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.mobim.business.helper.QtyAndUnitHelper;
import kd.scmc.mobim.common.design.factory.BillCalcFactory;
import kd.scmc.mobim.common.design.factory.ClacManager;
import kd.scmc.mobim.common.utils.MetaUtils;
import kd.scmc.msmob.pojo.ChangedField;
import org.apache.commons.lang3.StringUtils;

public class ImBillCalculateHelper {
    private static final Log log = LogFactory.getLog(ImBillCalculateHelper.class);

    public static DynamicObject calcMainEntry(DynamicObject bill, List<ChangedField> changedFields) {
        if (bill == null) {
            String errorMsg = ResManager.loadKDString((String)"BillCalculateHelper.calcMainEntry\u65b9\u6cd5\u7684\u5165\u53c2\u3010bill\u3011\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"BillCalculateHelper_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        if (changedFields == null || changedFields.isEmpty()) {
            return bill;
        }
        DynamicObjectCollection billEntry = bill.getDynamicObjectCollection("billentry");
        if (billEntry == null || billEntry.size() == 0) {
            return bill;
        }
        Map<ChangedField, Object> changedFieldMap = ImBillCalculateHelper.preCalculate(changedFields, billEntry);
        for (ChangedField changedField : changedFields) {
            String string = changedField.getFieldKey();
            if (StringUtils.isEmpty((CharSequence)string) || !MetaUtils.isExistEntryFieldKey(bill, "billentry", string)) continue;
            int rowIndex = changedField.getRowIndex();
            ClacManager propChangedCalcManager = BillCalcFactory.createPropChangedCalcManager(string);
            if (propChangedCalcManager == null) continue;
            propChangedCalcManager.calculate(bill, rowIndex);
        }
        ImBillCalculateHelper.afterPropChangedCalc(billEntry, changedFieldMap);
        HashMap<Integer, String> lastChangedFieldMap = new HashMap<Integer, String>(16);
        for (Map.Entry<ChangedField, Object> entry : changedFieldMap.entrySet()) {
            ChangedField changedField = entry.getKey();
            String fieldKey = changedField.getFieldKey();
            int rowIndex = changedField.getRowIndex();
            lastChangedFieldMap.put(rowIndex, fieldKey);
        }
        ImBillCalculateHelper.reCalcBaseQty(lastChangedFieldMap, bill);
        ClacManager clacManager = BillCalcFactory.createSysCalcManager();
        clacManager.calculate(bill);
        return bill;
    }

    private static void reCalcBaseQty(Map<Integer, String> lastChangedFieldMap, DynamicObject bill) {
        QtyAndUnitHelper qtyAndUnitHelper = new QtyAndUnitHelper(bill, "billentry");
        for (Map.Entry<Integer, String> changedFieldEntry : lastChangedFieldMap.entrySet()) {
            String fieldKey;
            int rowIndex = changedFieldEntry.getKey();
            switch (fieldKey = changedFieldEntry.getValue()) {
                case "qty": {
                    qtyAndUnitHelper.calcBaseQtyByQty(rowIndex);
                    break;
                }
                case "qtyunit2nd": {
                    qtyAndUnitHelper.calcBaseQtyByQtyunit2nd(rowIndex);
                    break;
                }
            }
        }
    }

    private static Map<ChangedField, Object> preCalculate(List<ChangedField> changedFields, DynamicObjectCollection billEntry) {
        HashMap<ChangedField, Object> changedFieldMap = new HashMap<ChangedField, Object>(16);
        for (ChangedField entryPropArgs : changedFields) {
            String fieldKey = entryPropArgs.getFieldKey();
            int rowIndex = entryPropArgs.getRowIndex();
            Object filedValue = ((DynamicObject)billEntry.get(rowIndex)).get(fieldKey);
            changedFieldMap.put(entryPropArgs, filedValue);
        }
        return changedFieldMap;
    }

    private static void afterPropChangedCalc(DynamicObjectCollection billEntry, Map<ChangedField, Object> changedFieldMap) {
        for (Map.Entry<ChangedField, Object> changedFieldEntry : changedFieldMap.entrySet()) {
            ChangedField changedField = changedFieldEntry.getKey();
            String fieldKey = changedField.getFieldKey();
            int rowIndex = changedField.getRowIndex();
            Object fieldValue = changedFieldEntry.getValue();
            DynamicObject entryRow = (DynamicObject)billEntry.get(rowIndex);
            entryRow.set(fieldKey, fieldValue);
        }
    }

    public static List<ChangedField> buildCalPropList(String fieldsStr) {
        ArrayList result = JSON.parseArray((String)fieldsStr, ChangedField.class);
        if (result == null) {
            result = new ArrayList(10);
        }
        return result;
    }
}

