/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.mobim.business.helper.MobInvQueryHelper;
import kd.scmc.mobim.business.helper.QFilterHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBizBillInfoTplPlugin;
import kd.scmc.msmob.pojo.InvQueryConfig;

public class InQueryHelper {
    public static void query(MobBizBillInfoTplPlugin plugin, QFilter qFilter, String operationKey, String invQueryOpItemKey) {
        String pcEntryKey = InQueryHelper.recordCurrentEntryKey(plugin, operationKey);
        String subStrOfEntryKey = pcEntryKey.contains(".") ? StringUtils.substringAfter((String)pcEntryKey, (String)".") : pcEntryKey;
        InvQueryConfig invQueryConfig = MobInvQueryHelper.getInvQueryConfig(plugin, subStrOfEntryKey, invQueryOpItemKey);
        String invQueryConfigStr = SerializationUtils.toJsonString((Object)invQueryConfig);
        plugin.getPageCache().put("invQueryConfigCache", invQueryConfigStr);
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)plugin.getPcEntityKey());
        EntityType entityType = (EntityType)dataEntityType.getAllEntities().get(subStrOfEntryKey);
        Boolean isSubEntry = entityType instanceof SubEntryType ? Boolean.TRUE : Boolean.FALSE;
        Boolean isEditable = plugin.isEditable();
        customParams.put("isEditable", isEditable);
        DynamicObject currEntityObject = EntityCacheHelper.getPcEntityFromCache((IFormView)plugin.getView(), (String)plugin.getPcEntityKey());
        QFilter filter = MobInvQueryHelper.fillExpandFilter(currEntityObject, subStrOfEntryKey, -1, invQueryOpItemKey);
        qFilter.and(filter);
        customParams.put("filterCondition", qFilter.toSerializedString());
        customParams.put("srcFilterFrom", "mob_bizbill");
        customParams.put("isSubEntry", isSubEntry);
        customParams.put("invQueryItemKey", invQueryOpItemKey);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "queryOpCallBack");
        customParams.put("pcEntityKey", plugin.getPcEntityKey());
        customParams.put("invQueryConfig", invQueryConfigStr);
        String pcEntityStr = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{currEntityObject}, (DynamicObjectType)dataEntityType);
        customParams.put("datasource", pcEntityStr);
        customParams.put("invQueryParentViewId", plugin.getView().getEntityId());
        customParams.put("mobFormKeyOfMainPage", plugin.getFormKey());
        String mobEntryKey = MobInvQueryHelper.matchEntryKey(plugin, operationKey);
        int entryCurrentRowIndex = plugin.getView().getModel().getEntryCurrentRowIndex(mobEntryKey);
        customParams.put("currMainEntryRowIndex", String.valueOf(entryCurrentRowIndex));
        InQueryHelper.showInvQueryResultList(plugin, customParams, closeCallBack);
    }

    public static String recordCurrentEntryKey(MobBizBillInfoTplPlugin plugin, String operationKey) {
        String mobEntryKey = MobInvQueryHelper.matchEntryKey(plugin, operationKey);
        String pcEntryKey = plugin.getPageCache().get(mobEntryKey);
        int entryCurrentRowIndex = plugin.getView().getModel().getEntryCurrentRowIndex(mobEntryKey);
        IPageCache pageCache = plugin.getPageCache();
        pageCache.put("currMainEntryRowIndex", String.valueOf(entryCurrentRowIndex));
        pageCache.put("currEntryKeyOfInvQuery", mobEntryKey);
        pageCache.put("currEntryRowIndexOfInvQuery", String.valueOf(entryCurrentRowIndex));
        return pcEntryKey;
    }

    private static void showInvQueryResultList(MobBizBillInfoTplPlugin plugin, Map<String, Object> customParams, CloseCallBack closeCallBack) {
        IDataModel model = plugin.getView().getModel();
        IFormView currentView = plugin.getView();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            Long orgId = Long.valueOf(org.getPkValue().toString());
            boolean hasViewPermission = PermissionHelper.checkPermission((Long)orgId, (String)MetaUtils.getPcAppId((String)"im_inv_realbalance"), (String)"im_inv_realbalance", (String)"47150e89000000ac");
            if (hasViewPermission) {
                PageUtils.showFormPage((IFormView)currentView, (String)"msmob_invqueryresult", customParams, (CloseCallBack)closeCallBack);
            } else {
                String errMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5373\u65f6\u5e93\u5b58\u4f59\u989d\u8868\u7684\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvQueryConditionEditPlugin_INVQUERY_PERMVIEW", (String)"scmc-msmob-form", (Object[])new Object[0]);
                currentView.showErrorNotification(errMsg);
            }
        }
    }

    @Deprecated
    public static QFilter buildInvRealBalanceFilter(MobBizBillInfoTplPlugin plugin, DynamicObject pcEntity, InvQueryConfig invQueryConfig) {
        return QFilterHelper.getIdentEqFilter();
    }
}

