/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.im.report.invbillagereport.InvBillAgeRptQuery;
import kd.scmc.msmob.business.helper.SchemeOpHelper;
import org.apache.commons.lang3.StringUtils;

public class InvBillAgeReportHelper {
    private static Log LOG = LogFactory.getLog(InvBillAgeReportHelper.class);

    public static DataSet query(ReportQueryParam queryParam) {
        InvBillAgeRptQuery invBillAgeRptQuery = new InvBillAgeRptQuery();
        try {
            return invBillAgeRptQuery.query(queryParam, null);
        }
        catch (Throwable throwable) {
            LOG.error(throwable.getMessage());
            String msg = ResManager.loadKDString((String)"\u8c03\u7528\u5e93\u5b58\u8d26\u9f84\u5206\u6790\u67e5\u8be2\u62a5\u9519", (String)"InvBillAgeReportHelper_5", (String)"scmc-mobim-form", (Object[])new Object[0]);
            throw new KDBizException(msg);
        }
    }

    public static ReportQueryParam getReportQueryParam(DynamicObject filterDyn) {
        ReportQueryParam queryParam = new ReportQueryParam();
        FilterInfo filter = new FilterInfo();
        String analysis = filterDyn.getString("ageanalysis");
        filter.addFilterItem("ageanalysis", (Object)analysis, CompareTypeEnum.CHECKBOXEQUAL.getId());
        String analysisValue = "1";
        if (analysisValue.equals(analysis)) {
            filter.addFilterItem("enddate", (Object)filterDyn.getDate("enddate"), CompareTypeEnum.EQUAL.getId());
        }
        filter.addFilterItem("orghead", (Object)filterDyn.getDynamicObject("orghead"), CompareTypeEnum.ORGEQUAL.getId());
        filter.addFilterItem("materialgroupstandard", (Object)filterDyn.getDynamicObject("materialgroupstandard"), CompareTypeEnum.ORGEQUAL.getId());
        DynamicObjectCollection collection = filterDyn.getDynamicObjectCollection("entryentity");
        ArrayList<Integer> intervalDays = new ArrayList<Integer>(32);
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject entry = (DynamicObject)collection.get(i);
            int day = entry.getInt("intervaldays");
            intervalDays.add(day);
        }
        intervalDays.add(0);
        String join = StringUtils.join(intervalDays, (String)",");
        filter.addFilterItem("intervaldays", (Object)join, "=");
        queryParam.setFilter(filter);
        return queryParam;
    }

    public static List<String> getGroups(DynamicObject filterDyn) {
        DynamicObjectCollection collection = filterDyn.getDynamicObjectCollection("entryentity");
        int size = collection.size();
        ArrayList<String> groupList = new ArrayList<String>(size);
        int end = 0;
        for (int i = 0; i < collection.size(); ++i) {
            DynamicObject entry = (DynamicObject)collection.get(i);
            int day = entry.getInt("intervaldays");
            int start = end;
            end = day + end;
            if (day <= 0) break;
            String msg = ResManager.loadKDString((String)"%1$s-%2$s\u5929", (String)"InvBillAgeReportHelper_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
            groupList.add(String.format(msg, start, end - 1));
        }
        String msg = ResManager.loadKDString((String)"%s\u5929\u4ee5\u4e0a", (String)"InvBillAgeReportHelper_1", (String)"scmc-mobim-form", (Object[])new Object[0]);
        groupList.add(String.format(msg, end));
        return groupList;
    }

    public static DynamicObject getDynamicObjectByScheme(Object org) {
        DynamicObject scheme = SchemeOpHelper.getRecentScheme((String)"invBillAgeReport");
        DynamicObject filterDyn = scheme == null ? InvBillAgeReportHelper.saveRecentScheme(org) : InvBillAgeReportHelper.getDynamicObjectByScheme(scheme);
        return filterDyn;
    }

    public static DynamicObject getDynamicObjectByScheme(DynamicObject scheme) {
        String filterContent = scheme.getString("content_tag");
        DynamicObject ageFilter = BusinessDataServiceHelper.newDynamicObject((String)"mobim_invbillagefilter");
        Object[] filterDyns = DynamicObjectSerializeUtil.deserialize((String)filterContent, (DynamicObjectType)ageFilter.getDynamicObjectType());
        DynamicObject filterDyn = (DynamicObject)filterDyns[0];
        return filterDyn;
    }

    public static DynamicObject saveRecentScheme(Object org) {
        DynamicObject orgDyn = (DynamicObject)org;
        DynamicObject materialGroupStandardId = BusinessDataServiceHelper.loadSingle((Object)730148448254487552L, (String)"bd_materialgroupstandard", (String)"id,name,number,masterid");
        DynamicObject ageFilter = BusinessDataServiceHelper.newDynamicObject((String)"mobim_invbillagefilter");
        DynamicObject bosOrg = BusinessDataServiceHelper.newDynamicObject((String)"bos_org");
        bosOrg.set("id", orgDyn.getPkValue());
        bosOrg.set("name", orgDyn.get("name"));
        ageFilter.set("orghead", (Object)bosOrg);
        ageFilter.set("materialgroupstandard", (Object)materialGroupStandardId);
        ageFilter.set("ageanalysis", (Object)"0");
        DynamicObjectCollection collection = ageFilter.getDynamicObjectCollection("entryentity");
        collection.clear();
        DynamicObject group = new DynamicObject(collection.getDynamicObjectType());
        group.set("intervaldays", (Object)7);
        String groupMsg = ResManager.loadKDString((String)"%1$s-%2$s\u5929", (String)"InvBillAgeReportHelper_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
        group.set("invagegroup", (Object)String.format(groupMsg, 0, 6));
        String nameMsg = ResManager.loadKDString((String)"\u5206\u7ec4%s", (String)"InvBillAgeReportHelper_2", (String)"scmc-mobim-form", (Object[])new Object[0]);
        group.set("groupname", (Object)String.format(nameMsg, 1));
        collection.add((Object)group);
        ArrayList<String> description = new ArrayList<String>(5);
        String dateMsg = ResManager.loadKDString((String)"\u5373\u65f6\u5e93\u5b58", (String)"InvBillAgeReportFilterPlugin_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
        description.add(dateMsg);
        description.add(orgDyn.getString("name"));
        description.add(materialGroupStandardId.getString("name"));
        String groupsMsg = ResManager.loadKDString((String)"\u8d26\u9f84\u5206\u7ec4\u5171%s\u7ec4", (String)"InvBillAgeReportHelper_4", (String)"scmc-mobim-form", (Object[])new Object[0]);
        description.add(String.format(groupsMsg, 2));
        String content = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{ageFilter}, (DynamicObjectType)ageFilter.getDynamicObjectType());
        SchemeOpHelper.saveRecentScheme((String)"invBillAgeReport", (String)content, (String)StringUtils.join(description, (String)";"));
        return ageFilter;
    }

    public static List<String> getLabelColorList() {
        ArrayList<String> labelColorList = new ArrayList<String>(12);
        labelColorList.add("#95DE65");
        labelColorList.add("#FFA940");
        labelColorList.add("#FFD666");
        labelColorList.add("#F57582");
        labelColorList.add("#1890FF");
        labelColorList.add("#45DAD1");
        labelColorList.add("#9F69E2");
        return labelColorList;
    }
}

