/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.DataChangeHelper;
import kd.scmc.mobim.common.consts.InvSchemeConst;
import kd.scmc.mobim.common.utils.MobileControlUtils;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import org.apache.commons.lang3.StringUtils;

public class InverseBillHelper {
    private static final Log log = LogFactory.getLog(InverseBillHelper.class);
    private static final String COLOR_ORANGE = "#ff991c";
    private static final String COLOR_RED = "#ff0000";
    private static final String COLOR_GREY = "#212121";

    public static void handleInverseColumn(IFormView view, DynamicObject invScheme, Set<String> headColumns, Set<String> entryColumns, Set<String> negativeNumColumn) {
        boolean isNegativeBill = InverseBillHelper.judgeIsInverseBillByPcEntity(invScheme);
        InverseBillHelper.handleInverseColumn(view, headColumns, entryColumns, negativeNumColumn, isNegativeBill);
    }

    public static void handleInverseColumn(IFormView view, Set<String> headColumns, Set<String> entryColumns, Set<String> negativeNumColumn, boolean isNegativeBill) {
        IDataModel model = view.getModel();
        InverseBillHelper.setInverseColumnColor(view, entryColumns.toArray(new String[0]), isNegativeBill);
        InverseBillHelper.setInverseHeadColumnColor(view, headColumns.toArray(new String[0]), isNegativeBill);
        if (isNegativeBill) {
            InverseBillHelper.setInverseValues(model, negativeNumColumn.toArray(new String[0]));
        }
    }

    public static void handleMentryInverseColumn(IFormView view, Set<String> entryColumns, Set<String> negativeNumColumn, boolean isNegativeBill, int startIndex, int endIndex) {
        IDataModel model = view.getModel();
        InverseBillHelper.setMentryColumsColor(view, entryColumns.toArray(new String[0]), isNegativeBill, startIndex, endIndex);
        if (isNegativeBill) {
            InverseBillHelper.setInverseValues(model, negativeNumColumn.toArray(new String[0]));
        }
    }

    public static void setInverseColumnColor(IFormView view, String[] redColumns) {
        IDataModel model = view.getModel();
        boolean isInverseBill = InverseBillHelper.isInverseBill(model);
        InverseBillHelper.setEntryColumsColor(view, redColumns, isInverseBill);
    }

    public static void setInverseColumnColor(IFormView view, String[] redColumns, boolean isInverseBill) {
        InverseBillHelper.setEntryColumsColor(view, redColumns, isInverseBill);
    }

    @Deprecated
    public static void setInverseHeadColumnColor(IFormView view, String[] redColumns) {
        IDataModel model = view.getModel();
        boolean isInverseBill = InverseBillHelper.isInverseBill(model);
        InverseBillHelper.setHeadColumsColor(view, redColumns, isInverseBill);
    }

    public static void setInverseHeadColumnColorByPcEntity(IFormView view, DynamicObject pcEntity, String[] redColumns) {
        boolean isInverseBill = InverseBillHelper.judgeIsInverseBillByPcEntity(pcEntity);
        InverseBillHelper.setHeadColumsColor(view, redColumns, isInverseBill);
    }

    public static DynamicObject getInvScheme(String pcBillKey, Long billId) {
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)pcBillKey);
        return bill.getDynamicObject("invscheme");
    }

    public static void setInverseHeadColumnColor(IFormView view, String[] redColumns, boolean isInverseBill) {
        InverseBillHelper.setHeadColumsColor(view, redColumns, isInverseBill);
    }

    public static void setHeadColumsColor(IFormView view, String[] redColumns, boolean isInverseBill) {
        for (String column : redColumns) {
            Control control = view.getControl(column);
            if (control == null) {
                return;
            }
            String key = control.getKey();
            HashMap<String, String> dataMap = new HashMap<String, String>(32);
            ArrayList<Object> list = new ArrayList<Object>();
            list.add(key);
            list.add(dataMap);
            String color = COLOR_GREY;
            if (isInverseBill) {
                color = COLOR_RED;
            }
            dataMap.put("fc", color);
            IClientViewProxy proxy = (IClientViewProxy)control.getView().getService(IClientViewProxy.class);
            proxy.addAction("updateControlMetadata", list);
        }
    }

    public static void setInverseValues(IDataModel model, String[] needInverseColumns) {
        DynamicObjectCollection entry = model.getEntryEntity("entryentity");
        int size = entry.size();
        for (int i = 0; i < size; ++i) {
            for (String column : needInverseColumns) {
                BigDecimal value = ((DynamicObject)entry.get(i)).getBigDecimal(column);
                if (value == null) {
                    value = BigDecimal.ZERO;
                }
                DataChangeHelper.setValue((IDataModel)model, (String)column, (Object)value.abs(), (int)i, (boolean)false);
            }
        }
    }

    @Deprecated
    public static void handleInverseColumn(IFormView view, String pcEntityKey, DynamicObject invScheme, Set<String> headColumns, Set<String> entryColumns, Set<String> negativeNumColumn) {
        boolean isNegativeBill = InverseBillHelper.isInverseBill(invScheme);
        InverseBillHelper.handleInverseColumn(view, pcEntityKey, headColumns, entryColumns, negativeNumColumn, isNegativeBill);
    }

    public static void handleInverseColumnByPcEntity(IFormView view, String pcEntityKey, DynamicObject pcEntity, Set<String> headColumns, Set<String> entryColumns, Set<String> negativeNumColumn) {
        boolean isNegativeBill = InverseBillHelper.judgeIsInverseBillByPcEntity(pcEntity);
        InverseBillHelper.handleInverseColumn(view, pcEntityKey, headColumns, entryColumns, negativeNumColumn, isNegativeBill);
    }

    public static void handleInverseColumn(IFormView view, String pcEntityKey, Set<String> headColumns, Set<String> entryColumns, Set<String> negativeNumColumn, boolean isNegativeBill) {
        InverseBillHelper.setInverseColumnColor(view, entryColumns.toArray(new String[0]), isNegativeBill);
        InverseBillHelper.setInverseHeadColumnColor(view, headColumns.toArray(new String[0]), isNegativeBill);
        if (isNegativeBill) {
            InverseBillHelper.setInverseValues(view, pcEntityKey, negativeNumColumn.toArray(new String[0]));
        }
    }

    public static void handleEntryInverseColumn(IFormView view, String pcEntityKey, Set<String> entryColumns, Set<String> negativeNumColumn, boolean isNegativeBill, int startIndex, int endIndex) {
        InverseBillHelper.setMentryColumsColor(view, entryColumns.toArray(new String[0]), isNegativeBill, startIndex, endIndex);
        if (isNegativeBill) {
            InverseBillHelper.setInverseValues(view, pcEntityKey, negativeNumColumn.toArray(new String[0]));
        }
    }

    public static void setInverseValues(IFormView view, String pcEntityKey, String[] needInverseColumns) {
        DynamicObject entity = EntityCacheHelper.getPcEntityFromCache((IFormView)view, (String)pcEntityKey);
        DynamicObjectCollection entry = entity.getDynamicObjectCollection("billentry");
        IDataModel model = view.getModel();
        int size = entry.size();
        for (int i = 0; i < size; ++i) {
            for (String column : needInverseColumns) {
                DynamicObject entryDyn = (DynamicObject)entry.get(i);
                BigDecimal value = entryDyn.getBigDecimal(column);
                if (value == null) {
                    value = BigDecimal.ZERO;
                }
                entryDyn.set(column, (Object)value.abs());
                DataChangeHelper.setValue((IDataModel)model, (String)column, (Object)value.abs(), (int)i, (boolean)false);
            }
        }
        EntityCacheHelper.savePcEntityToPageCache((IFormView)view, (DynamicObject)entity);
    }

    @Deprecated
    public static boolean isInverseBill(IDataModel model) {
        try {
            DynamicObject invScheme = (DynamicObject)model.getValue("invscheme");
            return InverseBillHelper.isInverseBill(invScheme);
        }
        catch (KDException e) {
            log.warn((Throwable)e);
            return false;
        }
    }

    public static boolean judgeIsInverseBillByPcEntity(DynamicObject pcEntity) {
        try {
            DynamicObject invScheme = pcEntity.getDynamicObject("invscheme");
            boolean caBill = pcEntity.getBoolean("ischargeoff");
            boolean negativeBill = InverseBillHelper.isInverseBill(invScheme);
            if (caBill) {
                return !negativeBill;
            }
            return negativeBill;
        }
        catch (Exception e) {
            log.warn((Throwable)e);
            return false;
        }
    }

    @Deprecated
    public static boolean isInverseBill(DynamicObject invScheme) {
        if (invScheme == null) {
            return false;
        }
        boolean isInverseBill = false;
        DynamicObject transceiverType = (invScheme = BusinessDataServiceHelper.loadSingleFromCache((Object)invScheme.getPkValue(), (String)"im_invscheme", (String)InvSchemeConst.getAllSelector())).getDynamicObject("transceivertype");
        if (transceiverType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5e93\u5b58\u4e8b\u52a1\u672a\u914d\u7f6e\u6536\u53d1\u7c7b\u578b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\uff01", (String)"InverseBillHelper_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        String bizDirection = transceiverType.getString("bizdirection");
        if (StringUtils.isEmpty((CharSequence)bizDirection)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u5e93\u5b58\u4e8b\u52a1\u7684\u65f6\u6536\u53d1\u7c7b\u578b\u672a\u914d\u7f6e\u4e1a\u52a1\u65b9\u5411\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\uff01", (String)"InverseBillHelper_1", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        if ("1".equals(bizDirection)) {
            isInverseBill = true;
        }
        return isInverseBill;
    }

    public static void setEntryColumsColor(IFormView view, String[] redColumns, boolean isInverseBill) {
        DynamicObjectCollection entity = view.getModel().getEntryEntity("entryentity");
        if (entity == null || entity.isEmpty()) {
            return;
        }
        InverseBillHelper.setMentryColumsColor(view, redColumns, isInverseBill, 0, entity.size());
    }

    public static void setMentryColumsColor(IFormView view, String[] redColumns, boolean isInverseBill, int startIndex, int endIndex) {
        CardEntry grid = (CardEntry)view.getControl("entryentity");
        DynamicObjectCollection entity = view.getModel().getEntryEntity("entryentity");
        if (entity == null || entity.isEmpty()) {
            return;
        }
        HashMap<String, Object> proData = new HashMap<String, Object>(2);
        String color = COLOR_GREY;
        if (isInverseBill) {
            color = COLOR_RED;
        }
        proData.put("fc", color);
        for (int i = startIndex; i <= endIndex; ++i) {
            MobileControlUtils.setCardEntryRowProperties(grid, i, proData, redColumns);
        }
    }

    public static Boolean isRedBill(DynamicObject pcEntity) {
        if (InverseBillHelper.noInvScheme(pcEntity)) {
            return false;
        }
        return InverseBillHelper.judgeIsInverseBillByPcEntity(pcEntity);
    }

    private static boolean noInvScheme(DynamicObject pcEntity) {
        String formId = pcEntity.getDataEntityType().getName();
        return "im_initbill".equalsIgnoreCase(formId) || "im_locationtransfer".equalsIgnoreCase(formId);
    }
}

