/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.scmc.im.business.helper.AppParameterHelper;
import kd.scmc.im.business.helper.WareHouseIsolateHelper;
import kd.scmc.im.business.helper.WarehouseHelper;

public class MobImBillScanHelper {
    private static final String algoKey = MobImBillScanHelper.class.getName();

    public static Long[] getAllWarehouseIds(String formId, Long orgId) {
        List<Long> ids = MobImBillScanHelper.getCustomWarehouseF7Filter(formId, orgId);
        if (ids == null) {
            return WarehouseHelper.getAllWarehouseIDs((Long)orgId);
        }
        return ids.toArray(new Long[0]);
    }

    public static List<Long> getCustomWarehouseF7Filter(String formId, Long orgId) {
        if (orgId == null) {
            return null;
        }
        long userId = UserServiceHelper.getCurrentUserId();
        Object wareHouseIsolate = AppParameterHelper.getAppParameterByFormId((String)formId, (Long)orgId, (String)"fwarehouseisolate");
        if (wareHouseIsolate instanceof Boolean && Boolean.FALSE.equals(wareHouseIsolate)) {
            return null;
        }
        List wareHouses = "im_invcountscheme".equals(formId) || "im_invcountbill".equals(formId) ? WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId((Long)userId, Collections.singletonList(orgId), (String)formId) : WareHouseIsolateHelper.getWarehouseByUserIdAndOrgId((Long)userId, Collections.singletonList(orgId));
        if (CollectionUtils.isEmpty((Collection)wareHouses)) {
            return null;
        }
        HashSet<Long> baseDataIds = MobImBillScanHelper.getBaseDataIds(orgId);
        ArrayList<Long> wareHouseIds = new ArrayList<Long>(16);
        for (DynamicObject wareHose : wareHouses) {
            Long wareHosePkValue = (Long)wareHose.getPkValue();
            if (!baseDataIds.contains(wareHosePkValue)) continue;
            wareHouseIds.add(wareHosePkValue);
        }
        return wareHouseIds;
    }

    private static HashSet<Long> getBaseDataIds(Long orgId) {
        HashSet<Long> warehouseIDs = new HashSet<Long>(1024);
        String sql = "select FDATAID,FUSEORGID from T_BD_WAREHOUSE_U WHERE FUSEORGID = " + orgId;
        DataSet warehouse_U = DB.queryDataSet((String)algoKey, (DBRoute)new DBRoute("sys"), (String)sql);
        while (warehouse_U.hasNext()) {
            Row row = warehouse_U.next();
            Long warehouseId = row.getLong("FDATAID");
            warehouseIDs.add(warehouseId);
        }
        return warehouseIDs;
    }
}

