/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.RefEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.extplugin.PluginProxy;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.BillEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.operation.CustOperationParameter;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.scmc.mobim.business.helper.QFilterHelper;
import kd.scmc.mobim.business.helper.invquery.DefaultInvQueryExpand;
import kd.scmc.msmob.business.helper.DataSourceConfigHelper;
import kd.scmc.msmob.business.helper.EntityCacheHelper;
import kd.scmc.msmob.business.helper.PermissionHelper;
import kd.scmc.msmob.business.helper.change.DataChangedHandlerHelper;
import kd.scmc.msmob.business.helper.change.DataSourceHelper;
import kd.scmc.msmob.business.helper.change.IMobilePage;
import kd.scmc.msmob.business.helper.change.handler.IEntryRowAddedHandler;
import kd.scmc.msmob.common.consts.MobInvQueryConst;
import kd.scmc.msmob.common.consts.SCMCBaseBillMobConst;
import kd.scmc.msmob.common.utils.MetaUtils;
import kd.scmc.msmob.common.utils.PageUtils;
import kd.scmc.msmob.plugin.tpl.basetpl.MobBizBillInfoTplPlugin;
import kd.scmc.msmob.pojo.DataSourceConfig;
import kd.scmc.msmob.pojo.EntryMappingRelationship;
import kd.scmc.msmob.pojo.InvQueryConfig;
import kd.scmc.msmob.pojo.InvQueryFieldMappingRelation;
import kd.scmc.msmob.pojo.ParameterSetting;
import kd.scmc.msmob.pojo.PropertyNode;
import kd.scmc.msmob.service.mservice.baseset.IDataSourceConfigService;
import kd.scmc.msmob.service.mservice.baseset.impl.DataSourceConfigServiceImpl;
import kd.scmc.sbs.business.reservation.ReserveHelper;
import kd.sdk.scmc.mobim.extpoint.IInvQueryExpand;
import kd.sdk.scmc.mobim.extpoint.MobImBillInvQueryExpand;

public class MobInvQueryHelper {
    private static final Set<String> NOT_UPDATE_FIELDKEYS = new HashSet<String>(Arrays.asList("baseunit", "unit", "unit2nd", "lotnum", "producedate", "expirydate", "baseqty", "qty", "qty2nd", "avbbaseqty", "avbqty", "avbqty2nd", "lockbaseqty", "lockqty", "lockqty2nd"));
    private static final String INV_QUERY_OP_TYPE_KEY = "scmcinvquery";
    private static final String NEW_CFG_ENABLE = "1";
    private static final String INVQUERYCONF_META = "im_invqueryconf";
    private static final String CFG_SRCBILLOBJ = "srcbillobj";
    private static final String CFG_OPERATEKEY = "operatekey";
    private static final String CFG_ENABLE = "enable";

    public static final void clickMobInvQueryOp(MobBizBillInfoTplPlugin plugin, String operationKey, String invQueryOpItemKey, String materialKey) {
        Boolean isSubEntry;
        IDataModel model = plugin.getView().getModel();
        IFormView currentView = plugin.getView();
        IPageCache pageCache = plugin.getPageCache();
        MobileFormShowParameter formShowParameter = new MobileFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        customParams.put("invQueryParentViewId", plugin.getView().getEntityId());
        boolean isEditable = plugin.isEditable();
        customParams.put("invQueryItemKey", invQueryOpItemKey);
        customParams.put("isEditable", isEditable);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)plugin, "clickMobInvQueryOpCallBack");
        String mobEntryKey = MobInvQueryHelper.matchEntryKey(plugin, operationKey);
        int currentRowIndex = model.getEntryCurrentRowIndex(mobEntryKey);
        pageCache.put("currEntryKeyOfInvQuery", mobEntryKey);
        pageCache.put("currEntryRowIndexOfInvQuery", String.valueOf(currentRowIndex));
        IDataEntityProperty materialProp = model.getProperty(materialKey);
        if (materialProp == null) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u5e93\u5b58\u67e5\u8be2\u5931\u8d25\uff0c\u5206\u5f55\u3010%1$s\u3011\u4e0a\u6ca1\u6709\u5b9a\u4e49\u5b57\u6bb5\u6807\u8bc6\u3010%2$s\u3011\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MobInvQueryHelper_clickMobInvQueryOp_0", (String)"scmc-mobim-form", (Object[])new Object[0]), mobEntryKey, materialKey);
            currentView.showErrorNotification(errMsg);
            return;
        }
        String pcEntryKey = plugin.getPageCache().get(mobEntryKey);
        String subStrOfEntryKey = pcEntryKey.contains(".") ? StringUtils.substringAfter((String)pcEntryKey, (String)".") : pcEntryKey;
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)plugin.getPcEntityKey());
        EntityType entityType = (EntityType)dataEntityType.getAllEntities().get(subStrOfEntryKey);
        InvQueryConfig invQueryConfig = MobInvQueryHelper.getInvQueryConfig(plugin, subStrOfEntryKey, invQueryOpItemKey);
        Boolean bl = isSubEntry = entityType instanceof SubEntryType ? Boolean.TRUE : Boolean.FALSE;
        if (isSubEntry.booleanValue()) {
            IFormView parentView = currentView.getParentView();
            IDataModel parentModel = parentView.getModel();
            String mobFromKeyOfMainPage = parentView.getEntityId();
            int currMainEntryRowIndex = parentModel.getEntryCurrentRowIndex(mobEntryKey);
            customParams.put("mobFormKeyOfSubPage", plugin.getFormKey());
            customParams.put("currSubEntryRowIndex", String.valueOf(currentRowIndex));
            customParams.put("mobFormKeyOfMainPage", mobFromKeyOfMainPage);
            customParams.put("currMainEntryRowIndex", String.valueOf(currMainEntryRowIndex));
        } else {
            customParams.put("mobFormKeyOfMainPage", plugin.getFormKey());
            customParams.put("currMainEntryRowIndex", String.valueOf(currentRowIndex));
        }
        customParams.put("isSubEntry", isSubEntry);
        DynamicObject material = (DynamicObject)model.getValue(materialKey, currentRowIndex);
        DynamicObject currEntityObject = EntityCacheHelper.getPcEntityFromCache((IFormView)plugin.getView(), (String)plugin.getPcEntityKey());
        String invQueryConfigStr = SerializationUtils.toJsonString((Object)invQueryConfig);
        pageCache.put("invQueryConfigCache", invQueryConfigStr);
        String pcEntityStr = DynamicObjectSerializeUtil.serialize((Object[])new DynamicObject[]{currEntityObject}, (DynamicObjectType)dataEntityType);
        customParams.put("invQueryConfig", invQueryConfigStr);
        customParams.put("datasource", pcEntityStr);
        customParams.put("pcEntityKey", plugin.getPcEntityKey());
        QFilter filter = MobInvQueryHelper.fillExpandFilter(currEntityObject, subStrOfEntryKey, currentRowIndex, invQueryOpItemKey);
        if (material == null) {
            customParams.put("srcFilterFrom", "msmob_invquerycondition");
            customParams.put("expandQFilter", filter.toSerializedString());
            PageUtils.showFormPage((IFormView)currentView, (String)"msmob_invquerycondition", (Map)customParams, (CloseCallBack)closeCallBack);
        } else {
            QFilter qFilter = MobInvQueryHelper.createInvRealBalanceFilter(plugin, currEntityObject, currentRowIndex, invQueryConfig);
            qFilter.and(filter);
            customParams.put("filterCondition", qFilter.toSerializedString());
            customParams.put("srcFilterFrom", "mob_bizbill");
            MobInvQueryHelper.showInvQueryResultList(plugin, customParams, closeCallBack);
        }
    }

    public static QFilter fillExpandFilter(DynamicObject bill, String entryKey, int row, String operateKey) {
        DefaultInvQueryExpand defExpand = new DefaultInvQueryExpand();
        PluginProxy pluginProxy = PluginProxy.create((Object)defExpand, IInvQueryExpand.class, (String)"SCMC_MOBIM_INVQUERY_FILTERANDRETURN");
        HashMap filterMap = new HashMap(1);
        pluginProxy.callAfter(p -> {
            p.getExpandFilter(bill, entryKey, row, operateKey, filterMap);
            return null;
        });
        QFilter expandQFilter = (QFilter)filterMap.get("filter");
        expandQFilter = expandQFilter == null ? QFilterHelper.getIdentEqFilter() : expandQFilter;
        return expandQFilter;
    }

    private static void showInvQueryResultList(MobBizBillInfoTplPlugin plugin, Map<String, Object> customParams, CloseCallBack closeCallBack) {
        IDataModel model = plugin.getView().getModel();
        IFormView currentView = plugin.getView();
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org != null) {
            Long orgId = Long.valueOf(org.getPkValue().toString());
            boolean isView = PermissionHelper.checkPermission((Long)orgId, (String)MetaUtils.getPcAppId((String)"im_inv_realbalance"), (String)"im_inv_realbalance", (String)"47150e89000000ac");
            if (isView) {
                PageUtils.showFormPage((IFormView)currentView, (String)"msmob_invqueryresult", customParams, (CloseCallBack)closeCallBack);
            } else {
                String errMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5373\u65f6\u5e93\u5b58\u4f59\u989d\u8868\u7684\u67e5\u8be2\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"MobBizBillInfoTplPlugin_INVQUERY_PERMVIEW", (String)"scmc-msmob-form", (Object[])new Object[0]);
                currentView.showErrorNotification(errMsg);
            }
        }
    }

    public static String matchEntryKey(MobBizBillInfoTplPlugin plugin, String ctrlKey) {
        if (StringUtils.isEmpty((CharSequence)ctrlKey)) {
            return "";
        }
        List<String> allMobEntryKeys = MobInvQueryHelper.getAllMobEntryKeys(plugin);
        for (String entryKey : allMobEntryKeys) {
            CardEntry cardEntry = (CardEntry)plugin.getControl(entryKey);
            List controls = cardEntry.getControls();
            for (Control control : controls) {
                String controlKey = control.getKey();
                if (!ctrlKey.equals(controlKey)) continue;
                return cardEntry.getKey();
            }
        }
        return "";
    }

    protected static List<String> getAllMobEntryKeys(MobBizBillInfoTplPlugin plugin) {
        Map allEntities = plugin.getView().getModel().getDataEntityType().getAllEntities();
        List<String> entryKeys = allEntities.entrySet().stream().map(mapEntry -> !(mapEntry.getValue() instanceof SubEntryType) && mapEntry.getValue() instanceof EntryType ? (String)mapEntry.getKey() : "").filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        return entryKeys;
    }

    public static InvQueryConfig getInvQueryConfig(MobBizBillInfoTplPlugin plugin, String entryKey, String invQueryOpItemKey) {
        boolean newCfg = MobInvQueryHelper.isUseNewCfg();
        InvQueryConfig invQueryConfig = newCfg ? MobInvQueryHelper.getNewConfig(plugin, invQueryOpItemKey) : MobInvQueryHelper.getOldConfig(plugin, entryKey, invQueryOpItemKey);
        return invQueryConfig;
    }

    public static InvQueryConfig getNewConfig(MobBizBillInfoTplPlugin plugin, String invQueryOpItemKey) {
        DynamicObject invQueryCfg = MobInvQueryHelper.getInvQueryCfg(plugin, invQueryOpItemKey);
        return MobInvQueryHelper.getMapParamFromCfg(invQueryCfg);
    }

    private static InvQueryConfig getMapParamFromCfg(DynamicObject cfg) {
        InvQueryConfig invQueryConfig = new InvQueryConfig();
        ParameterSetting parameterSetting = MobInvQueryHelper.createParameterSetting(cfg);
        List<InvQueryFieldMappingRelation> invQueryFieldMappingList = MobInvQueryHelper.createInvQueryFieldMappings(cfg);
        invQueryConfig.setParameterSetting(parameterSetting);
        invQueryConfig.setInvQueryFieldMappingRelations(invQueryFieldMappingList);
        return invQueryConfig;
    }

    public static DynamicObject getInvQueryCfg(MobBizBillInfoTplPlugin plugin, String invQueryOpItemKey) {
        Map cfgs = BusinessDataServiceHelper.loadFromCache((String)INVQUERYCONF_META, (QFilter[])new QFilter(CFG_SRCBILLOBJ, "=", (Object)plugin.getPcEntityKey()).and(CFG_OPERATEKEY, "=", (Object)invQueryOpItemKey).and(CFG_ENABLE, "=", (Object)NEW_CFG_ENABLE).toArray());
        if (cfgs == null || cfgs.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5e93\u5b58\u67e5\u8be2\u914d\u7f6e\u3002", (String)"MobInvQueryHelper_1", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        if (cfgs.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5355\u636e\u5e93\u5b58\u67e5\u8be2\u914d\u7f6e\u4e86\u591a\u4e2a\u542f\u7528\u89c4\u5219\uff0c\u8bf7\u7981\u7528\u6216\u8005\u5220\u9664\u591a\u4f59\u7684\u89c4\u5219\u3002", (String)"MobInvQueryHelper_0", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        return cfgs.values().toArray(new DynamicObject[0])[0];
    }

    public static InvQueryConfig getOldConfig(MobBizBillInfoTplPlugin plugin, String entryKey, String invQueryOpItemKey) {
        String entityId = MetadataDao.getIdByNumber((String)plugin.getPcEntityKey(), (MetaCategory)MetaCategory.Entity);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
        List items = entityMetadata.getItems();
        String opParameter = MobInvQueryHelper.getOperationParameter(plugin, items, invQueryOpItemKey);
        return MobInvQueryHelper.parseOpParameter(opParameter, entryKey, invQueryOpItemKey);
    }

    public static boolean isUseNewCfg() {
        DynamicObject invdbParam = BusinessDataServiceHelper.loadSingleFromCache((String)"im_invdbparam", (String)"value", (QFilter[])new QFilter("key", "=", (Object)"newInvqryCfg").toArray());
        return invdbParam != null && NEW_CFG_ENABLE.equals(invdbParam.getString("value"));
    }

    private static InvQueryConfig parseOpParameter(String opParameter, String entryKey, String operateKey) {
        Map paramDictionary = (Map)SerializationUtils.fromJsonString((String)opParameter, Map.class);
        Map settingParam = (Map)paramDictionary.get("settingparam");
        List fieldMappings = (List)paramDictionary.get("fielddata");
        InvQueryConfig invQueryConfig = MobInvQueryHelper.createInvQueryConfig(settingParam, fieldMappings, entryKey, operateKey);
        return invQueryConfig;
    }

    private static InvQueryConfig createInvQueryConfig(Map<String, Object> settingParam, List<Map<String, Object>> invQueryFieldMappings, String entryKey, String operateKey) {
        InvQueryConfig invQueryConfig = new InvQueryConfig();
        ParameterSetting parameterSetting = MobInvQueryHelper.createParameterSetting(settingParam, entryKey, operateKey);
        List<InvQueryFieldMappingRelation> invQueryFieldMappingList = MobInvQueryHelper.createInvQueryFieldMappings(invQueryFieldMappings);
        invQueryConfig.setParameterSetting(parameterSetting);
        invQueryConfig.setInvQueryFieldMappingRelations(invQueryFieldMappingList);
        return invQueryConfig;
    }

    private static ParameterSetting createParameterSetting(DynamicObject cfg) {
        ParameterSetting parameterSetting = new ParameterSetting();
        String returnType = cfg.getString("returntype");
        String dealType = cfg.getString("dealtype");
        String proQtyField = cfg.getString("proqtyfield");
        String qtyRule = cfg.getString("qtyrule");
        Boolean newDeal = cfg.getBoolean("newdeal");
        String actionId = cfg.getString("actionid");
        String pluginName = cfg.getString("pluginname");
        String entryNoUpdateFieldKey = cfg.getString("entrynoupdatefieldkey");
        String filterPluginName = cfg.getString("filterpluginname");
        Boolean unitTran = cfg.getBoolean("unittran");
        Boolean middleInsert = cfg.getBoolean("middleinsert");
        String operateKey = cfg.getString(CFG_OPERATEKEY);
        String srcBillEntry = cfg.getString("srcbillentry");
        parameterSetting.setReturnType(returnType);
        parameterSetting.setDealType(dealType);
        parameterSetting.setSupplyQtyField(proQtyField);
        parameterSetting.setQtyRule(qtyRule);
        parameterSetting.setNewDeal(newDeal);
        parameterSetting.setActionId(actionId);
        parameterSetting.setPluginName(pluginName);
        parameterSetting.setFilterPluginName(filterPluginName);
        parameterSetting.setEntryNoUpdateFieldKey(entryNoUpdateFieldKey);
        parameterSetting.setUnitTran(unitTran);
        parameterSetting.setMiddleInsert(middleInsert);
        parameterSetting.setOperateKey(operateKey);
        parameterSetting.setEntryKey(srcBillEntry);
        return parameterSetting;
    }

    private static ParameterSetting createParameterSetting(Map<String, Object> settingParam, String entryKey, String operateKey) {
        ParameterSetting parameterSetting = new ParameterSetting();
        if (settingParam != null && settingParam.size() > 0) {
            String returnType = (String)settingParam.get("returntype");
            String dealType = (String)settingParam.get("dealtype");
            String proQtyField = (String)settingParam.get("proqtyfield");
            String qtyRule = (String)settingParam.get("qtyrule");
            Boolean newDeal = (Boolean)settingParam.get("newdeal");
            String actionId = (String)settingParam.get("actionid");
            String pluginName = (String)settingParam.get("pluginname");
            parameterSetting.setReturnType(returnType);
            parameterSetting.setDealType(dealType);
            parameterSetting.setSupplyQtyField(proQtyField);
            parameterSetting.setQtyRule(qtyRule);
            parameterSetting.setNewDeal(newDeal);
            parameterSetting.setActionId(actionId);
            parameterSetting.setPluginName(pluginName);
            settingParam.put("entrykey", entryKey);
            settingParam.put(CFG_OPERATEKEY, operateKey);
            settingParam.put("unittran", false);
            settingParam.put("middleinsert", false);
        }
        return parameterSetting;
    }

    private static List<InvQueryFieldMappingRelation> createInvQueryFieldMappings(DynamicObject cfg) {
        ArrayList<InvQueryFieldMappingRelation> fieldMappingConfigs = new ArrayList<InvQueryFieldMappingRelation>(10);
        if (cfg == null) {
            return fieldMappingConfigs;
        }
        DynamicObjectCollection entries = cfg.getDynamicObjectCollection("entryentity");
        if (entries == null || entries.isEmpty()) {
            return fieldMappingConfigs;
        }
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>(entries.size());
        for (DynamicObject entry : entries) {
            HashMap<String, Object> field = new HashMap<String, Object>(9);
            field.put("row", entry.getInt("seq") - 1);
            field.put("metadatakey", entry.get("invacccol"));
            field.put("metadata", entry.get("invacccolno"));
            field.put("currentmetadatakey", entry.get("srcbillcol"));
            field.put("currentmetadata", entry.get("srcbillcolno"));
            field.put("qfilter", entry.get("qfilter"));
            field.put("update", entry.get("update"));
            field.put("match", entry.get("match"));
            field.put("returnorder", entry.get("returnorder"));
            fields.add(field);
        }
        fields.sort(new MapFieldComparator());
        return MobInvQueryHelper.createInvQueryFieldMappings(fields);
    }

    private static List<InvQueryFieldMappingRelation> createInvQueryFieldMappings(List<Map<String, Object>> invQueryFieldMappings) {
        ArrayList<InvQueryFieldMappingRelation> fieldMappingConfigs = new ArrayList<InvQueryFieldMappingRelation>(10);
        if (invQueryFieldMappings == null || invQueryFieldMappings.isEmpty()) {
            return fieldMappingConfigs;
        }
        Map<String, PropertyNode> fieldMapping = MobInvQueryHelper.getFieldMappingOfQueryCondition();
        for (Map.Entry<String, PropertyNode> fieldMappingEntry : fieldMapping.entrySet()) {
            InvQueryFieldMappingRelation invQueryFieldMapping = new InvQueryFieldMappingRelation();
            String invFilterFieldkey = fieldMappingEntry.getKey();
            PropertyNode realBalFieldNode = fieldMappingEntry.getValue();
            String realBalFieldKey = realBalFieldNode.getFieldKey();
            for (Map<String, Object> fieldMappingInfo : invQueryFieldMappings) {
                Object returnOrder;
                String invRealBalFieldKey = (String)fieldMappingInfo.get("metadatakey");
                String pcFieldKey = (String)fieldMappingInfo.get("currentmetadatakey");
                Boolean isFilter = (Boolean)fieldMappingInfo.get("qfilter");
                Boolean isUpdate = (Boolean)fieldMappingInfo.get("update");
                Boolean isMatch = (Boolean)fieldMappingInfo.get("match");
                if (!realBalFieldKey.equals(invRealBalFieldKey) || StringUtils.isEmpty((CharSequence)pcFieldKey)) continue;
                isMatch = isMatch == null ? Boolean.FALSE : isMatch;
                isFilter = isFilter == null ? Boolean.FALSE : isFilter;
                isUpdate = isUpdate == null ? Boolean.FALSE : isUpdate;
                Object row = fieldMappingInfo.get("row");
                if (row instanceof Integer) {
                    invQueryFieldMapping.setRow((Integer)row);
                }
                if ((returnOrder = fieldMappingInfo.get("returnorder")) instanceof Integer) {
                    invQueryFieldMapping.setReturnOrder((Integer)returnOrder);
                }
                invQueryFieldMapping.setMatch(isMatch);
                invQueryFieldMapping.setFilter(isFilter);
                invQueryFieldMapping.setUpdate(isUpdate);
                invQueryFieldMapping.setPcFieldKey(pcFieldKey);
                invQueryFieldMapping.setRealBalFieldKey(realBalFieldKey);
                invQueryFieldMapping.setInvFilterFieldKey(invFilterFieldkey);
                fieldMappingConfigs.add(invQueryFieldMapping);
            }
        }
        return fieldMappingConfigs;
    }

    private static Map<String, PropertyNode> getFieldMappingOfQueryCondition() {
        DataSourceConfigServiceImpl dataSourceConfigService = new DataSourceConfigServiceImpl();
        DataSourceConfig dataSourceConfig = dataSourceConfigService.getDataSourceConfig("msmob_invquerycondition");
        Map fieldMapping = dataSourceConfig.getFieldMapping();
        return fieldMapping;
    }

    private static String getOperationParameter(MobBizBillInfoTplPlugin plugin, List<EntityItem<?>> items, String invQueryOpKey) {
        String pcEntityKey = plugin.getPcEntityKey();
        for (EntityItem<?> item : items) {
            String itemKey = item.getKey();
            if (!pcEntityKey.equals(itemKey)) continue;
            List operations = ((BillEntity)item).getOperations();
            for (Operation operation : operations) {
                String key = operation.getKey();
                String operationType = operation.getOperationType();
                if (!INV_QUERY_OP_TYPE_KEY.equals(operationType) || !key.equals(invQueryOpKey)) continue;
                CustOperationParameter operationParameter = (CustOperationParameter)operation.getParameter();
                String parameter = operationParameter.getParameter();
                return parameter;
            }
        }
        return "";
    }

    private static QFilter createInvRealBalanceFilter(MobBizBillInfoTplPlugin plugin, DynamicObject currEntityObject, int entryRowIndex, InvQueryConfig invQueryConfig) {
        QFilter invRealBalanceFilter = new QFilter(NEW_CFG_ENABLE, "=", (Object)SCMCBaseBillMobConst.IDENT_EQ_VAL);
        List invQueryFieldMappingRelations = invQueryConfig.getInvQueryFieldMappingRelations();
        for (InvQueryFieldMappingRelation invQueryFieldMapping : invQueryFieldMappingRelations) {
            Boolean isFilter = invQueryFieldMapping.getFilter();
            if (!isFilter.booleanValue()) continue;
            String pcFieldKey = invQueryFieldMapping.getPcFieldKey();
            String tempPcFieldKey = pcFieldKey.contains(".") ? pcFieldKey.substring(pcFieldKey.lastIndexOf(".") + 1) : pcFieldKey;
            IDataEntityProperty property = ((BillEntityType)currEntityObject.getDynamicObjectType()).findProperty(tempPcFieldKey);
            Object fieldValue = null;
            if (MobInvQueryHelper.isHeadProp(property)) {
                fieldValue = currEntityObject.get(pcFieldKey);
            } else if (MobInvQueryHelper.isSubEntryProp(property)) {
                IDataEntityType parent = property.getParent();
                IDataEntityType entry = parent.getParent();
                String pcEntryKey = entry.getName();
                String pcSubEntryKey = parent.getName();
                fieldValue = MobInvQueryHelper.getSubEntryFieldValue(currEntityObject, pcEntryKey, pcSubEntryKey, pcFieldKey, entryRowIndex);
            } else if (MobInvQueryHelper.isEntryProp(property)) {
                String entryKey = property.getParent().getName();
                fieldValue = MobInvQueryHelper.getEntryFieldValue(plugin, currEntityObject, entryKey, pcFieldKey, entryRowIndex);
            }
            if (fieldValue == null || "".equals(fieldValue)) continue;
            String realBalFieldKey = invQueryFieldMapping.getRealBalFieldKey();
            if (fieldValue instanceof DynamicObject) {
                IDataEntityProperty masterIdProp = ((RefEntityType)((DynamicObject)fieldValue).getDynamicObjectType()).findProperty("masterid");
                if (masterIdProp instanceof BasedataProp) {
                    fieldValue = ((DynamicObject)fieldValue).get("masterid");
                }
                Long id = ((DynamicObject)fieldValue).getLong("id");
                StringBuilder newFieldKey = new StringBuilder();
                newFieldKey.append(realBalFieldKey);
                newFieldKey.append('.');
                newFieldKey.append("id");
                invRealBalanceFilter.and(newFieldKey.toString(), "=", (Object)id);
                continue;
            }
            if (fieldValue instanceof Object[]) {
                invRealBalanceFilter.and(realBalFieldKey, "in", fieldValue);
                continue;
            }
            invRealBalanceFilter.and(realBalFieldKey, "=", fieldValue);
        }
        return invRealBalanceFilter;
    }

    protected static Object getSubEntryFieldValue(DynamicObject currEntityObject, String pcEntryKey, String pcSubEntryKey, String pcSubEntryFieldKey, int subEntryRowIndex) {
        String errMsg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u6682\u4e0d\u652f\u6301\u5b50\u5206\u5f55\u5b57\u6bb5\u503c\u7684\u83b7\u53d6\uff0c\u8bf7\u91cd\u5199MobBizBillInfoTplPlugin.getSubEntryFieldValue\u65b9\u6cd5\u3002", (String)"MobBizBillInfoTplPlugin_getSubEntryFieldValue", (String)"scmc-msmob-form", (Object[])new Object[0]), new Object[0]);
        throw new KDBizException(errMsg);
    }

    private static Object getEntryFieldValue(MobBizBillInfoTplPlugin plugin, DynamicObject currEntityObject, String pcEntryKey, String pcEntryFieldKey, int entryRowIndex) {
        IDataModel model = plugin.getView().getModel();
        DataSourceConfig dataSourceConfig = MobInvQueryHelper.getDataSourceConfig(plugin);
        EntryMappingRelationship entryMappingRelationship = DataSourceConfigHelper.getEntryMappingRelationship((DataSourceConfig)dataSourceConfig, (String)pcEntryKey);
        String mobEntryIdKey = entryMappingRelationship.getMobEntryIdKey();
        Long mobEntryId = (Long)model.getValue(mobEntryIdKey, entryRowIndex);
        DynamicObjectCollection entryRowColl = currEntityObject.getDynamicObjectCollection(pcEntryKey);
        DynamicObject currEntryRow = entryRowColl.stream().filter(entryRow -> entryRow.getPkValue().equals(mobEntryId)).findFirst().get();
        pcEntryFieldKey = pcEntryFieldKey.contains(".") ? pcEntryFieldKey.substring(pcEntryFieldKey.lastIndexOf(".") + 1) : pcEntryFieldKey;
        Object fieldValue = currEntryRow.get(pcEntryFieldKey);
        return fieldValue;
    }

    protected static DataSourceConfig getDataSourceConfig(MobBizBillInfoTplPlugin plugin) {
        DataSourceConfigServiceImpl dataSourceConfigService = new DataSourceConfigServiceImpl();
        return dataSourceConfigService.getDataSourceConfig(plugin.getFormKey());
    }

    protected IDataSourceConfigService getDataSourceConfigService() {
        return new DataSourceConfigServiceImpl();
    }

    private static boolean isHeadProp(IDataEntityProperty property) {
        return property == null ? false : property.getParent() instanceof MainEntityType;
    }

    private static boolean isSubEntryProp(IDataEntityProperty property) {
        return property == null ? false : property.getParent() instanceof SubEntryType;
    }

    private static boolean isEntryProp(IDataEntityProperty property) {
        return !MobInvQueryHelper.isSubEntryProp(property) && property != null && property.getParent() instanceof EntryType;
    }

    public static void closedCallBack(MobBizBillInfoTplPlugin plugin, ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "clickMobInvQueryOpCallBack": 
            case "queryOpCallBack": {
                String returnData = (String)closedCallBackEvent.getReturnData();
                List pcEntityIds = (List)JSON.parseObject((String)returnData, List.class);
                MobInvQueryHelper.mobInvQueryCloseCallBack(plugin, pcEntityIds);
                break;
            }
        }
        String entryKey = plugin.getEntryEntity();
        plugin.getView().updateView(entryKey);
    }

    public static void mobInvQueryCloseCallBack(MobBizBillInfoTplPlugin plugin, List<Long> ids) {
        if (ids == null) {
            return;
        }
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)plugin.getPcEntityKey());
        DynamicObject dealPcEntity = MobInvQueryHelper.dealWithInvRealBalance(plugin, ids);
        EntityCacheHelper.savePcEntityToPageCache((IFormView)plugin.getPcEntityStorageView(), (DynamicObject)dealPcEntity);
        MobInvQueryHelper.updateEntityCache(plugin, dataEntityType, dealPcEntity);
    }

    protected static final void updateEntityCache(MobBizBillInfoTplPlugin plugin, MainEntityType dataEntityType, DynamicObject pcEntity) {
        if (pcEntity == null || dataEntityType == null) {
            return;
        }
        DataSourceHelper.loadPcEntityToMobilePage((AbstractFormPlugin)plugin, (DynamicObject)pcEntity, (boolean)true);
    }

    protected static IPageCache getMainPageCache(MobBizBillInfoTplPlugin plugin) {
        return plugin.getPageCache();
    }

    protected static DynamicObject dealWithInvRealBalance(MobBizBillInfoTplPlugin plugin, List<Long> ids) {
        Long curEntryRowId = null;
        ArrayList<Long> newEntryRowIds = new ArrayList<Long>(4);
        IPageCache pageCache = plugin.getPageCache();
        String pcEntityKey = plugin.getPcEntityKey();
        DynamicObject pcEntityFromCache = EntityCacheHelper.getPcEntityFromCache((IFormView)plugin.getView(), (String)pcEntityKey);
        String mobEntryKey = MobInvQueryHelper.matchEntryKey(plugin, "op_more");
        String pcEntryKey = pageCache.get(mobEntryKey);
        DynamicObject pcEntity = pcEntityFromCache;
        String invQueryConfigCache = pageCache.get("invQueryConfigCache");
        InvQueryConfig invQueryConfig = (InvQueryConfig)SerializationUtils.fromJsonString((String)invQueryConfigCache, InvQueryConfig.class);
        ParameterSetting parameterSetting = invQueryConfig.getParameterSetting();
        String returnType = parameterSetting.getReturnType();
        boolean newDeal = parameterSetting.getNewDeal();
        if ("null".equals(returnType)) {
            return pcEntity;
        }
        if ("single".equals(returnType)) {
            Long id = ids.get(0);
            ids.clear();
            ids.add(id);
        }
        List invQueryFieldMappingRelations = invQueryConfig.getInvQueryFieldMappingRelations();
        boolean hasMatched = false;
        DynamicObject currPcEntryRow = MobInvQueryHelper.getCurrEntryRow(plugin, pcEntity, mobEntryKey);
        for (int i = 0; i < ids.size(); ++i) {
            DynamicObject invRealBalance = BusinessDataServiceHelper.loadSingle((Object)ids.get(i), (String)"im_inv_realbalance");
            boolean isMatch = false;
            MobInvQueryHelper.updateQtyInfoOfInvRealBalance(invRealBalance);
            if (currPcEntryRow == null) {
                return pcEntity;
            }
            if (!hasMatched) {
                hasMatched = isMatch = MobInvQueryHelper.isMatchAll(currPcEntryRow, invRealBalance, invQueryFieldMappingRelations);
            }
            if (isMatch) {
                int currEntryRowIndex = Integer.parseInt(plugin.getPageCache().get("currEntryRowIndexOfInvQuery"));
                DynamicObject selectEntryRow = (DynamicObject)pcEntity.getDynamicObjectCollection(pcEntryKey).get(currEntryRowIndex);
                curEntryRowId = (Long)selectEntryRow.getPkValue();
                MobInvQueryHelper.handleReturnDataInMatchedRow(plugin, pcEntityFromCache, pcEntryKey, invQueryConfig, invQueryFieldMappingRelations, selectEntryRow, invRealBalance);
                hasMatched = true;
            } else if (newDeal) {
                if (!MobInvQueryHelper.isDrawByBOTP(pcEntityFromCache, pcEntryKey, pcEntityKey)) {
                    DataChangedHandlerHelper.afterEntryAddedOperation((AbstractFormPlugin)plugin, (IEntryRowAddedHandler)plugin.getEntryRowAddedHandler(), (String)plugin.getEntryEntity(), null);
                    pcEntity = EntityCacheHelper.getPcEntityFromCache((IMobilePage)plugin);
                    DynamicObject addPcEntryRow = (DynamicObject)pcEntity.getDynamicObjectCollection(pcEntryKey).get(plugin.getView().getModel().getEntryCurrentRowIndex(mobEntryKey));
                    newEntryRowIds.add((Long)addPcEntryRow.getPkValue());
                    MobInvQueryHelper.handleReturnDataInNewRow(plugin, pcEntityFromCache, pcEntryKey, invQueryConfig, invQueryFieldMappingRelations, addPcEntryRow, invRealBalance);
                } else {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u4e0b\u63a8\u5355\u636e\u3002", (String)"MobInvQueryHelper_2", (String)"scmc-mobim-form", (Object[])new Object[0]));
                }
            }
            EntityCacheHelper.savePcEntityToPageCache((IFormView)plugin.getView(), (DynamicObject)pcEntity);
        }
        Long finalCurEntryRowId = curEntryRowId;
        DynamicObject finalPcEntity = pcEntity;
        PluginProxy pluginProxy = PluginProxy.create(MobImBillInvQueryExpand.class, (String)"SCMC_MOBIM_INVQUERY_EXPAND_AFTER_RETURN_DATA");
        pluginProxy.callReplace(p -> {
            String name;
            String entityKey = p.getEntityKey();
            if (entityKey.equals(name = finalPcEntity.getDataEntityType().getName())) {
                p.afterReturnData(plugin.getView(), finalPcEntity, pcEntryKey, finalCurEntryRowId, newEntryRowIds);
            }
            return null;
        });
        return pcEntity;
    }

    private static void handleReturnDataInNewRow(MobBizBillInfoTplPlugin plugin, DynamicObject pcEntityFromCache, String pcEntryKey, InvQueryConfig invQueryConfig, List<InvQueryFieldMappingRelation> invQueryFieldMappingRelations, DynamicObject currPcEntryRow, DynamicObject invRealBalance) {
        HashMap<String, String> invQtyMap = new HashMap<String, String>(16);
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> avbQtyMap = new HashMap<String, BigDecimal>(16);
        ParameterSetting parameterSetting = invQueryConfig.getParameterSetting();
        String qtyRule = parameterSetting.getQtyRule();
        List qtyFields = MobInvQueryConst.INV_REAL_BALANCE_QTY_FIELDS;
        List avbQtyFields = MobInvQueryConst.INV_REAL_BALANCE_AVBQTY_FIELDS;
        MobInvQueryHelper.setLineType(currPcEntryRow);
        for (InvQueryFieldMappingRelation fieldMappingRelation : invQueryFieldMappingRelations) {
            Object invRealBalFieldValue;
            Boolean match = fieldMappingRelation.getMatch();
            Boolean update = fieldMappingRelation.getUpdate();
            if (Boolean.FALSE.equals(match) && Boolean.FALSE.equals(update)) continue;
            String pcFieldKey = fieldMappingRelation.getPcFieldKey();
            String setValuePcFieldKey = MobInvQueryHelper.getPcFieldKeyOfSettingValue(pcFieldKey);
            String invRealBalanceFieldKey = fieldMappingRelation.getRealBalFieldKey();
            if ("material".equals(invRealBalanceFieldKey)) {
                DynamicObject org = (DynamicObject)invRealBalance.get("org");
                DynamicObject material = (DynamicObject)invRealBalance.get(invRealBalanceFieldKey);
                Long orgId = org.getLong("id");
                String orgNumber = org.getString("number");
                invRealBalFieldValue = MobInvQueryHelper.getMaterialInvInfo(material, orgId, orgNumber, setValuePcFieldKey, pcEntityFromCache);
            } else if (invRealBalanceFieldKey.contains("qty")) {
                invQtyMap.put(invRealBalanceFieldKey, setValuePcFieldKey);
                BigDecimal reqQty = currPcEntryRow.getBigDecimal(setValuePcFieldKey);
                BigDecimal supplyQty = invRealBalance.getBigDecimal(invRealBalanceFieldKey);
                invRealBalFieldValue = reqQty != null && reqQty.compareTo(BigDecimal.ZERO) != 0 && "minrule".equals(qtyRule) ? (reqQty.compareTo(supplyQty) > 0 ? supplyQty : reqQty) : ("reqqty".equals(qtyRule) ? reqQty : supplyQty);
                if (avbQtyFields.contains(invRealBalanceFieldKey)) {
                    avbQtyMap.put(setValuePcFieldKey, (BigDecimal)invRealBalFieldValue);
                } else if (qtyFields.contains(invRealBalanceFieldKey)) {
                    qtyMap.put(setValuePcFieldKey, (BigDecimal)invRealBalFieldValue);
                }
            } else {
                invRealBalFieldValue = invRealBalance.get(invRealBalanceFieldKey);
            }
            currPcEntryRow.set(setValuePcFieldKey, invRealBalFieldValue);
            if (!"lotnum".equals(invRealBalanceFieldKey)) continue;
            MobInvQueryHelper.setLotValue(plugin, pcEntityFromCache, invRealBalance, currPcEntryRow, pcEntryKey, pcFieldKey);
        }
        boolean updateZeroToQty2nd = MobInvQueryHelper.isUpdateZeroToQty2nd(currPcEntryRow, invQueryFieldMappingRelations);
        MobInvQueryHelper.setBillQtyByDirFromQty(currPcEntryRow, qtyMap, invQtyMap, updateZeroToQty2nd, "qty", "qty2nd");
        MobInvQueryHelper.setBillQtyByDirFromQty(currPcEntryRow, avbQtyMap, invQtyMap, updateZeroToQty2nd, "avbqty", "avbqty2nd");
    }

    private static void handleReturnDataInMatchedRow(MobBizBillInfoTplPlugin plugin, DynamicObject pcEntityFromCache, String pcEntryKey, InvQueryConfig invQueryConfig, List<InvQueryFieldMappingRelation> invQueryFieldMappingRelations, DynamicObject currPcEntryRow, DynamicObject invRealBalance) {
        MobInvQueryHelper.setLineType(currPcEntryRow);
        HashMap<String, String> invQtyMap = new HashMap<String, String>(16);
        HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> avbQtyMap = new HashMap<String, BigDecimal>(16);
        List qtyFields = MobInvQueryConst.INV_REAL_BALANCE_QTY_FIELDS;
        List avbQtyFields = MobInvQueryConst.INV_REAL_BALANCE_AVBQTY_FIELDS;
        ParameterSetting parameterSetting = invQueryConfig.getParameterSetting();
        String qtyRule = parameterSetting.getQtyRule();
        for (InvQueryFieldMappingRelation fieldMappingRelation : invQueryFieldMappingRelations) {
            Object invRealBalFieldValue;
            Boolean isUpdate = fieldMappingRelation.getUpdate();
            if (!isUpdate.booleanValue()) continue;
            String pcFieldKey = fieldMappingRelation.getPcFieldKey();
            String setValuePcFieldKey = MobInvQueryHelper.getPcFieldKeyOfSettingValue(pcFieldKey);
            String invRealBalanceFieldKey = fieldMappingRelation.getRealBalFieldKey();
            if ("material".equals(invRealBalanceFieldKey)) {
                DynamicObject org = (DynamicObject)invRealBalance.get("org");
                DynamicObject material = (DynamicObject)invRealBalance.get(invRealBalanceFieldKey);
                Long orgId = org.getLong("id");
                String orgNumber = org.getString("number");
                invRealBalFieldValue = MobInvQueryHelper.getMaterialInvInfo(material, orgId, orgNumber, setValuePcFieldKey, pcEntityFromCache);
            } else if (invRealBalanceFieldKey.contains("qty")) {
                invQtyMap.put(invRealBalanceFieldKey, setValuePcFieldKey);
                BigDecimal reqQty = currPcEntryRow.getBigDecimal(setValuePcFieldKey);
                BigDecimal supplyQty = invRealBalance.getBigDecimal(invRealBalanceFieldKey);
                invRealBalFieldValue = reqQty != null && reqQty.compareTo(BigDecimal.ZERO) != 0 && "minrule".equals(qtyRule) ? (reqQty.compareTo(supplyQty) > 0 ? supplyQty : reqQty) : ("reqqty".equals(qtyRule) ? reqQty : supplyQty);
                if (avbQtyFields.contains(invRealBalanceFieldKey)) {
                    avbQtyMap.put(setValuePcFieldKey, (BigDecimal)invRealBalFieldValue);
                } else if (qtyFields.contains(invRealBalanceFieldKey)) {
                    qtyMap.put(setValuePcFieldKey, (BigDecimal)invRealBalFieldValue);
                }
            } else {
                invRealBalFieldValue = invRealBalance.get(invRealBalanceFieldKey);
            }
            currPcEntryRow.set(setValuePcFieldKey, invRealBalFieldValue);
            if (!"lotnum".equals(invRealBalanceFieldKey)) continue;
            MobInvQueryHelper.setLotValue(plugin, pcEntityFromCache, invRealBalance, currPcEntryRow, pcEntryKey, pcFieldKey);
        }
        boolean updateZeroToQty2nd = MobInvQueryHelper.isUpdateZeroToQty2nd(currPcEntryRow, invQueryFieldMappingRelations);
        MobInvQueryHelper.setBillQtyByDirFromQty(currPcEntryRow, qtyMap, invQtyMap, updateZeroToQty2nd, "qty", "qty2nd");
        MobInvQueryHelper.setBillQtyByDirFromQty(currPcEntryRow, avbQtyMap, invQtyMap, updateZeroToQty2nd, "avbqty", "avbqty2nd");
    }

    private static boolean isDrawByBOTP(DynamicObject bill, String entryKey, String pcEntityKey) {
        MainEntityType dataEntityType;
        IDataEntityProperty dataEntityProperty;
        if (entryKey == null || StringUtils.isBlank((CharSequence)entryKey)) {
            return false;
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryKey);
        if (entrys == null || entrys.size() == 0) {
            return false;
        }
        LinkSetElement linkSet = ConvertMetaServiceHelper.loadLinkSet((String)pcEntityKey);
        if (linkSet == null || linkSet.getItems() == null || linkSet.getItems().isEmpty()) {
            return false;
        }
        String linkEntityKey = MobInvQueryHelper.getEntryLinkEntityKey(entryKey, pcEntityKey);
        List items = linkSet.getItems();
        for (LinkSetItemElement item : items) {
            if (!entryKey.equals(item.getParentEntityKey())) continue;
            linkEntityKey = item.getLinkEntityKey();
            break;
        }
        if ((dataEntityProperty = (dataEntityType = (MainEntityType)bill.getDataEntityType()).findProperty(linkEntityKey)) == null) {
            return false;
        }
        for (DynamicObject entry : entrys) {
            DynamicObjectCollection linkColl = entry.getDynamicObjectCollection(linkEntityKey);
            if (linkColl == null || linkColl.size() <= 0) continue;
            return true;
        }
        return false;
    }

    private static String getEntryLinkEntityKey(String entryKey, String pcEntityKey) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)pcEntityKey);
        Map allEntities = mainType.getAllEntities();
        for (EntityType entity : allEntities.values()) {
            if (!(entity instanceof LinkEntryType) || !entryKey.equals(entity.getParent().getName())) continue;
            return entity.getName();
        }
        return "";
    }

    private static boolean noInvScheme(String formId) {
        return "im_initbill".equalsIgnoreCase(formId) || "im_locationtransfer".equalsIgnoreCase(formId);
    }

    private static void setFieldValueOfPc(DynamicObject currPcEntryRow, String pcFieldKey, Object pcFieldValue, String invRealBalFieldKey) {
        if (invRealBalFieldKey == null || NOT_UPDATE_FIELDKEYS.contains(invRealBalFieldKey)) {
            currPcEntryRow.set(pcFieldKey, pcFieldValue);
        }
    }

    private static void setBillQtyByDirFromQty(DynamicObject currPcEntryRow, Map<String, BigDecimal> qtyMap, Map<String, String> invQtyMap, boolean updateZeroToQty2nd, String qtyKey, String qty2ndKey) {
        MobInvQueryHelper.setBillQty(currPcEntryRow, qtyMap, invQtyMap, qtyKey);
        String qty2ndKeyOfPc = invQtyMap.get(qty2ndKey);
        if (qty2ndKeyOfPc == null) {
            return;
        }
        if (updateZeroToQty2nd) {
            MobInvQueryHelper.setFieldValueOfPc(currPcEntryRow, qty2ndKeyOfPc, BigDecimal.ZERO, qty2ndKey);
        } else if (qty2ndKeyOfPc != null) {
            BigDecimal avbqty2ndValue = qtyMap.get(qty2ndKeyOfPc).compareTo(BigDecimal.ZERO) < 0 ? BigDecimal.ZERO : qtyMap.get(qty2ndKeyOfPc);
            MobInvQueryHelper.setFieldValueOfPc(currPcEntryRow, qty2ndKeyOfPc, avbqty2ndValue, qty2ndKey);
        }
    }

    protected static final DynamicObject getCurrEntryRow(MobBizBillInfoTplPlugin plugin, DynamicObject pcEntityFromCache, String mobEntryKey) {
        int currEntryRowIndex = Integer.parseInt(plugin.getPageCache().get("currEntryRowIndexOfInvQuery"));
        String pcEntryKey = plugin.getPageCache().get(mobEntryKey);
        DynamicObjectCollection entryRowColl = pcEntityFromCache.getDynamicObjectCollection(pcEntryKey);
        if (entryRowColl == null || entryRowColl.isEmpty()) {
            return null;
        }
        return (DynamicObject)entryRowColl.get(currEntryRowIndex);
    }

    protected static final void updateQtyInfoOfInvRealBalance(DynamicObject invRealBalance) {
        QFilter qFilter = new QFilter("id", "=", invRealBalance.getPkValue());
        DataSet invaccAvbBaseqty = ReserveHelper.getInvaccAvbbaseqty((QFilter[])qFilter.toArray());
        while (invaccAvbBaseqty.hasNext()) {
            Row row = invaccAvbBaseqty.next();
            Object invRealBalanceIdFromReserve = row.get("id");
            Object invRealBalanceId = invRealBalance.getPkValue();
            if (!invRealBalanceId.equals(invRealBalanceIdFromReserve)) continue;
            invRealBalance.set("avbqty", row.get("avbbqty"));
            invRealBalance.set("avbbaseqty", row.get("avbbaseqty"));
            invRealBalance.set("avbqty2nd", row.get("avbbtndqty"));
            invRealBalance.set("lockqty", row.get("reserveqty"));
            invRealBalance.set("lockbaseqty", row.get("reservebaseqty"));
            invRealBalance.set("lockqty2nd", row.get("reserveunit2ndqty"));
            break;
        }
    }

    private static boolean isUpdateZeroToQty2nd(DynamicObject currPcEntryRow, List<InvQueryFieldMappingRelation> invQueryFieldMappingRelations) {
        ArrayList<InvQueryFieldMappingRelation> matchFieldMappings = new ArrayList<InvQueryFieldMappingRelation>(10);
        ArrayList<InvQueryFieldMappingRelation> updateFieldMappings = new ArrayList<InvQueryFieldMappingRelation>(10);
        ArrayList<InvQueryFieldMappingRelation> updateOrMatchFieldMappings = new ArrayList<InvQueryFieldMappingRelation>(10);
        for (InvQueryFieldMappingRelation fieldMappingRelation : invQueryFieldMappingRelations) {
            Boolean isUpdate = fieldMappingRelation.getUpdate();
            Boolean isMatch = fieldMappingRelation.getMatch();
            if (isUpdate.booleanValue()) {
                updateFieldMappings.add(fieldMappingRelation);
            }
            if (!isMatch.booleanValue()) continue;
            matchFieldMappings.add(fieldMappingRelation);
        }
        updateOrMatchFieldMappings.addAll(updateFieldMappings);
        updateOrMatchFieldMappings.addAll(matchFieldMappings);
        Map<String, String> qtyKeyMap = MobInvQueryHelper.getBillQtyAndQty2ndKey(updateOrMatchFieldMappings);
        boolean updateQty2nd = false;
        String qtyUnit2ndKey = qtyKeyMap.get("qtyunit2nd");
        String qtyKey = qtyKeyMap.get("qty");
        if (StringUtils.isNotBlank((CharSequence)qtyUnit2ndKey) && StringUtils.isNotBlank((CharSequence)qtyKey)) {
            BigDecimal pageQty2nd = currPcEntryRow.getBigDecimal(qtyUnit2ndKey);
            BigDecimal pageQty = currPcEntryRow.getBigDecimal(qtyKey);
            updateQty2nd = pageQty != null && pageQty.compareTo(BigDecimal.ZERO) != 0 && (pageQty2nd == null || pageQty2nd.compareTo(BigDecimal.ZERO) == 0);
        }
        return updateQty2nd;
    }

    private static Map<String, String> getBillQtyAndQty2ndKey(List<InvQueryFieldMappingRelation> updateOrMatchFieldMappings) {
        HashMap<String, String> keyMap = new HashMap<String, String>(16);
        for (InvQueryFieldMappingRelation fieldMappingRelation : updateOrMatchFieldMappings) {
            String pcFieldKey = fieldMappingRelation.getPcFieldKey();
            String realBalFieldKey = fieldMappingRelation.getRealBalFieldKey();
            pcFieldKey = MobInvQueryHelper.getPcFieldKeyOfSettingValue(pcFieldKey);
            if ("avbqty".equals(realBalFieldKey) || "qty".equals(realBalFieldKey)) {
                keyMap.put("qty", pcFieldKey);
            }
            if (!"avbqty2nd".equals(realBalFieldKey) && !"qty2nd".equals(realBalFieldKey)) continue;
            keyMap.put("qtyunit2nd", pcFieldKey);
        }
        return keyMap;
    }

    protected static final String getPcFieldKeyOfSettingValue(String pcFieldKey) {
        int index;
        int n = index = StringUtils.isEmpty((CharSequence)pcFieldKey) ? -1 : pcFieldKey.lastIndexOf(46);
        if (index != -1) {
            pcFieldKey = pcFieldKey.substring(index + 1);
        }
        return pcFieldKey;
    }

    private static void setBillQty(DynamicObject currPcEntryRow, Map<String, BigDecimal> qtyMap, Map<String, String> invQtyMap, String invRealBalQtyKey) {
        String pcFieldKey = invQtyMap.get(invRealBalQtyKey);
        if (pcFieldKey != null) {
            BigDecimal qtyValue = qtyMap.get(invQtyMap.get(invRealBalQtyKey));
            currPcEntryRow.set(pcFieldKey, (Object)qtyValue);
        }
    }

    protected static void setLotValue(MobBizBillInfoTplPlugin plugin, DynamicObject pcEntityFromCache, DynamicObject invRealBalance, DynamicObject currPcEntryRow, String pcEntryKey, String pcEntryFieldKey) {
        Long lotMainFileId;
        Boolean isUseLotMf = (Boolean)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"isUseLotMainFile", (Object[])new Object[0]);
        if (isUseLotMf.booleanValue() && (lotMainFileId = MobInvQueryHelper.getLotMainFileId(plugin, invRealBalance)) != null) {
            MobInvQueryHelper.setLotValue(plugin, currPcEntryRow, pcEntityFromCache, pcEntryKey, pcEntryFieldKey, lotMainFileId);
        }
    }

    private static Long getLotMainFileId(MobBizBillInfoTplPlugin plugin, DynamicObject invRealBalance) {
        Long lotId;
        HashMap<Long, Long> realBalanceTolot = new HashMap<Long, Long>(16);
        RowMeta billentryRowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("matPK", (DataType)DataType.LongType), new Field("orgId", (DataType)DataType.LongType), new Field("lotnum", (DataType)DataType.StringType)});
        DataSetBuilder billentryDsBuilder = Algo.create((String)plugin.getClass().getName()).createDataSetBuilder(billentryRowMeta);
        Object orgId = invRealBalance.getDynamicObject("org").getPkValue();
        Object matPK = invRealBalance.getDynamicObject("material").getPkValue();
        Object invRealBalanceId = invRealBalance.getPkValue();
        String lotnum = invRealBalance.getString("lotnum");
        billentryDsBuilder.append(new Object[]{invRealBalanceId, matPK, orgId, lotnum});
        DataSet billentryDataSet = billentryDsBuilder.build();
        DataSet lotMainFileDataSet = QueryServiceHelper.queryDataSet((String)plugin.getClass().getName(), (String)"bd_lot", (String)"id as mainfileid,number as mflotnumber, material as mfmaterialid,createorg as mfinvorg", (QFilter[])new QFilter("number", "=", (Object)lotnum).toArray(), (String)"");
        JoinDataSet tempDataSet = billentryDataSet.leftJoin(lotMainFileDataSet).on("lotnum", "mflotnumber");
        Integer unqCtrl = (Integer)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getUnqctrl", (Object[])new Object[0]);
        if (unqCtrl == 2 || unqCtrl == 4) {
            tempDataSet.on("matPK", "mfmaterialid");
        }
        if (unqCtrl == 3 || unqCtrl == 4) {
            tempDataSet.on("orgId", "mfinvorg");
        }
        DataSet billLotRelWithMatDataSet = tempDataSet.select(billentryDataSet.getRowMeta().getFieldNames(), lotMainFileDataSet.getRowMeta().getFieldNames()).finish();
        while (billLotRelWithMatDataSet.hasNext()) {
            Row row = billLotRelWithMatDataSet.next();
            Long realBalanceId = row.getLong("id");
            lotId = row.getLong("mainfileid");
            realBalanceTolot.put(realBalanceId, lotId);
        }
        long realBalanceId = invRealBalance.getLong("id");
        lotId = (Long)realBalanceTolot.get(realBalanceId);
        return lotId;
    }

    private static void setLotValue(MobBizBillInfoTplPlugin plugin, DynamicObject currPcEntryRow, DynamicObject pcEntityCache, String pcEntryKey, String pcEntryFieldKey, Long lotMainFileId) {
        String pcEntityKey = plugin.getPcEntityKey();
        Set cfgDynamicObject = (Set)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"LotMainFileService", (String)"getLotMainFileBillConfigByBillAndLotNum", (Object[])new Object[]{pcEntityKey, pcEntryKey, pcEntityCache, pcEntryFieldKey});
        if (cfgDynamicObject == null || cfgDynamicObject.size() == 0) {
            return;
        }
        ArrayList listCfgDynamicObject = new ArrayList(cfgDynamicObject);
        String entryLotKey = ((DynamicObject)listCfgDynamicObject.get(0)).getString("lotidfield");
        if (entryLotKey.indexOf(46) != -1) {
            String[] keys = entryLotKey.split("\\.");
            entryLotKey = keys[keys.length - 1];
        }
        currPcEntryRow.set(entryLotKey + "_id", (Object)lotMainFileId);
    }

    protected static final void setLineType(DynamicObject currPcEntryRow) {
        DynamicProperty lineTypeProp = currPcEntryRow.getDynamicObjectType().getProperty("linetype");
        if (lineTypeProp == null) {
            return;
        }
        QFilter filter = new QFilter("number", "=", (Object)"010");
        DynamicObject lineType = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_linetype", (QFilter[])filter.toArray());
        currPcEntryRow.set("linetype", (Object)lineType);
    }

    protected static boolean isMatchAll(DynamicObject currPcEntryRow, DynamicObject invRealBalance, List<InvQueryFieldMappingRelation> invQueryFieldMappingRelations) {
        boolean isEmpty = MobInvQueryHelper.isEmpty(currPcEntryRow, invQueryFieldMappingRelations);
        if (isEmpty) {
            return true;
        }
        for (InvQueryFieldMappingRelation fieldMappingRelation : invQueryFieldMappingRelations) {
            boolean match;
            boolean isEmptyRealBalFieldValue;
            Boolean isMatch = fieldMappingRelation.getMatch();
            if (!isMatch.booleanValue()) continue;
            String pcFieldKey = fieldMappingRelation.getPcFieldKey();
            String realBalFieldKey = fieldMappingRelation.getRealBalFieldKey();
            String setValueFieldKey = MobInvQueryHelper.getPcFieldKeyOfSettingValue(pcFieldKey);
            DynamicProperty property = currPcEntryRow.getDynamicObjectType().getProperty(setValueFieldKey);
            if (property == null) continue;
            Object entryFieldValue = currPcEntryRow.get(setValueFieldKey);
            Object realBalFieldValue = invRealBalance.get(realBalFieldKey);
            boolean isEmptyBillFieldValue = entryFieldValue == null || "".equals(entryFieldValue);
            boolean bl = isEmptyRealBalFieldValue = realBalFieldValue == null || "".equals(realBalFieldValue);
            if (isEmptyBillFieldValue) {
                match = true;
            } else {
                if (isEmptyRealBalFieldValue) {
                    return false;
                }
                match = MobInvQueryHelper.isMatchNotNull(entryFieldValue, realBalFieldValue);
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(DynamicObject currPcEntryRow, List<InvQueryFieldMappingRelation> invQueryFieldMappingRelations) {
        for (InvQueryFieldMappingRelation fieldMappingRelation : invQueryFieldMappingRelations) {
            Boolean isMatch = fieldMappingRelation.getMatch();
            if (!isMatch.booleanValue()) continue;
            String pcFieldKey = fieldMappingRelation.getPcFieldKey();
            String realBalFieldKey = fieldMappingRelation.getRealBalFieldKey();
            String setValueFieldKey = MobInvQueryHelper.getPcFieldKeyOfSettingValue(pcFieldKey);
            DynamicProperty property = currPcEntryRow.getDynamicObjectType().getProperty(setValueFieldKey);
            if (property == null) continue;
            Object entryFieldValue = currPcEntryRow.get(setValueFieldKey);
            if (pcFieldKey != null && "material".equals(realBalFieldKey) && entryFieldValue == null) {
                return true;
            }
            if (!"material".equals(realBalFieldKey)) continue;
            break;
        }
        return false;
    }

    private static boolean isMatchNotNull(Object entryFieldValue, Object realBalFieldValue) {
        if (entryFieldValue instanceof DynamicObject) {
            IDataEntityProperty masterIdProp = ((RefEntityType)((DynamicObject)entryFieldValue).getDynamicObjectType()).findProperty("masterid");
            if (masterIdProp instanceof BasedataProp) {
                entryFieldValue = ((DynamicObject)entryFieldValue).get("masterid");
            }
            return ((DynamicObject)entryFieldValue).getPkValue().equals(((DynamicObject)realBalFieldValue).getPkValue());
        }
        if (entryFieldValue instanceof Object[]) {
            Object[] entryFieldValueArr = (Object[])entryFieldValue;
            Object[] realBalFieldValueArr = (Object[])realBalFieldValue;
            return Arrays.deepEquals(entryFieldValueArr, realBalFieldValueArr);
        }
        return entryFieldValue.equals(realBalFieldValue);
    }

    protected static final DynamicObject getMaterialInvInfo(DynamicObject material, Long orgId, String orgNumber, String pcFieldKey, DynamicObject pcEntity) {
        Long materialId = material.getLong("id");
        String materialNumber = material.getString("number");
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)orgId);
        QFilter masterFilter = new QFilter("masterid", "=", (Object)materialId);
        baseDataFilter.and(masterFilter);
        MainEntityType pcMainEntityType = (MainEntityType)pcEntity.getDynamicObjectType();
        BasedataProp basedataProp = (BasedataProp)pcMainEntityType.findProperty(pcFieldKey);
        Map invMaterial = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)((DynamicObjectType)basedataProp.getComplexType((Object)pcEntity)), (QFilter[])baseDataFilter.toArray());
        if (invMaterial == null || invMaterial.size() == 0) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u901a\u8fc7\u7f16\u7801\u4e3a\u3010%1$s\u3011\u7684\u7269\u6599\u548c\u7f16\u7801\u4e3a\u3010%2$s\u3011\u7684\u5e93\u5b58\u7ec4\u7ec7\u5339\u914d\u5230\u7684\u5e93\u5b58\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MobInvQueryHelper_getMaterialInvInfo_0", (String)"scmc-mobim-form", (Object[])new Object[0]), materialNumber, orgNumber);
            throw new KDBizException(errMsg);
        }
        ArrayList invMaterials = new ArrayList(invMaterial.values());
        return (DynamicObject)invMaterials.get(0);
    }

    private static class MapFieldComparator
    implements Comparator<Map<String, Object>> {
        private MapFieldComparator() {
        }

        @Override
        public int compare(Map<String, Object> field1, Map<String, Object> field2) {
            int order2;
            int order1 = (Integer)field1.get("returnorder");
            if (order1 != (order2 = ((Integer)field2.get("returnorder")).intValue())) {
                return order2 - order1;
            }
            return (Integer)field1.get("row") - (Integer)field2.get("row");
        }
    }
}

