/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scmc.im.business.helper.NewInvOrgHelper;

public class PermissionHelper {
    private static Log log = LogFactory.getLog(PermissionHelper.class);
    private static final String INV_APP_ID = "=9Q86DR2P+Q";

    public static boolean checkPermission(Long userId, Long orgId, String appId, String entityNum, String permItemId) {
        log.info("\u8c03\u7528PermissionServiceHelper\u65b9\u6cd5\u3010checkPermission\u3011\u4f20\u5165\u53c2\u6570userId\u3010{}\u3011\uff0corgId\u3010{}\u3011\uff0cappId\u3010{}\u3011\uff0centityNum\u3010{}\u3011\uff0cpermItemId\u3010{}\u3011", new Object[]{userId, orgId, appId, entityNum, permItemId});
        int hasPermResult = PermissionServiceHelper.checkPermission((Long)userId, (Long)orgId, (String)"15", (String)appId, (String)entityNum, (String)permItemId);
        log.info("\u8c03\u7528PermissionServiceHelper\u65b9\u6cd5\u3010checkPermission\u3011hasPermResult\u3010{}\u3011", (Object)hasPermResult);
        return hasPermResult == 1;
    }

    public static Object[] getPermissionAndStartedOrgs(String formId) {
        if (!PermissionHelper.checkInvOrgPermOfUser(formId)) {
            return new Object[0];
        }
        Object[] orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formId);
        return orgIdList == null || orgIdList.length == 0 ? new Object[]{} : orgIdList;
    }

    public static void doBillPermission(MobileFormShowParameter showParameter, String formid) {
        Object[] orgIdList = PermissionHelper.getPermissionAndStartedOrgs(formid);
        showParameter.getCustomParams().put("HasPermissionAndStartedInvOrg", SerializationUtils.toJsonString((Object)orgIdList));
    }

    public static boolean checkInvOrgPermOfUser(String formId) {
        List permissionOrgs = NewInvOrgHelper.getPermissionOrgs((String)formId);
        return permissionOrgs != null && !permissionOrgs.isEmpty();
    }

    public static List<Long> getAllPermOrgsFromUser(Long userId, String entityNum) {
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"15", (String)INV_APP_ID, (String)entityNum, (String)"47150e89000000ac");
        if (allPermOrgs.hasAllOrgPerm() && allPermOrgs.getHasPermOrgs().isEmpty()) {
            return null;
        }
        return allPermOrgs.getHasPermOrgs();
    }
}

