/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.ErrorCode;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.scmc.im.business.helper.NewInvOrgHelper;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.mobim.business.helper.PermissionHelper;
import kd.scmc.mobim.common.consts.InvStatusConst;
import kd.scmc.msmob.common.utils.CommonUtils;

public class QFilterHelper {
    private static final Long INVTYPE_ORDINARY = 688884005529250816L;
    private static final String IDENT_EQ_KEY = "1";
    private static final Integer IDENT_EQ_VAL = 1;

    public static QFilter buildFilterByParams(Map<String, Map<String, String>> filterParams, String filterFieldKey, String queryField) {
        QFilter qFilter = null;
        if (filterParams == null || filterParams.size() == 0) {
            return qFilter;
        }
        Map<String, String> filterInfo = filterParams.get(filterFieldKey);
        if (filterInfo == null || filterInfo.size() == 0) {
            return qFilter;
        }
        String dataType = filterInfo.get("datatype");
        String value = filterInfo.get("value");
        if (StringUtils.isEmpty((CharSequence)value)) {
            return qFilter;
        }
        if ("text".equals(dataType)) {
            if (value.contains(",")) {
                String[] txtValueArr = value.split(",");
                qFilter = new QFilter(queryField, "in", (Object)txtValueArr);
            } else {
                String txtValue = value.replaceAll(" ", "");
                if (txtValue.length() > 0) {
                    qFilter = new QFilter(queryField, "=", (Object)value);
                }
            }
        } else if ("basedata".equals(dataType)) {
            long id = Long.parseLong(value);
            qFilter = new QFilter(queryField, "=", (Object)id);
        } else if ("multibasedata".equals(dataType)) {
            String[] ids = value.split(",");
            ArrayList<Long> idList = new ArrayList<Long>(10);
            for (String id : ids) {
                idList.add(Long.valueOf(id));
            }
            qFilter = new QFilter(queryField, "in", idList);
        } else if ("qty".equals(dataType)) {
            BigDecimal qty = new BigDecimal(value);
            qFilter = new QFilter(queryField, "=", (Object)qty);
        }
        return qFilter;
    }

    public static QFilter buildMultiSelectFilter(IDataModel model, String filterFieldKey, String queryField) {
        DynamicObjectCollection multiSelBaseDatas = (DynamicObjectCollection)model.getValue(filterFieldKey);
        if (multiSelBaseDatas == null) {
            return null;
        }
        int multiBDSize = multiSelBaseDatas.size();
        QFilter multiSelBDFilter = null;
        if (multiBDSize == 1) {
            long baseDataId = ((DynamicObject)multiSelBaseDatas.get(0)).getDynamicObject(1).getLong("id");
            multiSelBDFilter = new QFilter(queryField, "=", (Object)baseDataId);
        } else if (multiBDSize > 1) {
            ArrayList<Long> multiSelBDIds = new ArrayList<Long>(10);
            for (DynamicObject baseDataDy : multiSelBaseDatas) {
                long baseDataId = baseDataDy.getDynamicObject(1).getLong("id");
                multiSelBDIds.add(baseDataId);
            }
            multiSelBDFilter = new QFilter(queryField, "in", multiSelBDIds);
        }
        return multiSelBDFilter;
    }

    public static QFilter buildTextFilter(IDataModel model, String separator, String filterFieldKey, String queryField) {
        String txtValue = (String)model.getValue(filterFieldKey);
        if (StringUtils.isEmpty((CharSequence)txtValue)) {
            return null;
        }
        String txtValueTmp = txtValue.replaceAll(" ", "");
        if (txtValueTmp.length() == 0) {
            return null;
        }
        String[] txtValueArr = txtValue.split(separator);
        return new QFilter(queryField, "in", (Object)txtValueArr);
    }

    public static QFilter getDefInvQueryFilter(IFormView view, String formId, String orgField, String invStatusField, String invTypeField) {
        boolean checkResult = PermissionHelper.checkInvOrgPermOfUser(formId);
        if (!checkResult) {
            view.showErrorNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_USE_INVORG()));
            return QFilterHelper.getIdentNotEqFilter();
        }
        Long defInvQueryOrgId = QFilterHelper.getDefInvQueryOrgId(view, formId);
        if (defInvQueryOrgId == null) {
            view.showErrorNotification(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getNO_ENABLED_INV()));
            return QFilterHelper.getIdentNotEqFilter();
        }
        QFilter qFilter = new QFilter(orgField, "=", (Object)defInvQueryOrgId);
        qFilter.and(invStatusField, "=", (Object)InvStatusConst.INVSTATUS_AVAILABLE);
        qFilter.and(invTypeField, "=", (Object)INVTYPE_ORDINARY);
        return qFilter;
    }

    public static Long getDefInvQueryOrgId(IFormView view, String formId) {
        Object[] orgIdList;
        FormShowParameter showParameter = view.getFormShowParameter();
        Map customParams = showParameter.getCustomParams();
        Long orgId = 0L;
        Object org = customParams.get("orgid");
        if (org != null) {
            orgId = Long.parseLong(org.toString());
        }
        if ((orgIdList = NewInvOrgHelper.getHasPermissionAndStartedInvOrgIds((String)formId)) == null || orgIdList.length == 0) {
            return null;
        }
        ArrayList<Long> invPermOrgIdList = new ArrayList<Long>(10);
        for (Object invPermOrg : orgIdList) {
            invPermOrgIdList.add(Long.valueOf(invPermOrg.toString()));
        }
        if (!invPermOrgIdList.contains(orgId)) {
            orgId = (Long)invPermOrgIdList.get(0);
        }
        return orgId;
    }

    public static QFilter getIdentEqFilter() {
        return QFilterHelper.getDefaultFilter("=");
    }

    public static QFilter getIdentNotEqFilter() {
        return QFilterHelper.getDefaultFilter("!=");
    }

    public static QFilter getDefaultFilter(String operatorKey) {
        return new QFilter(IDENT_EQ_KEY, operatorKey, (Object)IDENT_EQ_VAL);
    }
}

