/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.math.BigDecimal;
import java.math.BigInteger;
import kd.bd.sbd.consts.BizTypeConsts;
import kd.bd.sbd.enums.UnitConvertDirEnum;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.business.helper.BillUnitAndQtytHelper;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.enums.PrecisionAccountEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.mobim.common.utils.MetaUtils;
import org.apache.commons.lang3.StringUtils;

public class QtyAndUnitHelper {
    private static final Log log = LogFactory.getLog(QtyAndUnitHelper.class);
    private DynamicObject bill;
    private String mainEntryKey;

    public QtyAndUnitHelper(DynamicObject bill, String mainEntryKey) {
        if (bill == null || StringUtils.isEmpty((CharSequence)mainEntryKey)) {
            String errorMsg = ResManager.loadKDString((String)"QtyAndUnitHelper\u6784\u9020\u5668\u7684\u5165\u53c2\u3010bill\u3011\u548c\u3010mainEntryKey\u3011\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxAlgorithmHelper_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        this.bill = bill;
        this.mainEntryKey = mainEntryKey;
    }

    private void setValue(String entryKey, String fieldKey, Object value, int entryRow) {
        DynamicObjectCollection entryColl = this.bill.getDynamicObjectCollection(entryKey);
        if (entryColl == null || entryColl.size() == 0) {
            return;
        }
        DynamicObject row = (DynamicObject)entryColl.get(entryRow);
        row.set(fieldKey, value);
    }

    private Object getValue(String fieldKey) {
        return this.bill.get(fieldKey);
    }

    private Object getValue(String entryKey, String fieldKey, int entryRow) {
        DynamicObjectCollection entryColl = this.bill.getDynamicObjectCollection(entryKey);
        if (entryColl == null || entryColl.size() == 0) {
            return null;
        }
        DynamicObject row = (DynamicObject)entryColl.get(entryRow);
        return row.get(fieldKey);
    }

    public void calcByQtyUnit2nd(int rowIndex) {
        DynamicObject materialInvInfo = (DynamicObject)this.getValue(this.mainEntryKey, "material", rowIndex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        boolean isConvert = this.isConvertByUnit2nd(material);
        if (!isConvert) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)this.getValue(this.mainEntryKey, "baseunit", rowIndex);
        if (baseUnit == null) {
            return;
        }
        DynamicObject unit2nd = (DynamicObject)this.getValue(this.mainEntryKey, "unit2nd", rowIndex);
        if (unit2nd == null) {
            return;
        }
        BigDecimal qtyUnit2nd = (BigDecimal)this.getValue(this.mainEntryKey, "qtyunit2nd", rowIndex);
        BigDecimal baseQty = this.getDestQtyBySrcQty(material, unit2nd, baseUnit, qtyUnit2nd);
        if (baseQty == null) {
            baseQty = BigDecimal.ZERO;
        }
        baseQty = this.dealWithPrecision("baseunit", rowIndex, baseQty);
        this.showBigDecimalErrorTip("baseqty", baseQty);
        this.setValue(this.mainEntryKey, "baseqty", baseQty, rowIndex);
        this.setQtyByBaseQtyChange(rowIndex, material, baseUnit, baseQty);
    }

    private void setQtyByBaseQtyChange(int rowIndex, DynamicObject material, DynamicObject baseUnit, BigDecimal baseQty) {
        BigDecimal qty = BigDecimal.ZERO;
        if (baseQty.compareTo(BigDecimal.ZERO) != 0) {
            DynamicObject unit = (DynamicObject)this.getValue(this.mainEntryKey, "unit", rowIndex);
            if (unit == null) {
                return;
            }
            if (baseUnit == null) {
                return;
            }
            qty = this.getDestQtyBySrcQty(material, baseUnit, unit, baseQty);
        }
        if ("im_transapply".equals(this.bill.getDataEntityType().getName()) || "im_materialreqbill".equals(this.bill.getDataEntityType().getName())) {
            this.showBigDecimalErrorTip("qty", qty);
            this.setValue(this.mainEntryKey, "qty", qty, rowIndex);
            this.setValue(this.mainEntryKey, "auditqty", qty, rowIndex);
        } else {
            this.showBigDecimalErrorTip("qty", qty);
            this.setValue(this.mainEntryKey, "qty", qty, rowIndex);
        }
    }

    public void calcQtyUnit2ndAndBaseQtyByQty(int rowIndex) {
        DynamicObject materialInvInfo = (DynamicObject)this.getValue(this.mainEntryKey, "material", rowIndex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)this.getValue(this.mainEntryKey, "baseunit", rowIndex);
        if (baseUnit == null) {
            return;
        }
        DynamicObject unit = (DynamicObject)this.getValue(this.mainEntryKey, "unit", rowIndex);
        if (unit == null) {
            return;
        }
        BigDecimal qty = (BigDecimal)this.getValue(this.mainEntryKey, "qty", rowIndex);
        BigDecimal baseQty = this.getDestQtyBySrcQty(material, unit, baseUnit, qty);
        if (baseQty == null) {
            baseQty = BigDecimal.ZERO;
        }
        this.showBigDecimalErrorTip("baseqty", baseQty);
        this.setValue(this.mainEntryKey, "baseqty", baseQty, rowIndex);
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            return;
        }
        boolean isConvert = this.isConvertByUnit(material);
        if (!isConvert) {
            return;
        }
        if (BigDecimal.ZERO.compareTo(baseQty) == 0) {
            this.setValue(this.mainEntryKey, "qtyunit2nd", BigDecimal.ZERO, rowIndex);
            return;
        }
        BigDecimal qtyUnit2nd = this.getDestQtyBySrcQty(material, baseUnit, auxptyUnit, baseQty);
        if (qtyUnit2nd == null) {
            qtyUnit2nd = BigDecimal.ZERO;
        }
        this.showBigDecimalErrorTip("qtyunit2nd", qtyUnit2nd);
        this.setValue(this.mainEntryKey, "qtyunit2nd", qtyUnit2nd, rowIndex);
    }

    public void calcBaseQtyByQty(int rowIndex) {
        DynamicObject materialInvInfo = (DynamicObject)this.getValue(this.mainEntryKey, "material", rowIndex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        DynamicObject unit = (DynamicObject)this.getValue(this.mainEntryKey, "unit", rowIndex);
        if (unit == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)this.getValue(this.mainEntryKey, "baseunit", rowIndex);
        if (baseUnit == null) {
            return;
        }
        BigDecimal qty = (BigDecimal)this.getValue(this.mainEntryKey, "qty", rowIndex);
        BigDecimal baseQty = this.getDestQtyBySrcQty(material, unit, baseUnit, qty);
        if (baseQty == null) {
            baseQty = BigDecimal.ZERO;
        }
        this.showBigDecimalErrorTip("baseqty", baseQty);
        this.setValue(this.mainEntryKey, "baseqty", baseQty, rowIndex);
    }

    public void calcBaseQtyByQtyunit2nd(int rowIndex) {
        DynamicObject materialInvInfo = (DynamicObject)this.getValue(this.mainEntryKey, "material", rowIndex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        boolean isConvert = this.isConvertByUnit2nd(material);
        if (!isConvert) {
            return;
        }
        DynamicObject unit2nd = (DynamicObject)this.getValue(this.mainEntryKey, "unit2nd", rowIndex);
        if (unit2nd == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)this.getValue(this.mainEntryKey, "baseunit", rowIndex);
        if (baseUnit == null) {
            return;
        }
        BigDecimal qtyunit2nd = (BigDecimal)this.getValue(this.mainEntryKey, "qtyunit2nd", rowIndex);
        BigDecimal baseQty = this.getDestQtyBySrcQty(material, unit2nd, baseUnit, qtyunit2nd);
        if (baseQty == null) {
            baseQty = BigDecimal.ZERO;
        }
        this.showBigDecimalErrorTip("baseqty", baseQty);
        this.setValue(this.mainEntryKey, "baseqty", baseQty, rowIndex);
    }

    public boolean isConvertByUnit2nd(DynamicObject material) {
        String unitConvertDir = material.getString("unitconvertdir");
        return UnitConvertDirEnum.U2ND_UINV.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
    }

    public boolean isConvertByUnit(DynamicObject material) {
        String unitConvertDir = material.getString("unitconvertdir");
        return UnitConvertDirEnum.UINV_U2ND.getValue().equals(unitConvertDir) || UnitConvertDirEnum.UINVANDU2ND.getValue().equals(unitConvertDir);
    }

    public BigDecimal dealWithPrecision(String fieldName, int rowIndex, BigDecimal srcCount) {
        DynamicObject unit = rowIndex == -1 ? (DynamicObject)this.getValue(fieldName) : (DynamicObject)this.getValue(this.mainEntryKey, fieldName, rowIndex);
        if (unit == null) {
            return srcCount;
        }
        return srcCount.setScale(unit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)unit.getInt("precisionaccount")));
    }

    public void calcByQty(int rowIndex) {
        DynamicObject materialInvInfo = (DynamicObject)this.getValue(this.mainEntryKey, "material", rowIndex);
        if (materialInvInfo == null) {
            return;
        }
        DynamicObject material = materialInvInfo.getDynamicObject("masterid");
        if (material == null) {
            return;
        }
        DynamicObject baseUnit = (DynamicObject)this.getValue(this.mainEntryKey, "baseunit", rowIndex);
        if (baseUnit == null) {
            return;
        }
        DynamicObject unit = (DynamicObject)this.getValue(this.mainEntryKey, "unit", rowIndex);
        if (unit == null) {
            return;
        }
        DynamicObject auxptyUnit = material.getDynamicObject("auxptyunit");
        if (auxptyUnit == null) {
            return;
        }
        this.calcBaseQtyByQty(rowIndex);
        BigDecimal baseQty = (BigDecimal)this.getValue(this.mainEntryKey, "baseqty", rowIndex);
        boolean isConvert = this.isConvertByUnit(material);
        if (!isConvert) {
            return;
        }
        if (BigDecimal.ZERO.compareTo(baseQty) == 0) {
            this.setValue(this.mainEntryKey, "qtyunit2nd", BigDecimal.ZERO, rowIndex);
            return;
        }
        BigDecimal qtyUnit2nd = this.getDestQtyBySrcQty(material, baseUnit, auxptyUnit, baseQty);
        if (qtyUnit2nd == null) {
            qtyUnit2nd = BigDecimal.ZERO;
        }
        this.showBigDecimalErrorTip("qtyunit2nd", qtyUnit2nd);
        this.setValue(this.mainEntryKey, "qtyunit2nd", qtyUnit2nd, rowIndex);
    }

    private BigDecimal getDestQtyBySrcQty(DynamicObject material, DynamicObject srcUnit, DynamicObject destUnit, BigDecimal srcQty) {
        return BillUnitAndQtytHelper.getDesQtyConv((DynamicObject)material, (DynamicObject)srcUnit, (BigDecimal)srcQty, (DynamicObject)destUnit);
    }

    public void showBigDecimalErrorTip(String qtyKey, BigDecimal qty) {
        String displayName = null;
        String langName = RequestContext.get().getLang().name();
        if (MetaUtils.isExistFieldKey(this.bill, qtyKey)) {
            DynamicProperty property = this.bill.getDynamicObjectType().getProperty(qtyKey);
            displayName = (String)property.getDisplayName().get((Object)langName);
        } else if (MetaUtils.isExistEntryFieldKey(this.bill, this.mainEntryKey, qtyKey)) {
            DynamicObjectCollection billEntry = this.bill.getDynamicObjectCollection(this.mainEntryKey);
            if (billEntry == null || billEntry.size() == 0) {
                return;
            }
            DynamicProperty property = ((DynamicObject)billEntry.get(0)).getDynamicObjectType().getProperty(qtyKey);
            displayName = (String)property.getDisplayName().get((Object)langName);
        }
        if (displayName != null && qty.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_BY_DISPLAYNAME(displayName)));
        }
    }

    public void calcPurInEntryInfoByQty(int rowIndex) {
        String entityKey = this.bill.getDynamicObjectType().getName();
        if ("im_purinbill".equals(entityKey)) {
            BigDecimal qty = (BigDecimal)this.getValue(this.mainEntryKey, "qty", rowIndex);
            BigDecimal baseQty = (BigDecimal)this.getValue(this.mainEntryKey, "baseqty", rowIndex);
            this.setValue(this.mainEntryKey, "returnbaseqty", BigDecimal.ZERO, rowIndex);
            this.setValue(this.mainEntryKey, "returnqty", BigDecimal.ZERO, rowIndex);
            this.setValue(this.mainEntryKey, "remainreturnqty", qty, rowIndex);
            this.setValue(this.mainEntryKey, "remainreturnbaseqty", baseQty, rowIndex);
            this.setValue(this.mainEntryKey, "joinpriceqty", BigDecimal.ZERO, rowIndex);
            this.setValue(this.mainEntryKey, "remainjoinpriceqty", qty, rowIndex);
            this.setValue(this.mainEntryKey, "joinpricebaseqty", BigDecimal.ZERO, rowIndex);
            this.setValue(this.mainEntryKey, "remainjoinpricebaseqty", baseQty, rowIndex);
            this.setValue(this.mainEntryKey, "verifyqty", BigDecimal.ZERO, rowIndex);
            this.setValue(this.mainEntryKey, "unverifyqty", qty, rowIndex);
            this.setValue(this.mainEntryKey, "verifybaseqty", BigDecimal.ZERO, rowIndex);
            this.setValue(this.mainEntryKey, "unverifybaseqty", baseQty, rowIndex);
            DynamicObject bizType = (DynamicObject)this.getValue("biztype");
            if (BizTypeConsts.BIZTYPE_PURINRETURN_VMI.equals(bizType.getPkValue()) || BizTypeConsts.BIZTYPE_PURIN_VMI.equals(bizType.getPkValue())) {
                this.setValue(this.mainEntryKey, "vmisettleqty", BigDecimal.ZERO, rowIndex);
                this.setValue(this.mainEntryKey, "vmiremainsettleqty", qty, rowIndex);
                this.setValue(this.mainEntryKey, "vmisettlebaseqty", BigDecimal.ZERO, rowIndex);
                this.setValue(this.mainEntryKey, "vmiremainsettlebaseqty", baseQty, rowIndex);
            }
        }
    }

    public void calcPurRecEntryInfo(int rowIndex) {
        String entityKey = this.bill.getDynamicObjectType().getName();
        if ("im_purreceivebill".equals(entityKey)) {
            BigDecimal qty = (BigDecimal)this.getValue(this.mainEntryKey, "qty", rowIndex);
            BigDecimal qtyunit2nd = (BigDecimal)this.getValue(this.mainEntryKey, "qtyunit2nd", rowIndex);
            BigDecimal baseQty = (BigDecimal)this.getValue(this.mainEntryKey, "baseqty", rowIndex);
            this.setValue(this.mainEntryKey, "qualifiedqty", qty, rowIndex);
            this.setValue(this.mainEntryKey, "qualifiedbaseqty", baseQty, rowIndex);
            this.setValue(this.mainEntryKey, "qualifiedunit2nd", qtyunit2nd, rowIndex);
        }
    }

    public void calcSalOutEntryInfoByQty(int rowIndex) {
        String entityKey = this.bill.getDynamicObjectType().getName();
        if ("im_saloutbill".equals(entityKey)) {
            BigDecimal qty = (BigDecimal)this.getValue(this.mainEntryKey, "qty", rowIndex);
            BigDecimal baseQty = (BigDecimal)this.getValue(this.mainEntryKey, "baseqty", rowIndex);
            this.setValue(this.mainEntryKey, "returnbaseqty", BigDecimal.ZERO, rowIndex);
            this.setValue(this.mainEntryKey, "returnqty", BigDecimal.ZERO, rowIndex);
            this.setValue(this.mainEntryKey, "remainreturnqty", qty, rowIndex);
            this.setValue(this.mainEntryKey, "remainreturnbaseqty", baseQty, rowIndex);
            this.setValue(this.mainEntryKey, "joinpriceqty", BigDecimal.ZERO, rowIndex);
            this.setValue(this.mainEntryKey, "remainjoinpriceqty", qty, rowIndex);
            this.setValue(this.mainEntryKey, "joinpricebaseqty", BigDecimal.ZERO, rowIndex);
            this.setValue(this.mainEntryKey, "remainjoinpricebaseqty", baseQty, rowIndex);
            this.setValue(this.mainEntryKey, "verifyqty", BigDecimal.ZERO, rowIndex);
            this.setValue(this.mainEntryKey, "unverifyqty", qty, rowIndex);
            this.setValue(this.mainEntryKey, "verifybaseqty", BigDecimal.ZERO, rowIndex);
            this.setValue(this.mainEntryKey, "unverifybaseqty", baseQty, rowIndex);
            this.calcMaterialCost(null, rowIndex);
        }
    }

    public void calcMaterialCost(String changeKey, int rowIndex) {
        BigDecimal qty = (BigDecimal)this.getValue(this.mainEntryKey, "qty", rowIndex);
        if (qty == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)changeKey)) {
            BigDecimal baseMCost = (BigDecimal)this.getValue(this.mainEntryKey, "unitmaterialcost", rowIndex);
            baseMCost = baseMCost == null ? new BigDecimal(BigInteger.ZERO) : baseMCost;
            this.setValue(this.mainEntryKey, "materialcost", baseMCost.multiply(qty), rowIndex);
        } else {
            BigDecimal materialCost = (BigDecimal)this.getValue(this.mainEntryKey, "materialcost", rowIndex);
            int compareTo = new BigDecimal(BigInteger.ZERO).compareTo(qty);
            int pricePrecision = this.getPrecision("currency", "priceprecision");
            if (materialCost != null) {
                this.setValue(this.mainEntryKey, "unitmaterialcost", compareTo == 0 ? new BigDecimal(BigInteger.ZERO) : materialCost.divide(qty, pricePrecision, 4), rowIndex);
            }
        }
    }

    public int getPrecision(String currencyFieldKey, String pricePrecision) {
        int precision = 2;
        if ("priceprecision".equals(pricePrecision)) {
            return 10;
        }
        DynamicObject currency = (DynamicObject)this.getValue(currencyFieldKey);
        if (currency != null) {
            precision = currency.getInt(pricePrecision);
        }
        return precision;
    }
}

