/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class QtyAssociationPcHelper {
    public static void calAllamoutByQTYChange(DynamicObject pcEntityData, String pcEntryKey, String currencyf) {
        int precision = QtyAssociationPcHelper.getPrecision(pcEntityData, currencyf, "amtprecision");
        DynamicObjectCollection entryColl = pcEntityData.getDynamicObjectCollection(pcEntryKey);
        for (DynamicObject entryRow : entryColl) {
            QtyAssociationPcHelper.calAmonutByQtyChange(entryRow, precision);
        }
    }

    public static void calAmonutByQtyChange(DynamicObject entryRow, int precision) {
        BigDecimal qty = (BigDecimal)entryRow.get("qty");
        BigDecimal price = (BigDecimal)entryRow.get("price");
        BigDecimal amountAll = qty.multiply(price);
        QtyAssociationPcHelper.showAmountErrorTip(amountAll);
        BigDecimal amount = amountAll.setScale(precision, 4);
        entryRow.set("amount", (Object)amount);
    }

    public static int getPrecision(DynamicObject pcEntityData, String currencyf, String pref) {
        int precision = 2;
        DynamicObject currency = (DynamicObject)pcEntityData.get(currencyf);
        if (currency != null) {
            precision = currency.getInt(pref);
        }
        return precision;
    }

    public static void showAmountErrorTip(BigDecimal amount_all) {
        if (amount_all.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_AMOUNT()));
        }
    }
}

