/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.scmc.im.business.helper.InvBillHelper;
import kd.scmc.im.helper.ShelfLifeDateUtil;
import kd.scmc.mobim.common.utils.DateUtils;

public class ShowExpiryDateConfirmHelper {
    private IFormView view;
    private String pcBillName;

    public ShowExpiryDateConfirmHelper(IFormView view, String pcBillName) {
        this.view = view;
        this.pcBillName = pcBillName;
    }

    public void showExpiryDateConfirm(int rowIndex, DynamicObject material, Date oldExpiryDate, Date newExpiryDate, Date oldProduceDate, Date newProduceDate, DynamicObject changedEntry) {
        Date nowDate = new Date();
        String entryName = "billentry";
        Date overdueDate = this.getOverDueDate(material, newExpiryDate, entryName);
        boolean dateOver = nowDate.after(overdueDate);
        if (dateOver) {
            HashMap<String, Object> dateChangedConfirmMap = new HashMap<String, Object>(16);
            String newExpiryDateStr = DateUtils.getDateToString(newExpiryDate, false);
            String oldExpiryDateStr = DateUtils.getDateToString(oldExpiryDate, false);
            String newProduceDateStr = DateUtils.getDateToString(newProduceDate, false);
            String oldProduceDateStr = DateUtils.getDateToString(oldProduceDate, false);
            dateChangedConfirmMap.put("newProduceDate", newProduceDateStr);
            dateChangedConfirmMap.put("oldProduceDate", oldProduceDateStr);
            dateChangedConfirmMap.put("newExpiryDate", newExpiryDateStr);
            dateChangedConfirmMap.put("oldExpiryDate", oldExpiryDateStr);
            dateChangedConfirmMap.put("changedRowIndex", rowIndex);
            String msg = String.format(ResManager.loadKDString((String)"\u7b2c\u3010%1$s\u3011\u884c\u7684\u7269\u6599\u3010%2$s\u3011\u5230\u671f\u65e5\u671f\u4e3a\u3010%3$s\u3011\uff0c\u5373\u5c06\u8fc7\u671f\u6216\u8005\u5df2\u7ecf\u8fc7\u671f\uff0c\u662f\u5426\u5141\u8bb8\u5f55\u5165\uff1f", (String)"MobImBillEntryEditPlugin_2", (String)"scmc-mobim-form", (Object[])new Object[0]), rowIndex + 1, material.get("masterid.name"), newExpiryDateStr);
            this.view.showConfirm(msg, null, MessageBoxOptions.OKCancel, ConfirmTypes.Default, new ConfirmCallBackListener("materialLifeDate"), null, SerializationUtils.toJsonString(dateChangedConfirmMap));
        } else {
            changedEntry.set("producedate", (Object)newProduceDate);
            changedEntry.set("expirydate", (Object)newExpiryDate);
        }
    }

    private Date getOverDueDate(DynamicObject material, Date newExpiryDate, String entryName) {
        String leadTimeUnit = material.getString("leadtimeunit");
        int dateOfOverdueForIn = material.getInt("dateofoverdueforin");
        int dateOfOverdueForOut = material.getInt("dateofoverdueforout");
        int dateOfOverdue = 0;
        boolean isOutBill = InvBillHelper.isOutEntry((String)this.pcBillName, (String)entryName);
        boolean isInBill = InvBillHelper.isInEntry((String)this.pcBillName, (String)entryName);
        if (isOutBill && isInBill) {
            dateOfOverdue = dateOfOverdueForOut > dateOfOverdueForIn ? dateOfOverdueForOut : dateOfOverdueForIn;
        } else if (isOutBill) {
            dateOfOverdue = dateOfOverdueForOut;
        } else if (isInBill) {
            dateOfOverdue = dateOfOverdueForIn;
        }
        Date overdueDate = ShelfLifeDateUtil.getDateOfOverdue((String)leadTimeUnit, (int)dateOfOverdue, (Date)newExpiryDate);
        return overdueDate;
    }
}

