/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.scmc.mobim.business.helper.QFilterHelper;
import kd.scmc.mobim.common.utils.DateUtils;
import kd.scmc.mobim.common.utils.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class SieveFilterHelper {
    private static final Log log = LogFactory.getLog(SieveFilterHelper.class);

    public static String buildQFilter(DynamicObject sieveScheme) {
        QFilter baseQtyFilter;
        QFilter projectFilter;
        QFilter lotNumberFilter;
        QFilter invTypeFilter;
        QFilter invStatusFilter;
        QFilter locationFilter;
        QFilter warehouseFilter;
        QFilter qFilter = QFilterHelper.getIdentEqFilter();
        Map<String, Map<String, String>> filterParams = SieveFilterHelper.getFilterParams(sieveScheme, false);
        if (filterParams.size() == 0) {
            return qFilter.toString();
        }
        QFilter orgFilter = SieveFilterHelper.buildOrgFilter(filterParams);
        if (orgFilter != null) {
            qFilter.and(orgFilter);
        }
        if ((warehouseFilter = SieveFilterHelper.buildWarehouseFilter(filterParams)) != null) {
            qFilter.and(warehouseFilter);
        }
        if ((locationFilter = SieveFilterHelper.buildLocationFilter(filterParams)) != null) {
            qFilter.and(locationFilter);
        }
        QFilter ownerFilter = null;
        QFilter ownerTypeFilter = SieveFilterHelper.buildOwnerTypeFilter(filterParams);
        if (ownerTypeFilter != null) {
            qFilter.and(ownerTypeFilter);
            ownerFilter = SieveFilterHelper.buildOwnerFilter(filterParams);
        }
        if (ownerFilter != null) {
            qFilter.and(ownerFilter);
        }
        QFilter keeperFilter = null;
        QFilter keeperTypeFilter = SieveFilterHelper.buildKeeperTypeFilter(filterParams);
        if (keeperTypeFilter != null) {
            qFilter.and(keeperTypeFilter);
            keeperFilter = SieveFilterHelper.buildKeeperFilter(filterParams);
        }
        if (keeperFilter != null) {
            qFilter.and(keeperFilter);
        }
        if ((invStatusFilter = SieveFilterHelper.buildInvStatusFilter(filterParams)) != null) {
            qFilter.and(invStatusFilter);
        }
        if ((invTypeFilter = SieveFilterHelper.buildInvTypeFilter(filterParams)) != null) {
            qFilter.and(invTypeFilter);
        }
        if ((lotNumberFilter = SieveFilterHelper.buildLotNumberFilter(filterParams)) != null) {
            qFilter.and(lotNumberFilter);
        }
        if ((projectFilter = SieveFilterHelper.buildProjectFilter(filterParams)) != null) {
            qFilter.and(projectFilter);
        }
        if ((baseQtyFilter = SieveFilterHelper.buildBaseQtyFilter(filterParams)) != null) {
            qFilter.and(baseQtyFilter);
        }
        StringBuilder qFilterTmp = new StringBuilder(qFilter.toString());
        StringBuilder dateFilter = SieveFilterHelper.buildDateRangeFilter(filterParams);
        if (dateFilter != null) {
            qFilterTmp.append(" and ");
            qFilterTmp.append((CharSequence)dateFilter);
        }
        return qFilterTmp.toString();
    }

    public static String buildQFilter(IDataModel model) {
        QFilter baseQtyFilter;
        QFilter projectFilter;
        QFilter lotNumberFilter;
        QFilter invTypeFilter;
        QFilter invStatusFilter;
        QFilter locationFilter;
        QFilter warehouseFilter;
        QFilter qFilter = QFilterHelper.getIdentEqFilter();
        QFilter orgFilter = SieveFilterHelper.buildOrgFilter(model);
        if (orgFilter != null) {
            qFilter.and(orgFilter);
        }
        if ((warehouseFilter = SieveFilterHelper.buildWarehouseFilter(model)) != null) {
            qFilter.and(warehouseFilter);
        }
        if ((locationFilter = SieveFilterHelper.buildLocationFilter(model)) != null) {
            qFilter.and(locationFilter);
        }
        QFilter ownerFilter = null;
        QFilter ownerTypeFilter = SieveFilterHelper.buildOwnerTypeFilter(model);
        if (ownerTypeFilter != null) {
            qFilter.and(ownerTypeFilter);
            ownerFilter = SieveFilterHelper.buildOwnerFilter(model);
        }
        if (ownerFilter != null) {
            qFilter.and(ownerFilter);
        }
        QFilter keeperFilter = null;
        QFilter keeperTypeFilter = SieveFilterHelper.buildKeeperTypeFilter(model);
        if (keeperTypeFilter != null) {
            qFilter.and(keeperTypeFilter);
            keeperFilter = SieveFilterHelper.buildKeeperFilter(model);
        }
        if (keeperFilter != null) {
            qFilter.and(keeperFilter);
        }
        if ((invStatusFilter = SieveFilterHelper.buildInvStatusFilter(model)) != null) {
            qFilter.and(invStatusFilter);
        }
        if ((invTypeFilter = SieveFilterHelper.buildInvTypeFilter(model)) != null) {
            qFilter.and(invTypeFilter);
        }
        if ((lotNumberFilter = SieveFilterHelper.buildLotNumberFilter(model)) != null) {
            qFilter.and(lotNumberFilter);
        }
        if ((projectFilter = SieveFilterHelper.buildProjectFilter(model)) != null) {
            qFilter.and(projectFilter);
        }
        if ((baseQtyFilter = SieveFilterHelper.buildBaseQtyFilter(model)) != null) {
            qFilter.and(baseQtyFilter);
        }
        StringBuilder qFilterTmp = new StringBuilder(qFilter.toString());
        StringBuilder dateFilter = SieveFilterHelper.buildDateRangeFilter(model);
        if (dateFilter != null) {
            qFilterTmp.append(" and ");
            qFilterTmp.append((CharSequence)dateFilter);
        }
        return qFilterTmp.toString();
    }

    public static Map<String, Map<String, String>> getFilterParams(DynamicObject sieveScheme, boolean isGetUnKnown) {
        HashMap<String, Map<String, String>> filterParams = new HashMap<String, Map<String, String>>(16);
        if (sieveScheme == null) {
            return filterParams;
        }
        DynamicObjectCollection entryObjs = sieveScheme.getDynamicObjectCollection("entryentity");
        if (entryObjs == null || entryObjs.size() == 0) {
            return filterParams;
        }
        for (DynamicObject entryObj : entryObjs) {
            String fieldType = entryObj.getString("sievefieldtype");
            if (!isGetUnKnown && "unknown".equals(fieldType)) continue;
            HashMap<String, String> fieldMap = new HashMap<String, String>(16);
            String fieldKey = entryObj.getString("sievefieldkey");
            String fieldValue = entryObj.getString("sievefieldvalue_tag");
            fieldMap.put("datatype", fieldType);
            fieldMap.put("value", fieldValue);
            filterParams.put(fieldKey, fieldMap);
        }
        return filterParams;
    }

    public static QFilter buildProjectFilter(Map<String, Map<String, String>> filterParams) {
        return QFilterHelper.buildFilterByParams(filterParams, "project", "fprojectid");
    }

    public static QFilter buildProjectFilter(IDataModel model) {
        return QFilterHelper.buildMultiSelectFilter(model, "project", "fprojectid");
    }

    public static QFilter buildLotNumberFilter(Map<String, Map<String, String>> filterParams) {
        return QFilterHelper.buildFilterByParams(filterParams, "lotnumber", "flotnum");
    }

    public static QFilter buildLotNumberFilter(IDataModel model) {
        return QFilterHelper.buildTextFilter(model, ",", "lotnumber", "flotnum");
    }

    public static QFilter buildInvStatusFilter(Map<String, Map<String, String>> filterParams) {
        return QFilterHelper.buildFilterByParams(filterParams, "invstatus", "finvstatusid");
    }

    public static QFilter buildInvStatusFilter(IDataModel model) {
        return QFilterHelper.buildMultiSelectFilter(model, "invstatus", "finvstatusid");
    }

    public static QFilter buildInvTypeFilter(Map<String, Map<String, String>> filterParams) {
        return QFilterHelper.buildFilterByParams(filterParams, "invtype", "finvtypeid");
    }

    public static QFilter buildInvTypeFilter(IDataModel model) {
        return QFilterHelper.buildMultiSelectFilter(model, "invtype", "finvtypeid");
    }

    public static QFilter buildOwnerFilter(Map<String, Map<String, String>> filterParams) {
        return SieveFilterHelper.buildOwnerOrKeeperFilter(filterParams, "ownertype", "accountowner", "supplierowner", "customerowner", "fownerid");
    }

    public static QFilter buildOwnerFilter(IDataModel model) {
        return SieveFilterHelper.buildOwnerOrKeeperFilter(model, "ownertype", "accountowner", "supplierowner", "customerowner", "fownerid");
    }

    public static QFilter buildOwnerTypeFilter(Map<String, Map<String, String>> filterParams) {
        return QFilterHelper.buildFilterByParams(filterParams, "ownertype", "fownertype");
    }

    public static QFilter buildOwnerTypeFilter(IDataModel model) {
        return SieveFilterHelper.buildOwnerOrKeeperTypeFilter(model, "ownertype", "fownertype");
    }

    public static QFilter buildOwnerOrKeeperTypeFilter(IDataModel model, String ownerOrKeeperTypeKey, String queryField) {
        QFilter qFilter = null;
        String ownerOrKeeperType = (String)model.getValue(ownerOrKeeperTypeKey);
        if ("bos_org".equals(ownerOrKeeperType)) {
            qFilter = new QFilter(queryField, "=", (Object)"bos_org");
        } else if ("bd_supplier".equals(ownerOrKeeperType)) {
            qFilter = new QFilter(queryField, "=", (Object)"bd_supplier");
        } else if ("bd_customer".equals(ownerOrKeeperType)) {
            qFilter = new QFilter(queryField, "=", (Object)"bd_customer");
        }
        return qFilter;
    }

    public static QFilter buildKeeperTypeFilter(Map<String, Map<String, String>> filterParams) {
        return QFilterHelper.buildFilterByParams(filterParams, "keepertype", "fkeepertype");
    }

    public static QFilter buildKeeperTypeFilter(IDataModel model) {
        return SieveFilterHelper.buildOwnerOrKeeperTypeFilter(model, "keepertype", "fkeepertype");
    }

    public static QFilter buildKeeperFilter(Map<String, Map<String, String>> filterParams) {
        return SieveFilterHelper.buildOwnerOrKeeperFilter(filterParams, "keepertype", "invorgkeeper", "supplierkeeper", "customerkeeper", "fkeeperid");
    }

    public static QFilter buildKeeperFilter(IDataModel model) {
        return SieveFilterHelper.buildOwnerOrKeeperFilter(model, "keepertype", "invorgkeeper", "supplierkeeper", "customerkeeper", "fkeeperid");
    }

    private static QFilter buildOwnerOrKeeperFilter(Map<String, Map<String, String>> filterParams, String ownerOrKeeperTypeKey, String bosOrgTypeKey, String supplierTypeKey, String customerTypeKey, String queryField) {
        QFilter qFilter = null;
        if (MapUtils.isEmptyMap(filterParams)) {
            return qFilter;
        }
        Map<String, String> ownerOrKeeperTypeMap = filterParams.get(ownerOrKeeperTypeKey);
        if (MapUtils.isEmptyMap(ownerOrKeeperTypeMap)) {
            return qFilter;
        }
        String ownerOrKeeperType = ownerOrKeeperTypeMap.get("value");
        if (StringUtils.isEmpty((CharSequence)ownerOrKeeperType)) {
            return qFilter;
        }
        if ("bos_org".equals(ownerOrKeeperType)) {
            qFilter = QFilterHelper.buildFilterByParams(filterParams, bosOrgTypeKey, queryField);
        } else if ("bd_supplier".equals(ownerOrKeeperType)) {
            qFilter = QFilterHelper.buildFilterByParams(filterParams, supplierTypeKey, queryField);
        } else if ("bd_customer".equals(ownerOrKeeperType)) {
            qFilter = QFilterHelper.buildFilterByParams(filterParams, customerTypeKey, queryField);
        }
        return qFilter;
    }

    private static QFilter buildOwnerOrKeeperFilter(IDataModel model, String ownerOrKeeperTypeKey, String bosOrgTypeKey, String supplierTypeKey, String customerTypeKey, String queryField) {
        QFilter qFilter = null;
        String ownerOrKeeperType = (String)model.getValue(ownerOrKeeperTypeKey);
        if (StringUtils.isEmpty((CharSequence)ownerOrKeeperType)) {
            return qFilter;
        }
        if ("bos_org".equals(ownerOrKeeperType)) {
            qFilter = QFilterHelper.buildMultiSelectFilter(model, bosOrgTypeKey, queryField);
        } else if ("bd_supplier".equals(ownerOrKeeperType)) {
            qFilter = QFilterHelper.buildMultiSelectFilter(model, supplierTypeKey, queryField);
        } else if ("bd_customer".equals(ownerOrKeeperType)) {
            qFilter = QFilterHelper.buildMultiSelectFilter(model, customerTypeKey, queryField);
        }
        return qFilter;
    }

    public static QFilter buildOrgFilter(Map<String, Map<String, String>> filterParams) {
        return QFilterHelper.buildFilterByParams(filterParams, "org", "forgid");
    }

    public static QFilter buildOrgFilter(IDataModel model) {
        return QFilterHelper.buildMultiSelectFilter(model, "org", "forgid");
    }

    public static QFilter buildWarehouseFilter(Map<String, Map<String, String>> filterParams) {
        return QFilterHelper.buildFilterByParams(filterParams, "warehouse", "fwarehouseid");
    }

    public static QFilter buildWarehouseFilter(IDataModel model) {
        return QFilterHelper.buildMultiSelectFilter(model, "warehouse", "fwarehouseid");
    }

    public static QFilter buildLocationFilter(Map<String, Map<String, String>> filterParams) {
        return QFilterHelper.buildFilterByParams(filterParams, "location", "flocationid");
    }

    public static QFilter buildLocationFilter(IDataModel model) {
        return QFilterHelper.buildMultiSelectFilter(model, "location", "flocationid");
    }

    private static StringBuilder buildDateFilter(Object filterParams, String filterFieldKey, String queryField) {
        StringBuilder dateFilter = null;
        if (filterParams instanceof Map) {
            Map filterData = (Map)filterParams;
            if (MapUtils.isEmptyMap(filterData)) {
                return dateFilter;
            }
            Map filterInfo = (Map)filterData.get(filterFieldKey);
            if (MapUtils.isEmptyMap(filterInfo)) {
                return dateFilter;
            }
            String filterValue = (String)filterInfo.get("value");
            if (StringUtils.isEmpty((CharSequence)filterValue)) {
                return dateFilter;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat longDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date date = dateFormat.parse(filterValue);
                dateFilter = SieveFilterHelper.getDateFilter(filterFieldKey, queryField, date, longDateFormat);
            }
            catch (ParseException e) {
                log.error(e.getMessage());
                throw new KDBizException(e.getMessage());
            }
        } else if (filterParams instanceof IDataModel) {
            IDataModel model = (IDataModel)filterParams;
            Date date = (Date)model.getValue(filterFieldKey);
            if (date == null) {
                return null;
            }
            SimpleDateFormat longDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            dateFilter = SieveFilterHelper.getDateFilter(filterFieldKey, queryField, date, longDateFormat);
        }
        return dateFilter;
    }

    private static StringBuilder getDateFilter(String filterFieldKey, String queryField, Date date, DateFormat longDateFormat) {
        StringBuilder dateFilter = new StringBuilder();
        if (filterFieldKey.contains("from")) {
            Date dateFrom = DateUtils.getDayStartTime(date);
            dateFilter.append(queryField);
            dateFilter.append(" >= CONVERT(DATETIME,");
            dateFilter.append('\'');
            dateFilter.append(longDateFormat.format(dateFrom));
            dateFilter.append('\'');
            dateFilter.append(')');
        } else {
            Date dateTo = DateUtils.getDayEndTime(date);
            dateFilter.append(queryField);
            dateFilter.append(" <= CONVERT(DATETIME,");
            dateFilter.append('\'');
            dateFilter.append(longDateFormat.format(dateTo));
            dateFilter.append('\'');
            dateFilter.append(')');
        }
        return dateFilter;
    }

    public static StringBuilder buildDateRangeFilter(Object filterParams) {
        StringBuilder expdateFromFilter;
        StringBuilder dateRangeFilter = null;
        StringBuilder prodateFromFilter = SieveFilterHelper.buildDateFilter(filterParams, "prodatefrom", "fproducedate");
        if (prodateFromFilter != null) {
            dateRangeFilter = new StringBuilder();
            StringBuilder prodateToFilter = SieveFilterHelper.buildDateFilter(filterParams, "prodateto", "fproducedate");
            dateRangeFilter.append((CharSequence)prodateFromFilter);
            dateRangeFilter.append(" and ");
            dateRangeFilter.append((CharSequence)prodateToFilter);
        }
        if ((expdateFromFilter = SieveFilterHelper.buildDateFilter(filterParams, "expirydatefrom", "fexpirydate")) == null) {
            return dateRangeFilter;
        }
        StringBuilder expdateToFilter = SieveFilterHelper.buildDateFilter(filterParams, "expirydateto", "fexpirydate");
        if (dateRangeFilter == null) {
            dateRangeFilter = new StringBuilder();
        } else {
            dateRangeFilter.append(" and ");
        }
        dateRangeFilter.append((CharSequence)expdateFromFilter);
        dateRangeFilter.append(" and ");
        dateRangeFilter.append((CharSequence)expdateToFilter);
        return dateRangeFilter;
    }

    public static QFilter buildBaseQtyFilter(Map<String, Map<String, String>> filterParams) {
        QFilter baseQtyFilter = null;
        if (MapUtils.isEmptyMap(filterParams)) {
            return baseQtyFilter;
        }
        String baseQtyFromValue = null;
        String baseQtyToValue = null;
        BigDecimal baseQtyFrom = null;
        BigDecimal baseQtyTo = null;
        Map<String, String> baseQtyFFilterInfo = filterParams.get("baseqtyfrom");
        Map<String, String> baseQtyTFilterInfo = filterParams.get("baseqtyto");
        if (MapUtils.isNotEmptyMap(baseQtyFFilterInfo) && MapUtils.isEmptyMap(baseQtyTFilterInfo)) {
            baseQtyFromValue = baseQtyFFilterInfo.get("value");
            if (StringUtils.isNotEmpty((CharSequence)baseQtyFromValue)) {
                baseQtyFrom = new BigDecimal(baseQtyFromValue);
            }
        } else if (MapUtils.isEmptyMap(baseQtyFFilterInfo) && MapUtils.isNotEmptyMap(baseQtyTFilterInfo)) {
            baseQtyToValue = baseQtyTFilterInfo.get("value");
            if (StringUtils.isNotEmpty((CharSequence)baseQtyToValue)) {
                baseQtyTo = new BigDecimal(baseQtyToValue);
            }
        } else if (MapUtils.isNotEmptyMap(baseQtyFFilterInfo) && MapUtils.isNotEmptyMap(baseQtyTFilterInfo)) {
            baseQtyFromValue = baseQtyFFilterInfo.get("value");
            baseQtyToValue = baseQtyTFilterInfo.get("value");
            if (StringUtils.isNotEmpty((CharSequence)baseQtyFromValue)) {
                baseQtyFrom = new BigDecimal(baseQtyFromValue);
            }
            if (StringUtils.isNotEmpty((CharSequence)baseQtyToValue)) {
                baseQtyTo = new BigDecimal(baseQtyToValue);
            }
        }
        if (SieveFilterHelper.isNotEmptyBigDecimal(baseQtyFrom) && SieveFilterHelper.isEmptyBigDecimal(baseQtyTo)) {
            baseQtyFilter = new QFilter("fbaseqty", ">=", (Object)baseQtyFrom);
        } else if (SieveFilterHelper.isEmptyBigDecimal(baseQtyFrom) && SieveFilterHelper.isNotEmptyBigDecimal(baseQtyTo)) {
            baseQtyFilter = new QFilter("fbaseqty", "<=", (Object)baseQtyTo);
        } else if (SieveFilterHelper.isNotEmptyBigDecimal(baseQtyFrom) && SieveFilterHelper.isNotEmptyBigDecimal(baseQtyTo)) {
            baseQtyFilter = new QFilter("fbaseqty", ">=", (Object)baseQtyFrom).and("fbaseqty", "<=", (Object)baseQtyTo);
        }
        return baseQtyFilter;
    }

    public static QFilter buildBaseQtyFilter(IDataModel model) {
        QFilter baseQtyFilter = null;
        BigDecimal baseQtyFrom = (BigDecimal)model.getValue("baseqtyfrom");
        BigDecimal baseQtyTo = (BigDecimal)model.getValue("baseqtyto");
        if (SieveFilterHelper.isNotEmptyBigDecimal(baseQtyFrom) && SieveFilterHelper.isEmptyBigDecimal(baseQtyTo)) {
            baseQtyFilter = new QFilter("fbaseqty", ">=", (Object)baseQtyFrom);
        } else if (SieveFilterHelper.isEmptyBigDecimal(baseQtyFrom) && SieveFilterHelper.isNotEmptyBigDecimal(baseQtyTo)) {
            baseQtyFilter = new QFilter("fbaseqty", "<=", (Object)baseQtyTo);
        } else if (SieveFilterHelper.isNotEmptyBigDecimal(baseQtyFrom) && SieveFilterHelper.isNotEmptyBigDecimal(baseQtyTo)) {
            baseQtyFilter = new QFilter("fbaseqty", ">=", (Object)baseQtyFrom).and("fbaseqty", "<=", (Object)baseQtyTo);
        }
        return baseQtyFilter;
    }

    private static boolean isEmptyBigDecimal(BigDecimal obj) {
        return obj == null || obj.compareTo(BigDecimal.ZERO) == 0;
    }

    private static boolean isNotEmptyBigDecimal(BigDecimal obj) {
        return !SieveFilterHelper.isEmptyBigDecimal(obj);
    }
}

