/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class SieveOpHelper {
    public static void saveFilterScheme(IDataModel model, IPageCache pageCache) {
        String sieveId = pageCache.get("sieveid");
        if (sieveId == null) {
            SieveOpHelper.addSchemeData(model, pageCache);
        } else {
            SieveOpHelper.updSchemeData(model, Long.valueOf(sieveId));
        }
    }

    public static void updSchemeData(IDataModel model, Long sieveId) {
        List<DynamicObject> sieveSchemes = Collections.singletonList(SieveOpHelper.getUpdSchemeDyObj(model, sieveId));
        SieveOpHelper.updSchemeData(sieveSchemes);
    }

    public static void updSchemeData(List<DynamicObject> sieveSchemes) {
        SaveServiceHelper.save((DynamicObject[])sieveSchemes.toArray(new DynamicObject[sieveSchemes.size()]));
    }

    public static void updSchemeData(DynamicObject[] sieveSchemes) {
        SaveServiceHelper.save((DynamicObject[])sieveSchemes);
    }

    public static DynamicObject getUpdSchemeDyObj(IDataModel model, Long sieveId) {
        QFilter idFilter = new QFilter("id", "=", (Object)sieveId);
        DynamicObject sieveSchemeObj = BusinessDataServiceHelper.loadSingle((String)"mobim_sieveschemestore", (String)SieveOpHelper.getAllFields(), (QFilter[])idFilter.toArray());
        String schemeName = (String)model.getValue("schemename");
        sieveSchemeObj.set("name", (Object)schemeName);
        sieveSchemeObj.set("modifytime", (Object)new Date());
        String ownerType = (String)model.getValue("ownertype");
        String keeperType = (String)model.getValue("keepertype");
        String ownerKey = SieveOpHelper.getOwnerFieldKey(ownerType);
        String keeperKey = SieveOpHelper.getKeeperFieldKey(keeperType);
        DynamicObjectCollection entryEntity = sieveSchemeObj.getDynamicObjectCollection("entryentity");
        for (DynamicObject entryObj : entryEntity) {
            String fieldKey = entryObj.getString("sievefieldkey");
            if (fieldKey.endsWith("owner")) {
                entryObj.set("sievefieldkey", (Object)ownerKey);
                fieldKey = ownerKey;
            } else if (fieldKey.endsWith("keeper")) {
                entryObj.set("sievefieldkey", (Object)keeperKey);
                fieldKey = keeperKey;
            }
            Object fieldValue = model.getValue(fieldKey);
            if (fieldValue == null) {
                entryObj.set("sievefieldvalue_tag", (Object)"");
                continue;
            }
            if (!(fieldValue instanceof Date) && fieldValue instanceof String) {
                entryObj.set("sievefieldvalue_tag", (Object)String.valueOf(fieldValue));
                entryObj.set("sievefieldtype", (Object)"text");
                continue;
            }
            if (fieldValue instanceof DynamicObject) {
                String id = String.valueOf(((DynamicObject)fieldValue).getLong("id"));
                entryObj.set("sievefieldvalue_tag", (Object)id);
                entryObj.set("sievefieldtype", (Object)"basedata");
                continue;
            }
            if (fieldValue instanceof DynamicObjectCollection) {
                StringBuilder ids = new StringBuilder();
                DynamicObjectCollection dys = (DynamicObjectCollection)fieldValue;
                int size = dys.size();
                for (int i = 0; i < size; ++i) {
                    DynamicObject dy = (DynamicObject)dys.get(i);
                    DynamicObject dyObj = dy.getDynamicObject(1);
                    ids.append(dyObj.getLong("id"));
                    if (i >= size - 1) continue;
                    ids.append(',');
                }
                entryObj.set("sievefieldvalue_tag", (Object)ids.toString());
                entryObj.set("sievefieldtype", (Object)"multibasedata");
                continue;
            }
            if (fieldValue instanceof BigDecimal) {
                String value = String.valueOf(fieldValue);
                entryObj.set("sievefieldvalue_tag", (Object)value);
                entryObj.set("sievefieldtype", (Object)"qty");
                continue;
            }
            if (!(fieldValue instanceof Date)) continue;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String date = dateFormat.format((Date)fieldValue);
            entryObj.set("sievefieldvalue_tag", (Object)date);
            entryObj.set("sievefieldtype", (Object)"date");
        }
        return sieveSchemeObj;
    }

    public static void addSchemeData(IDataModel model, IPageCache pageCache) {
        DynamicObject sieveSchemeObj = SieveOpHelper.getAddSchemeDyObj(model);
        if (sieveSchemeObj == null) {
            return;
        }
        SieveOpHelper.addSchemeObj(pageCache, sieveSchemeObj);
    }

    public static void addSchemeObj(IPageCache pageCache, DynamicObject addSieveSchemeObj) {
        List<DynamicObject> sieveSchemes = Collections.singletonList(addSieveSchemeObj);
        OperationServiceHelper.executeOperate((String)"save", (String)"mobim_sieveschemestore", (DynamicObject[])sieveSchemes.toArray(new DynamicObject[sieveSchemes.size()]), null);
        long id = addSieveSchemeObj.getLong("id");
        pageCache.put("sieveid", String.valueOf(id));
    }

    public static DynamicObject getAddSchemeDyObj(IDataModel model) {
        String ownerType = (String)model.getValue("ownertype");
        String keeperType = (String)model.getValue("keepertype");
        if (StringUtils.isEmpty((CharSequence)ownerType) && StringUtils.isEmpty((CharSequence)keeperType)) {
            return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "accountowner", "keepertype", "invorgkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
        }
        if (StringUtils.isNotEmpty((CharSequence)ownerType) && StringUtils.isEmpty((CharSequence)keeperType)) {
            if ("bos_org".equals(ownerType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "accountowner", "keepertype", "invorgkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
            if ("bd_supplier".equals(ownerType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "supplierowner", "keepertype", "invorgkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
            if ("bd_customer".equals(ownerType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "customerowner", "keepertype", "invorgkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
        } else if (StringUtils.isEmpty((CharSequence)ownerType) && StringUtils.isNotEmpty((CharSequence)keeperType)) {
            if ("bos_org".equals(keeperType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "accountowner", "keepertype", "invorgkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
            if ("bd_supplier".equals(keeperType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "accountowner", "keepertype", "supplierkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
            if ("bd_customer".equals(keeperType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "accountowner", "keepertype", "customerkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
        } else {
            if ("bos_org".equals(ownerType) && "bos_org".equals(keeperType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "accountowner", "keepertype", "invorgkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
            if ("bos_org".equals(ownerType) && "bd_supplier".equals(keeperType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "accountowner", "keepertype", "supplierkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
            if ("bos_org".equals(ownerType) && "bd_customer".equals(keeperType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "accountowner", "keepertype", "customerkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
            if ("bd_supplier".equals(ownerType) && "bos_org".equals(keeperType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "supplierowner", "keepertype", "invorgkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
            if ("bd_supplier".equals(ownerType) && "bd_supplier".equals(keeperType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "supplierowner", "keepertype", "supplierkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
            if ("bd_supplier".equals(ownerType) && "bd_customer".equals(keeperType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "supplierowner", "keepertype", "customerkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
            if ("bd_customer".equals(ownerType) && "bos_org".equals(keeperType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "customerowner", "keepertype", "invorgkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
            if ("bd_customer".equals(ownerType) && "bd_supplier".equals(keeperType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "customerowner", "keepertype", "supplierkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
            if ("bd_customer".equals(ownerType) && "bd_customer".equals(keeperType)) {
                return SieveOpHelper.getAddSchemeDyObj(model, "org", "warehouse", "location", "ownertype", "customerowner", "keepertype", "customerkeeper", "invstatus", "invtype", "lotnumber", "project", "prodatefrom", "prodateto", "expirydatefrom", "expirydateto", "baseqtyfrom", "baseqtyto");
            }
        }
        return null;
    }

    public static DynamicObject getAddSchemeDyObj(IDataModel model, String ... fieldKeys) {
        MainEntityType sieveScheEntityType = EntityMetadataCache.getDataEntityType((String)"mobim_sieveschemestore");
        DynamicObject sieveSchemeObj = (DynamicObject)sieveScheEntityType.createInstance();
        String schemeName = (String)model.getValue("schemename");
        RequestContext requestContext = RequestContext.get();
        String currUserId = requestContext.getUserId();
        sieveSchemeObj.set("name", (Object)schemeName);
        sieveSchemeObj.set("enable", (Object)"1");
        sieveSchemeObj.set("status", (Object)"A");
        sieveSchemeObj.set("creator", (Object)currUserId);
        sieveSchemeObj.set("isselected", (Object)Boolean.TRUE);
        DynamicObjectCollection entryEntity = sieveSchemeObj.getDynamicObjectCollection("entryentity");
        for (String fieldKey : fieldKeys) {
            DynamicObject entryObj = entryEntity.addNew();
            entryObj.set("sievefieldkey", (Object)fieldKey);
            Object fieldValue = model.getValue(fieldKey);
            if (fieldValue == null) {
                entryObj.set("sievefieldtype", (Object)"unknown");
                continue;
            }
            if (fieldValue instanceof String) {
                entryObj.set("sievefieldtype", (Object)"text");
                entryObj.set("sievefieldvalue_tag", (Object)String.valueOf(fieldValue));
                continue;
            }
            if (fieldValue instanceof DynamicObject) {
                entryObj.set("sievefieldtype", (Object)"basedata");
                String id = String.valueOf(((DynamicObject)fieldValue).getLong("id"));
                entryObj.set("sievefieldvalue_tag", (Object)id);
                continue;
            }
            if (fieldValue instanceof DynamicObjectCollection) {
                StringBuilder ids = new StringBuilder();
                DynamicObjectCollection dys = (DynamicObjectCollection)fieldValue;
                int size = dys.size();
                for (int i = 0; i < size; ++i) {
                    DynamicObject dy = (DynamicObject)dys.get(i);
                    DynamicObject dyObj = dy.getDynamicObject(1);
                    ids.append(dyObj.getLong("id"));
                    if (i >= size - 1) continue;
                    ids.append(',');
                }
                entryObj.set("sievefieldtype", (Object)"multibasedata");
                entryObj.set("sievefieldvalue_tag", (Object)ids.toString());
                continue;
            }
            if (fieldValue instanceof BigDecimal) {
                String value = String.valueOf(fieldValue);
                entryObj.set("sievefieldtype", (Object)"qty");
                entryObj.set("sievefieldvalue_tag", (Object)value);
                continue;
            }
            if (!(fieldValue instanceof Date)) continue;
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
            String date = dateFormat.format((Date)fieldValue);
            entryObj.set("sievefieldtype", (Object)"date");
            entryObj.set("sievefieldvalue_tag", (Object)date);
        }
        return sieveSchemeObj;
    }

    public static void deleteScheme(Long id) {
        if (id == null || id.equals(0L)) {
            return;
        }
        List<Long> ids = Collections.singletonList(id);
        SieveOpHelper.batchDeleteScheme(ids);
    }

    public static void batchDeleteScheme(List<Long> ids) {
        if (ids == null || ids.size() == 0) {
            return;
        }
        OperationServiceHelper.executeOperate((String)"delete", (String)"mobim_sieveschemestore", (Object[])ids.toArray(), null);
    }

    private static String getOwnerFieldKey(String ownerType) {
        if (StringUtils.isEmpty((CharSequence)ownerType) || "bos_org".equals(ownerType)) {
            return "accountowner";
        }
        if ("bd_supplier".equals(ownerType)) {
            return "supplierowner";
        }
        return "customerowner";
    }

    private static String getKeeperFieldKey(String keeperType) {
        if (StringUtils.isEmpty((CharSequence)keeperType) || "bos_org".equals(keeperType)) {
            return "invorgkeeper";
        }
        if ("bd_supplier".equals(keeperType)) {
            return "supplierkeeper";
        }
        return "customerkeeper";
    }

    public static String getAllFields() {
        StringBuilder queryFields = new StringBuilder();
        queryFields.append("id");
        queryFields.append(',');
        queryFields.append("name");
        queryFields.append(',');
        queryFields.append("creator");
        queryFields.append(',');
        queryFields.append("modifytime");
        queryFields.append(',');
        queryFields.append("isselected");
        queryFields.append(',');
        queryFields.append("description");
        queryFields.append(',');
        queryFields.append("entryentity.sievefieldkey");
        queryFields.append(',');
        queryFields.append("entryentity.sievefieldtype");
        queryFields.append(',');
        queryFields.append("entryentity.sievefieldvalue_tag");
        queryFields.append(',');
        queryFields.append("entryentity.entrydescription");
        return queryFields.toString();
    }
}

