/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.scmc.im.consts.BigDecimalConstants;
import kd.scmc.im.enums.DiscountTypeEnum;
import kd.scmc.im.errorcode.InvBillErrorCode;
import kd.scmc.im.utils.CommonUtils;

public class TaxAlgorithmHelper {
    private static final Log log = LogFactory.getLog(TaxAlgorithmHelper.class);
    public static final String CURAMOUNTANDTAX = "curamountandtax";
    public static final String ENTRY_CURDEDUCTIBLEAMT = "curdeductibleamt";
    public static final String ENTRY_INTERCOSTAMT = "intercostamt";
    private DynamicObject bill;
    private String mainEntryKey;
    private int pricePrecision = 10;
    private int amountPrecision = 2;
    private int curAmountPrecision = 2;

    public TaxAlgorithmHelper(DynamicObject bill, String mainEntryKey) {
        if (bill == null || org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mainEntryKey)) {
            String errorMsg = ResManager.loadKDString((String)"TaxAlgorithmHelper\u6784\u9020\u5668\u7684\u5165\u53c2\u3010bill\u3011\u548c\u3010mainEntryKey\u3011\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"TaxAlgorithmHelper_0", (String)"scmc-mobim-form", (Object[])new Object[0]);
            throw new KDBizException(errorMsg);
        }
        this.bill = bill;
        this.mainEntryKey = mainEntryKey;
        this.initPrecision();
    }

    protected final void initPrecision() {
        DynamicObject curCurrency;
        DynamicObject currency = (DynamicObject)this.getValue("settlecurrency");
        if (currency != null) {
            this.amountPrecision = currency.getInt("amtprecision");
        }
        if ((curCurrency = (DynamicObject)this.getValue("currency")) != null) {
            this.curAmountPrecision = curCurrency.getInt("amtprecision");
        }
    }

    public void calByQty(int i) {
        if (this.hasTax()) {
            this.calPrice(i);
        } else {
            this.calPriceAndTax(i);
        }
        this.calDiscountAmount(i);
        this.calEntryAmountFileds(i);
        this.calEntryCurFileds(i);
        this.calActualPrice(i);
        this.calActualTaxPrice(i);
    }

    private void calPrice(int i) {
        BigDecimal taxPrice = this.getNullToZero("priceandtax", i);
        BigDecimal taxRate = this.getNullToZero("taxrate", i);
        BigDecimal price = BigDecimalConstants.ZERO;
        if (taxPrice != null) {
            BigDecimal zero = BigDecimalConstants.ZERO;
            BigDecimal one = BigDecimalConstants.ONE;
            BigDecimal oneHundred = BigDecimalConstants.ONEHUNDRED;
            taxRate = taxRate == null ? zero : taxRate.divide(oneHundred, taxRate.scale() + 2, 4);
            price = taxPrice.divide(one.add(taxRate), this.pricePrecision, 4);
        }
        this.setValue(this.mainEntryKey, "price", price, i);
    }

    private void calPriceAndTax(int i) {
        BigDecimal price = this.getNullToZero("price", i);
        BigDecimal taxRate = this.getNullToZero("taxrate", i);
        BigDecimal taxPrice = BigDecimalConstants.ZERO;
        BigDecimal one = BigDecimalConstants.ONE;
        BigDecimal oneHundred = BigDecimalConstants.ONEHUNDRED;
        taxRate = taxRate.divide(oneHundred, taxRate.scale() + 2, 4);
        taxPrice = price.multiply(one.add(taxRate));
        taxPrice = taxPrice.setScale(this.pricePrecision, 4);
        this.setValue(this.mainEntryKey, "priceandtax", taxPrice, i);
    }

    public void calDiscountAmount(int i) {
        BigDecimal price = this.getNullToZero("priceandtax", i);
        BigDecimal qty = this.getNullToZero("qty", i);
        BigDecimal discountRate = this.getNullToZero("discountrate", i);
        String discountType = (String)this.getValue(this.mainEntryKey, "discounttype", i);
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)discountType)) {
            DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get((String)discountType);
            switch (discountTypeEnum) {
                case DISRATE: {
                    discountAmount = price.multiply(qty).multiply(discountRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4)).setScale(this.amountPrecision, 4);
                    break;
                }
                case UNITDIS: {
                    if (this.hasTax()) {
                        discountAmount = qty.multiply(discountRate).setScale(this.amountPrecision, 4);
                        break;
                    }
                    BigDecimal taxRate = this.getNullToZero("taxrate", i);
                    taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4);
                    discountAmount = qty.multiply(discountRate).multiply(BigDecimal.ONE.add(taxRate)).setScale(this.amountPrecision, 4);
                    break;
                }
                case NULL: {
                    break;
                }
            }
        }
        this.setValue(this.mainEntryKey, "discountamount", discountAmount, i);
    }

    private void calActualPrice(int i) {
        BigDecimal discountAmount = this.getNullToZero("discountamount", i);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal price = this.getNullToZero("price", i);
            this.setValue(this.mainEntryKey, "actualprice", price, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            if (BigDecimal.ZERO.compareTo(amount) == 0 || BigDecimal.ZERO.compareTo(qty) == 0) {
                this.setValue(this.mainEntryKey, "actualprice", BigDecimal.ZERO, i);
            } else {
                BigDecimal price = amount.divide(qty, this.pricePrecision, 4);
                this.setValue(this.mainEntryKey, "actualprice", price, i);
            }
        }
    }

    private void calActualTaxPrice(int i) {
        BigDecimal discountAmount = this.getNullToZero("discountamount", i);
        if (BigDecimal.ZERO.compareTo(discountAmount) == 0) {
            BigDecimal taxPrice = this.getNullToZero("priceandtax", i);
            this.setValue(this.mainEntryKey, "actualtaxprice", taxPrice, i);
        } else {
            BigDecimal amountAndTax = this.getNullToZero("amountandtax", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            if (BigDecimal.ZERO.compareTo(amountAndTax) == 0 || BigDecimal.ZERO.compareTo(qty) == 0) {
                this.setValue(this.mainEntryKey, "actualtaxprice", BigDecimal.ZERO, i);
            } else {
                BigDecimal taxPrice = amountAndTax.divide(qty, this.pricePrecision, 4);
                this.setValue(this.mainEntryKey, "actualtaxprice", taxPrice, i);
            }
        }
    }

    private void calAmountAndTax(int i) {
        if (this.hasTax()) {
            BigDecimal priceAndTax = this.getNullToZero("priceandtax", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            BigDecimal discountAmount = this.getNullToZero("discountamount", i);
            BigDecimal taxAmount = qty.multiply(priceAndTax).subtract(discountAmount).setScale(this.amountPrecision, 4);
            TaxAlgorithmHelper.setTaxAmountErrorTip(taxAmount, i);
            this.setValue(this.mainEntryKey, "amountandtax", taxAmount, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal tax = this.getNullToZero("taxamount", i);
            BigDecimal taxAmount = amount.add(tax);
            TaxAlgorithmHelper.setTaxAmountErrorTip(taxAmount, i);
            this.setValue(this.mainEntryKey, "amountandtax", taxAmount, i);
        }
    }

    public static void setTaxAmountErrorTip(BigDecimal taxAmount, int rowIndex) {
        if (taxAmount.compareTo(BigDecimalConstants.MAX_BIGDECIMAL_VALUE) > 0) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u7b2c\u3010%1$s\u3011\u884c\u7684%2$s", (String)"TaxAlgorithmHelper_1", (String)"scmc-mobim-form", (Object[])new Object[0]), rowIndex + 1, CommonUtils.getCodeErrorMessage((ErrorCode)new InvBillErrorCode().getERROR_MAX_TAX_AMOUNT()));
            throw new KDBizException(errorMsg);
        }
    }

    private void calCurAmountAndTax(int i) {
        if (this.hasTax()) {
            BigDecimal taxAmount = this.getNullToZero("amountandtax", i);
            BigDecimal exchangerate = this.getNullToZero("exchangerate");
            BigDecimal localTaxAmount = taxAmount.multiply(exchangerate).setScale(this.curAmountPrecision, 4);
            this.setValue(this.mainEntryKey, CURAMOUNTANDTAX, localTaxAmount, i);
        } else {
            BigDecimal localAmount = this.getNullToZero("curamount", i);
            BigDecimal localTax = this.getNullToZero("curtaxamount", i);
            this.setValue(this.mainEntryKey, CURAMOUNTANDTAX, localAmount.add(localTax), i);
        }
        this.calIntercostAmt(i);
    }

    protected void calIntercostAmt(int i) {
        boolean isPurInBill = this.isPurInBill();
        if (!isPurInBill) {
            return;
        }
        BigDecimal curAmountAndTax = this.getNullToZero(CURAMOUNTANDTAX, i);
        BigDecimal curdeductibleAmt = this.getNullToZero(ENTRY_CURDEDUCTIBLEAMT, i);
        BigDecimal interCostAmt = curAmountAndTax.subtract(curdeductibleAmt).setScale(this.amountPrecision, 4);
        this.setValue(this.mainEntryKey, ENTRY_INTERCOSTAMT, interCostAmt, i);
    }

    private boolean isPurInBill() {
        String entityName = this.bill.getDataEntityType().getName();
        return "im_purinbill".equals(entityName) || "im_ospurinbill".equals(entityName);
    }

    private void calTaxAmount(int i) {
        if (this.hasTax()) {
            BigDecimal taxAmount = this.getNullToZero("amountandtax", i);
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            BigDecimal tax = BigDecimalConstants.ZERO;
            if (taxAmount.compareTo(BigDecimal.ZERO) != 0 && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
                tax = taxAmount.multiply(taxRate).divide(taxRate.add(BigDecimalConstants.ONE), this.amountPrecision, 4);
            }
            this.setValue(this.mainEntryKey, "taxamount", tax, i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            BigDecimal tax = BigDecimalConstants.ZERO;
            if (amount.compareTo(BigDecimal.ZERO) != 0 && taxRate.compareTo(BigDecimal.ZERO) != 0) {
                taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
                tax = amount.multiply(taxRate).setScale(this.amountPrecision, 4);
            }
            this.setValue(this.mainEntryKey, "taxamount", tax, i);
        }
    }

    private void calCurTaxAmount(int i) {
        BigDecimal tax = this.getNullToZero("taxamount", i);
        BigDecimal exchangerate = this.getNullToZero("exchangerate");
        BigDecimal localTax = tax.multiply(exchangerate).setScale(this.curAmountPrecision, 4);
        this.setValue(this.mainEntryKey, "curtaxamount", localTax, i);
    }

    private void calAmount(int i) {
        if (this.hasTax()) {
            BigDecimal taxAmount = this.getNullToZero("amountandtax", i);
            BigDecimal tax = this.getNullToZero("taxamount", i);
            BigDecimal amount = taxAmount.subtract(tax);
            this.setValue(this.mainEntryKey, "amount", amount, i);
        } else {
            BigDecimal price = this.getNullToZero("price", i);
            BigDecimal qty = this.getNullToZero("qty", i);
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal discountRate = this.getNullToZero("discountrate", i);
            String discountType = (String)this.getValue(this.mainEntryKey, "discounttype", i);
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)discountType)) {
                DiscountTypeEnum discountTypeEnum = DiscountTypeEnum.get((String)discountType);
                switch (discountTypeEnum) {
                    case DISRATE: {
                        BigDecimal reDiscountRate = discountRate.divide(BigDecimalConstants.ONEHUNDRED, discountRate.scale() + 2, 4);
                        amount = price.multiply(qty).multiply(BigDecimal.ONE.subtract(reDiscountRate)).setScale(this.amountPrecision, 4);
                        break;
                    }
                    case UNITDIS: {
                        amount = qty.multiply(price.subtract(discountRate)).setScale(this.amountPrecision, 4);
                        break;
                    }
                    case NULL: {
                        amount = qty.multiply(price).setScale(this.amountPrecision, 4);
                        break;
                    }
                }
            } else {
                amount = qty.multiply(price).setScale(this.amountPrecision, 4);
            }
            this.setValue(this.mainEntryKey, "amount", amount, i);
        }
    }

    private void calCurAmount(int i) {
        if (this.hasTax()) {
            BigDecimal LocalTaxAmount = this.getNullToZero(CURAMOUNTANDTAX, i);
            BigDecimal LocalTax = this.getNullToZero("curtaxamount", i);
            this.setValue(this.mainEntryKey, "curamount", LocalTaxAmount.subtract(LocalTax), i);
        } else {
            BigDecimal amount = this.getNullToZero("amount", i);
            BigDecimal exchangerate = this.getNullToZero("exchangerate");
            BigDecimal localTaxAmount = amount.multiply(exchangerate).setScale(this.curAmountPrecision, 4);
            this.setValue(this.mainEntryKey, "curamount", localTaxAmount, i);
        }
        this.calFarmieldsByCurAmount(i);
        this.calCostAmtByTaxPayer(i);
    }

    private void calCostAmtByTaxPayer(int i) {
        boolean inFarmBillType = this.isPurInFarmBillType();
        if (inFarmBillType || !this.isPurInBill()) {
            return;
        }
        BigDecimal curAmountAndTax = this.getNullToZero(CURAMOUNTANDTAX, i);
        BigDecimal curdeductibleAmt = this.getNullToZero(ENTRY_CURDEDUCTIBLEAMT, i);
        BigDecimal interCostAmt = curAmountAndTax.subtract(curdeductibleAmt).setScale(this.amountPrecision, 4);
        Object taxPayerType = this.getValue(this.mainEntryKey, "taxpayertype", i);
        if (StringUtils.isBlank((Object)taxPayerType)) {
            interCostAmt = BigDecimal.ZERO;
        }
        this.setValue(this.mainEntryKey, ENTRY_INTERCOSTAMT, interCostAmt, i);
    }

    protected boolean isPurInFarmBillType() {
        if (this.getValue("billtype") == null) {
            return false;
        }
        DynamicObject billType = (DynamicObject)this.getValue("billtype");
        if (null == billType) {
            return false;
        }
        return "im_PurInBill_FARM_BT_S".equals(billType.get("number"));
    }

    protected void calFarmieldsByCurAmount(int i) {
        Object taxPayerType;
        BigDecimal deductibleAmt;
        boolean isPurInBill = this.isPurInBill();
        if (!isPurInBill) {
            return;
        }
        BigDecimal curAmount = this.getNullToZero("curamount", i);
        BigDecimal deductibleRate = this.getNullToZero("deductiblerate", i);
        deductibleRate = deductibleRate.divide(BigDecimalConstants.ONEHUNDRED, deductibleRate.scale() + 2, 4);
        BigDecimal curAmountAndTax = this.getNullToZero(CURAMOUNTANDTAX, i);
        if (this.hasTax()) {
            BigDecimal taxRate = this.getNullToZero("taxrate", i);
            taxRate = taxRate.divide(BigDecimalConstants.ONEHUNDRED, taxRate.scale() + 2, 4);
            deductibleAmt = curAmountAndTax.multiply(deductibleRate).divide(taxRate.add(BigDecimalConstants.ONE), this.amountPrecision, 4);
        } else {
            deductibleAmt = curAmount.multiply(deductibleRate).setScale(this.curAmountPrecision, 4);
        }
        this.setValue(this.mainEntryKey, ENTRY_CURDEDUCTIBLEAMT, deductibleAmt, i);
        BigDecimal interCostAmt = curAmountAndTax.subtract(deductibleAmt).setScale(this.amountPrecision, 4);
        boolean inFarmBillType = this.isPurInFarmBillType();
        if (!inFarmBillType && StringUtils.isBlank((Object)(taxPayerType = this.getValue(this.mainEntryKey, "taxpayertype", i)))) {
            interCostAmt = BigDecimal.ZERO;
        }
        this.setValue(this.mainEntryKey, ENTRY_INTERCOSTAMT, interCostAmt, i);
    }

    protected void calEntryAmountFileds(int i) {
        if (this.hasTax()) {
            this.calAmountAndTax(i);
            this.calTaxAmount(i);
            this.calAmount(i);
        } else {
            this.calAmount(i);
            this.calTaxAmount(i);
            this.calAmountAndTax(i);
        }
    }

    protected void calEntryCurFileds(int i) {
        if (this.hasTax()) {
            this.calCurAmountAndTax(i);
            this.calCurTaxAmount(i);
            this.calCurAmount(i);
        } else {
            this.calCurAmount(i);
            this.calCurTaxAmount(i);
            this.calCurAmountAndTax(i);
        }
    }

    public boolean hasTax() {
        return this.bill.getBoolean("istax");
    }

    public BigDecimal getNullToZero(String key, int i) {
        BigDecimal value = (BigDecimal)this.getValue(this.mainEntryKey, key, i);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value;
    }

    private void setValue(String entryKey, String fieldKey, Object value, int entryRow) {
        DynamicObjectCollection entrys = this.bill.getDynamicObjectCollection(entryKey);
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        DynamicObject row = (DynamicObject)entrys.get(entryRow);
        row.set(fieldKey, value);
    }

    private Object getValue(String fieldKey) {
        return this.bill.get(fieldKey);
    }

    private Object getValue(String entryKey, String fieldKey, int entryRow) {
        DynamicObjectCollection entrys = this.bill.getDynamicObjectCollection(entryKey);
        if (entrys == null || entrys.size() == 0) {
            return null;
        }
        DynamicObject row = (DynamicObject)entrys.get(entryRow);
        return row.get(fieldKey);
    }

    public BigDecimal getNullToZero(String key) {
        BigDecimal value = (BigDecimal)this.getValue(key);
        if (value == null) {
            return BigDecimal.ZERO;
        }
        return value;
    }
}

