/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.scmc.msmob.common.enums.BillStatusEnum;

public class VisibleAbilityHelper {
    private static final String TOP_LOT_NUMBER_FLEX = "toplotnumberflex";
    private IFormView view;
    private IDataModel model;
    private static final String FLEX_AUPXTY = "aupxtyflexpanel";

    public VisibleAbilityHelper(IFormView view, IDataModel model) {
        this.view = view;
        this.model = model;
    }

    private void setVisibleAbilityOfAuxpty() {
        IDataEntityProperty auxpty = this.model.getProperty("auxpty");
        if (auxpty != null) {
            DynamicObject material = (DynamicObject)this.model.getValue("material");
            boolean isUseAuxpty = material != null && material.getBoolean("masterid.isuseauxpty");
            this.view.setVisible(Boolean.valueOf(isUseAuxpty), new String[]{FLEX_AUPXTY});
        }
    }

    private void setVisibleAbilityOfModel() {
        DynamicObject material = (DynamicObject)this.model.getValue("material");
        boolean isNotEmptyModelNum = material == null ? false : StringUtils.isNotEmpty((CharSequence)material.getString("masterid.modelnum"));
        this.view.setVisible(Boolean.valueOf(isNotEmptyModelNum), new String[]{"model"});
    }

    private void setVisibleAbilityOfLotNumber() {
        IDataEntityProperty lotnumber = this.model.getProperty("lotnumber");
        if (lotnumber != null) {
            DynamicObject material = (DynamicObject)this.model.getValue("material");
            boolean isUseLotNumber = material != null && material.getBoolean("enablelot");
            this.view.setVisible(Boolean.valueOf(isUseLotNumber), new String[]{"lotnumber", TOP_LOT_NUMBER_FLEX});
        }
    }

    private void setVisibleAbilityOfExpirationDate() {
        IDataEntityProperty produceDate = this.model.getProperty("producedate");
        IDataEntityProperty expiryDate = this.model.getProperty("expirydate");
        if (produceDate != null && expiryDate != null) {
            DynamicObject material = (DynamicObject)this.model.getValue("material");
            boolean isUseExpirationDate = material != null && material.getBoolean("enableshelflifemgr");
            this.view.setVisible(Boolean.valueOf(isUseExpirationDate), new String[]{"producedate", "expirydate"});
        }
    }

    public void setVisibleAbility() {
        this.setVisibleAbilityOfAuxpty();
        this.setVisibleAbilityOfModel();
        this.setVisibleAbilityOfLotNumber();
        this.setVisibleAbilityOfExpirationDate();
        this.setVisibleRequired();
    }

    public void setVisibleRequired() {
        String billStatus = (String)this.view.getParentView().getModel().getValue("billstatus");
        this.view.setVisible(Boolean.valueOf(BillStatusEnum.SAVE.getValue().equals(billStatus)), new String[]{"labelap2"});
    }
}

