/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper.barcode;

import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.BizCategoryEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.scmc.im.business.helper.BizTypeHelper;
import kd.scmc.im.business.helper.LineTypeHelper;
import kd.scmc.im.business.helper.linetype.BillTypeMaterialHelper;
import kd.scmc.mobim.business.helper.FarmProductsHelper;
import kd.scmc.msmob.business.helper.scan.IScanBusiness;
import kd.scmc.msmob.pojo.BarcodeParseResult;
import kd.scmc.msmob.pojo.Property;
import kd.scmc.msmob.pojo.PropertyValue;
import kd.scmc.msmob.pojo.QrCodeResult;
import org.apache.commons.lang3.StringUtils;

public class MobImBarCodeParseImpl
implements IScanBusiness {
    private static final String MASTERID_ENABLEVMI = "masterid.enablevmi";

    @Deprecated
    public void f7Filter(DynamicObject bill, String formId, BarcodeParseResult parseResult, Map<String, Long> f7Map) {
        List data = parseResult.getData();
        if (data == null || data.isEmpty()) {
            return;
        }
        Property property = (Property)data.get(0);
        String propertyType = property.getPropertyType();
        if (StringUtils.isEmpty((CharSequence)propertyType)) {
            return;
        }
        switch (propertyType) {
            case "material": {
                this.f7Material(bill, formId, property, f7Map);
                break;
            }
        }
    }

    public void f7Filter(DynamicObject bill, String formId, QrCodeResult qrCodeResult, Map<String, Long> f7Map) {
        if (!qrCodeResult.isSuccess()) {
            return;
        }
        String number = (String)qrCodeResult.getAttribute("number");
        if (StringUtils.isEmpty((CharSequence)number)) {
            return;
        }
        QFilter qFilter = this.getCommonFilter(bill, formId, number);
        this.setFilterByFormId(bill, formId, qFilter);
        List collection = QueryServiceHelper.queryPrimaryKeys((String)"bd_materialinventoryinfo", (QFilter[])qFilter.toArray(), null, (int)1);
        if (!collection.isEmpty()) {
            Long id = (Long)collection.get(0);
            String propertyType = qrCodeResult.getCodeType();
            f7Map.put(propertyType, id);
        }
    }

    private void f7Material(DynamicObject bill, String formId, Property property, Map<String, Long> filterMap) {
        QFilter qFilter = this.getCommonQFilter(bill, formId, property);
        this.setFilterByFormId(bill, formId, qFilter);
        DynamicObject material = QueryServiceHelper.queryOne((String)"bd_materialinventoryinfo", (String)"id", (QFilter[])qFilter.toArray());
        if (material != null) {
            long id = material.getLong("id");
            String propertyType = property.getPropertyType();
            filterMap.put(propertyType, id);
        }
    }

    private void setFilterByFormId(DynamicObject bill, String formId, QFilter qFilter) {
        switch (formId) {
            case "im_purreceivebill": 
            case "im_purinbill": {
                boolean isFarmBillType = FarmProductsHelper.isFarmBillType(bill);
                if (!isFarmBillType) break;
                QFilter filter = new QFilter("masterid.farmproducts", "=", (Object)Boolean.TRUE);
                qFilter.and(filter);
                break;
            }
        }
    }

    private QFilter getCommonFilter(DynamicObject bill, String formId, String number) {
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7", (String)"MobImBarCodeParseImpl_1", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        DynamicObject billType = bill.getDynamicObject("billtype");
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5355\u636e\u7c7b\u578b", (String)"MobImBillBeforeF7Select_1", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        DynamicObject bizType = bill.getDynamicObject("biztype");
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue()));
        qFilter.and("masterid.number", "=", (Object)number);
        qFilter.and("masterid.status", "=", (Object)"C");
        qFilter.and("masterid.enable", "=", (Object)"1");
        if (!formId.equals("im_initbill")) {
            Object value;
            if (bizType == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b", (String)"MobImBillBeforeF7Select_2", (String)"scmc-mobim-form", (Object[])new Object[0]));
            }
            DynamicObject lineType = this.getDefaultLineType(bill);
            if (lineType == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9ed8\u8ba4\u884c\u7c7b\u578b\u7c7b\u578b\u4e3a\u7a7a", (String)"MobImBarCodeParseImpl_2", (String)"scmc-mobim-form", (Object[])new Object[0]));
            }
            QFilter[] qFilterByLineType = BillTypeMaterialHelper.getQFilterByLineType((Long)((Long)billType.getPkValue()), (Long)((Long)bizType.getPkValue()), (Long)((Long)lineType.getPkValue()), (boolean)true);
            if (qFilterByLineType != null && (value = qFilterByLineType[0].getValue()) != null && !value.equals(1)) {
                QFilter serviceAttrFilter = QFilter.sqlExpress((String)"masterid.id", (String)"in", (String)(" ( select fid from t_bd_mtsserviceattribute where fbasedataid = " + value + " ) "));
                qFilter.and(serviceAttrFilter);
            }
        }
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        if (bizType != null) {
            String bizCategory = BizCategoryEnum.BZ.getValue();
            String bizNum = bizType.getString("number");
            if (!("111".equals(bizNum) || "1111".equals(bizNum) || "322".equals(bizNum))) {
                this.getMaterialFilterByMaterialType(qFilter, bizCategory);
            }
            if ("6".equals(bizType.get("domain"))) {
                switch (formId) {
                    case "im_purreceivebill": 
                    case "im_purinbill": 
                    case "im_materialreqoutbill": 
                    case "im_otheroutbill": 
                    case "im_saloutbill": {
                        qFilter.and(MASTERID_ENABLEVMI, "=", (Object)Boolean.TRUE);
                        break;
                    }
                }
            }
        }
        return qFilter;
    }

    @Deprecated
    private QFilter getCommonQFilter(DynamicObject bill, String formId, Property property) {
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5e93\u5b58\u7ec4\u7ec7", (String)"MobImBarCodeParseImpl_1", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        DynamicObject billType = bill.getDynamicObject("billtype");
        if (billType == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5355\u636e\u7c7b\u578b", (String)"MobImBillBeforeF7Select_1", (String)"scmc-mobim-form", (Object[])new Object[0]));
        }
        DynamicObject bizType = bill.getDynamicObject("biztype");
        QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_materialinventoryinfo", (Long)((Long)org.getPkValue()));
        PropertyValue propertyValue = property.getPropertyValue();
        Long materialId = propertyValue.getId();
        qFilter.and("id", "=", (Object)materialId);
        qFilter.and("masterid.status", "=", (Object)"C");
        qFilter.and("masterid.enable", "=", (Object)"1");
        if (!formId.equals("im_initbill")) {
            Object value;
            if (bizType == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u4e1a\u52a1\u7c7b\u578b", (String)"MobImBillBeforeF7Select_2", (String)"scmc-mobim-form", (Object[])new Object[0]));
            }
            DynamicObject lineType = this.getDefaultLineType(bill);
            if (lineType == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u9ed8\u8ba4\u884c\u7c7b\u578b\u7c7b\u578b\u4e3a\u7a7a", (String)"MobImBarCodeParseImpl_2", (String)"scmc-mobim-form", (Object[])new Object[0]));
            }
            QFilter[] qFilterByLineType = BillTypeMaterialHelper.getQFilterByLineType((Long)((Long)billType.getPkValue()), (Long)((Long)bizType.getPkValue()), (Long)((Long)lineType.getPkValue()), (boolean)true);
            if (qFilterByLineType != null && (value = qFilterByLineType[0].getValue()) != null && !value.equals(1)) {
                QFilter serviceAttrFilter = QFilter.sqlExpress((String)"masterid.id", (String)"in", (String)(" ( select fid from t_bd_mtsserviceattribute where fbasedataid = " + value + " ) "));
                qFilter.and(serviceAttrFilter);
            }
        }
        qFilter.and("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        if (bizType != null) {
            String bizCategory = BizCategoryEnum.BZ.getValue();
            String bizNum = bizType.getString("number");
            if (!("111".equals(bizNum) || "1111".equals(bizNum) || "322".equals(bizNum))) {
                this.getMaterialFilterByMaterialType(qFilter, bizCategory);
            }
            if ("6".equals(bizType.get("domain"))) {
                switch (formId) {
                    case "im_purreceivebill": 
                    case "im_purinbill": 
                    case "im_materialreqoutbill": 
                    case "im_otheroutbill": 
                    case "im_saloutbill": {
                        qFilter.and(MASTERID_ENABLEVMI, "=", (Object)Boolean.TRUE);
                        break;
                    }
                }
            }
        }
        return qFilter;
    }

    private void getMaterialFilterByMaterialType(QFilter qFilter, String bizCategory) {
        List materialTypes = BizTypeHelper.getMaterialQFilterByBizCategory((String)bizCategory);
        if (!materialTypes.isEmpty()) {
            qFilter.and("masterid.materialtype", "in", (Object)materialTypes);
        }
    }

    private DynamicObject getDefaultLineType(DynamicObject bill) {
        DynamicObject bizType = bill.getDynamicObject("biztype");
        if (bizType == null) {
            return null;
        }
        Long bizTypeId = bizType.getLong("id");
        Long lineTypeId = LineTypeHelper.getDefaultLineType((Long)bizTypeId);
        QFilter filter = new QFilter("id", "=", (Object)lineTypeId);
        MainEntityType pcMainEntityType = (MainEntityType)bill.getDynamicObjectType();
        BasedataProp basedataProp = (BasedataProp)pcMainEntityType.findProperty("linetype");
        Map lineTypeMap = BusinessDataServiceHelper.loadFromCache((DynamicObjectType)((DynamicObjectType)basedataProp.getComplexType((Object)bill)), (QFilter[])filter.toArray());
        return (DynamicObject)lineTypeMap.values().iterator().next();
    }
}

