/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper.invquery;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.sdk.scmc.mobim.extpoint.IInvQueryExpand;

public class DefaultInvQueryExpand
implements IInvQueryExpand {
    private static final String BIZTYPE_DOMAIN_VMI = "6";
    private static final String ENABLE_STATUS = "1";
    private static final String IM_PURINBILL_FARM = "im_PurInBill_FARM_BT_S";
    private static final String IM_PURRECBILL_FARM = "im_PurRecBill_FARM_BT_S";
    private static final String IM_OSPURINBILL = "im_ospurinbill_BT_S";

    public void getExpandFilter(DynamicObject bill, String entrykey, int row, String operatekey, Map<String, QFilter> filterMap) {
        MainEntityType billtype = (MainEntityType)bill.getDataEntityType();
        String billtypeName = billtype.getName();
        String appid = billtype.getAppId();
        DynamicObject entry = null;
        if (row > -1) {
            entry = (DynamicObject)bill.getDynamicObjectCollection(entrykey).get(row);
        }
        QFilter filter = filterMap.get("filter");
        if ("im".equals(appid)) {
            DynamicObject linetype;
            Map allEntryFields;
            String domain;
            DynamicObject biztype;
            Map allFields = billtype.getAllFields();
            if (allFields.containsKey("biztype") && (biztype = bill.getDynamicObject("biztype")) != null && BIZTYPE_DOMAIN_VMI.equals(domain = biztype.getString("domain"))) {
                filter = this.andQFilter(filter, "material.enablevmi", "=", Boolean.TRUE);
            }
            if ((allEntryFields = ((EntityType)billtype.getAllEntities().get(entrykey)).getFields()).containsKey("linetype") && entry != null && (linetype = entry.getDynamicObject("linetype")) != null) {
                Object serviceattributePK = linetype.getDynamicObject("serviceattribute").getPkValue();
                filter = this.andQFilter(filter, "material.serviceattribute.fbasedataid_id", "in", serviceattributePK);
            }
            if ("im_locationtransfer".equals(billtypeName)) {
                filter = this.andQFilter(filter, "location", "!=", 0);
            }
            if (allFields.containsKey("billtype")) {
                String billTypeNum;
                DynamicObject billType = bill.getDynamicObject("billtype");
                String string = billTypeNum = billType == null ? "" : billType.getString("number");
                if (IM_PURRECBILL_FARM.equals(billTypeNum) || IM_PURINBILL_FARM.equals(billTypeNum)) {
                    filter = this.andQFilter(filter, "material.farmproducts", "=", ENABLE_STATUS);
                }
                if (IM_OSPURINBILL.equals(billTypeNum)) {
                    filter = this.andQFilter(filter, "material.enableoutsource", "=", ENABLE_STATUS);
                }
            }
        }
        filterMap.put("filter", filter);
    }

    public void getExpandListFields(Map<String, String> groupByFields) {
    }

    public void getExpandHeadFields(Map<String, String> groupByFields) {
    }

    protected final QFilter andQFilter(QFilter filter, String property, String cp, Object value) {
        if (filter != null) {
            return filter.and(property, cp, value);
        }
        return new QFilter(property, cp, value);
    }
}

