/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper.invscheme;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.mobim.business.helper.invscheme.service.InvSchemeService;
import kd.scmc.mobim.business.helper.invscheme.service.InvSchemeServiceFactory;
import org.apache.commons.lang3.StringUtils;

public class InvSchemeHelper {
    protected static final String[] specialBill = new String[]{"im_mdc_mftmanuinbill", "im_mdc_mftreturnbill", "im_mdc_omcmplinbill"};

    public static void initEntryValue(DynamicObject bill, DynamicObject entry, DynamicObject invScheme) {
        String formId;
        if (invScheme == null) {
            return;
        }
        boolean isInUpdate = invScheme.getBoolean("isinupdate");
        boolean isOutUpdate = invScheme.getBoolean("isoutupdate");
        String ownerType = null;
        String keeperType = null;
        DynamicObject invStatus = null;
        DynamicObject invType = null;
        if (isInUpdate) {
            ownerType = invScheme.getString("ownertype");
            keeperType = invScheme.getString("keepertype");
            invStatus = InvSchemeHelper.getDefaultInvStatus(invScheme);
            invType = InvSchemeHelper.getDefaultInvType(invScheme);
        }
        String outOwnerType = null;
        String outKeeperType = null;
        DynamicObject outInvStatus = null;
        DynamicObject outInvType = null;
        if (isOutUpdate) {
            outOwnerType = invScheme.getString("outownertype");
            outKeeperType = invScheme.getString("outkeepertype");
            outInvStatus = InvSchemeHelper.getDefaultOutInvStatus(invScheme);
            outInvType = InvSchemeHelper.getDefaultOutInvType(invScheme);
        }
        if (InvSchemeHelper.checkInBills(formId = bill.getDataEntityType().getName())) {
            InvSchemeHelper.setSpacialValue(entry, invScheme);
        } else {
            entry.set("ownertype", (Object)ownerType);
            entry.set("keepertype", (Object)keeperType);
            entry.set("outownertype", (Object)outOwnerType);
            entry.set("outkeepertype", (Object)outKeeperType);
        }
        entry.set("invstatus", (Object)invStatus);
        entry.set("invtype", (Object)invType);
        entry.set("outinvstatus", (Object)outInvStatus);
        entry.set("outinvtype", (Object)outInvType);
    }

    public static void setDefaultOwnerAndKeeper(InvSchemeService service, DynamicObject bill, DynamicObject entry) {
        if (service == null) {
            service = InvSchemeServiceFactory.getService(bill);
        }
        if (service != null) {
            String outKeeperType = entry.getString("outkeepertype");
            DynamicObject defaultOutKeeper = null;
            if (!StringUtils.isEmpty((CharSequence)outKeeperType)) {
                defaultOutKeeper = service.getDefaultOutKeeper(outKeeperType, entry);
            }
            entry.set("outkeeper", defaultOutKeeper);
            String outOwnerType = entry.getString("outownertype");
            DynamicObject defaultOutOwner = null;
            if (!StringUtils.isEmpty((CharSequence)outOwnerType)) {
                defaultOutOwner = service.getDefaultOutOwner(outOwnerType, entry);
            }
            entry.set("outowner", defaultOutOwner);
            String keeperType = entry.getString("keepertype");
            DynamicObject defaultKeeper = null;
            if (!StringUtils.isEmpty((CharSequence)keeperType)) {
                defaultKeeper = service.getDefaultKeeper(keeperType, entry);
            }
            entry.set("keeper", defaultKeeper);
            String ownerType = entry.getString("ownertype");
            DynamicObject defaultOwner = null;
            if (!StringUtils.isEmpty((CharSequence)ownerType)) {
                defaultOwner = service.getDefaultOwner(ownerType, entry);
            }
            entry.set("owner", defaultOwner);
        }
    }

    private static boolean checkInBills(String formId) {
        for (int i = 0; i < specialBill.length; ++i) {
            if (!StringUtils.equals((CharSequence)formId, (CharSequence)specialBill[i])) continue;
            return true;
        }
        return false;
    }

    public static DynamicObject getDefaultOutInvType(DynamicObject invScheme) {
        return InvSchemeHelper.getDefaultInvTypeOrStatus(invScheme, "outinvtypeentry", "outinvtypeisdefault", "outinvtype");
    }

    public static DynamicObject getDefaultOutInvStatus(DynamicObject invScheme) {
        return InvSchemeHelper.getDefaultInvTypeOrStatus(invScheme, "outinvstatusentry", "outinvstatusisdefault", "outinvstatus");
    }

    public static DynamicObject getDefaultInvStatus(DynamicObject invScheme) {
        return InvSchemeHelper.getDefaultInvTypeOrStatus(invScheme, "invstatusentry", "invstatusisdefault", "invstatus");
    }

    public static DynamicObject getDefaultInvType(DynamicObject invScheme) {
        return InvSchemeHelper.getDefaultInvTypeOrStatus(invScheme, "invtypeentry", "invtypeisdefault", "invtype");
    }

    private static DynamicObject getDefaultInvTypeOrStatus(DynamicObject invScheme, String invTypeOrStatusEntry, String invTypeOrStatusIsDefault, String invTypeOrStatus) {
        DynamicObjectCollection entries = invScheme.getDynamicObjectCollection(invTypeOrStatusEntry);
        DynamicObject defaultInvTypeOrStatus = null;
        if (entries != null && !entries.isEmpty()) {
            for (DynamicObject entry : entries) {
                if (!entry.getBoolean(invTypeOrStatusIsDefault)) continue;
                defaultInvTypeOrStatus = entry.getDynamicObject(invTypeOrStatus);
                break;
            }
            if (defaultInvTypeOrStatus == null) {
                defaultInvTypeOrStatus = ((DynamicObject)entries.get(0)).getDynamicObject(invTypeOrStatus);
            }
        }
        return defaultInvTypeOrStatus;
    }

    private static void setSpacialValue(DynamicObject entry, DynamicObject invScheme) {
        String ownerType = invScheme.getString("ownertype");
        String keeperType = invScheme.getString("keepertype");
        ownerType = InvSchemeHelper.change2Null(entry, "ownertype", ownerType);
        keeperType = InvSchemeHelper.change2Null(entry, "keepertype", keeperType);
        String outOwnerType = invScheme.getString("outownertype");
        String outKeeperType = invScheme.getString("outkeepertype");
        outOwnerType = InvSchemeHelper.change2Null(entry, "outownertype", outOwnerType);
        outKeeperType = InvSchemeHelper.change2Null(entry, "outkeepertype", outKeeperType);
        entry.set("ownertype", (Object)ownerType);
        entry.set("keepertype", (Object)keeperType);
        entry.set("outownertype", (Object)outOwnerType);
        entry.set("outkeepertype", (Object)outKeeperType);
    }

    private static String change2Null(DynamicObject entry, String string, String type) {
        if ("".equals(entry.getString(string))) {
            type = "";
        }
        return type;
    }
}

