/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper.invscheme.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.mobim.business.helper.invscheme.service.InvSchemeService;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSchemeService
implements InvSchemeService {
    protected DynamicObject bill = null;

    public DynamicObject getBill() {
        return this.bill;
    }

    public void setBill(DynamicObject bill) {
        this.bill = bill;
    }

    public AbstractSchemeService(DynamicObject bill) {
        this.bill = bill;
    }

    public Object getValue(String key) {
        return this.bill.get(key);
    }

    public Object getValue(String key, int i) {
        DynamicObjectCollection entry = this.bill.getDynamicObjectCollection("billentry");
        return ((DynamicObject)entry.get(i)).get(key);
    }

    protected Long getCompanyByOrg(Long bizOrgId) {
        Long settleOrgId = null;
        if (bizOrgId != null) {
            settleOrgId = this.queryCompanyId(bizOrgId);
        }
        return settleOrgId;
    }

    Long getDefaultOwner(DynamicObject invOrg, DynamicObject reqOrg) {
        if (invOrg == null) {
            return null;
        }
        Map<String, Object> delegation = this.getDelegationOrgList((Long)invOrg.getPkValue());
        List orgIds = (List)delegation.get("orgId");
        if (orgIds == null || orgIds.size() == 0) {
            DynamicObject orgDyc = (DynamicObject)this.getValue("org");
            List<Object> ownerList = this.getOwnerList(orgDyc);
            if (ownerList.size() > 0) {
                return Long.valueOf(ownerList.get(0).toString());
            }
        } else {
            if (reqOrg == null) {
                return null;
            }
            Long companyByOrg = this.getCompanyByOrg((Long)reqOrg.getPkValue());
            if (orgIds.contains(companyByOrg)) {
                return companyByOrg;
            }
            List detailList = (List)delegation.get("data");
            for (Map detailMap : detailList) {
                Boolean isDefault = (Boolean)detailMap.get("isDefault");
                if (!isDefault.booleanValue() || detailMap.get("orgId") == null) continue;
                return detailMap.get("orgId") instanceof Long ? (Long)detailMap.get("orgId") : Long.valueOf(detailMap.get("orgId").toString());
            }
        }
        return null;
    }

    private Map<String, Object> getDelegationOrgList(Long orgId) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(orgId.longValue());
        param.setFromViewType("10");
        param.setToViewType("05");
        param.setDirectViewType("fromorg");
        return OrgUnitServiceHelper.getOrgRelation((OrgRelationParam)param);
    }

    private Long queryCompanyId(Long bizOrgId) {
        Long settleOrgId = null;
        Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)bizOrgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (map != null) {
            settleOrgId = (Long)map.get("id");
        }
        return settleOrgId;
    }

    protected List<Object> getOwnerList(DynamicObject org) {
        List<Object> array = new ArrayList<Object>();
        if (org != null) {
            Long orgId = (Long)org.getPkValue();
            array = this.queryOwnerList(orgId);
        }
        return array;
    }

    private List<Object> queryOwnerList(Long orgId) {
        Object settleOrgId;
        ArrayList ownerArray = OwnerHelper.getOwners((Long)orgId);
        ArrayList<Object> array = new ArrayList<Object>(ownerArray);
        Map companyByOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE);
        if (companyByOrg != null && (settleOrgId = companyByOrg.get("id")) != null && StringUtils.isNotEmpty((CharSequence)settleOrgId.toString())) {
            array.add(settleOrgId);
        }
        return array;
    }
}

