/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper.invscheme.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.mobim.business.helper.invscheme.service.AbstractSchemeService;
import kd.scmc.mobim.business.helper.invscheme.service.InvSchemeService;
import kd.scmc.mobim.business.helper.invscheme.service.MReqOutInvSchemeService;
import kd.scmc.mobim.business.helper.invscheme.service.OtherInInvSchemeService;
import kd.scmc.mobim.business.helper.invscheme.service.OtherOutInvSchemeService;
import kd.scmc.mobim.business.helper.invscheme.service.ProductInvSchemeService;
import kd.scmc.mobim.business.helper.invscheme.service.PurInInvSchemeService;
import kd.scmc.mobim.business.helper.invscheme.service.PurReceInvSchemeService;
import kd.scmc.mobim.business.helper.invscheme.service.SaleOutInvSchemeService;
import kd.scmc.mobim.business.helper.invscheme.service.TransInvSchemeService;
import org.apache.commons.lang3.StringUtils;

public class InvSchemeServiceFactory {
    public static InvSchemeService getService(DynamicObject bill) {
        if (bill == null) {
            return null;
        }
        String entryName = bill.getDataEntityType().getName();
        return InvSchemeServiceFactory.getService(entryName, bill);
    }

    public static InvSchemeService getService(String entryName, DynamicObject bill) {
        if (StringUtils.isEmpty((CharSequence)entryName)) {
            return null;
        }
        AbstractSchemeService service = null;
        switch (entryName) {
            case "im_saloutbill": {
                service = new SaleOutInvSchemeService(bill);
                break;
            }
            case "im_otherinbill": {
                service = new OtherInInvSchemeService(bill);
                break;
            }
            case "im_purinbill": {
                service = new PurInInvSchemeService(bill);
                break;
            }
            case "im_otheroutbill": {
                service = new OtherOutInvSchemeService(bill);
                break;
            }
            case "im_transoutbill": 
            case "im_transinbill": {
                service = new TransInvSchemeService(bill);
                break;
            }
            case "im_purreceivebill": {
                service = new PurReceInvSchemeService(bill);
                break;
            }
            case "im_materialreqoutbill": {
                service = new MReqOutInvSchemeService(bill);
                break;
            }
            case "im_productinbill": {
                service = new ProductInvSchemeService(bill);
                break;
            }
        }
        return service;
    }
}

