/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper.invscheme.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.mobim.business.helper.invscheme.service.AbstractSchemeService;
import org.apache.commons.lang3.StringUtils;

public class SaleOutInvSchemeService
extends AbstractSchemeService {
    public SaleOutInvSchemeService(DynamicObject bill) {
        super(bill);
    }

    @Override
    public DynamicObject getDefaultOwner(String type, DynamicObject entry) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        DynamicObject owner = null;
        switch (type) {
            case "bos_org": {
                owner = entry.getDynamicObject("outowner");
                break;
            }
            case "bd_customer": {
                owner = this.bill.getDynamicObject("customer");
                break;
            }
        }
        return owner;
    }

    @Override
    public DynamicObject getDefaultKeeper(String type, DynamicObject entry) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        DynamicObject keeper = null;
        switch (type) {
            case "bos_org": {
                keeper = this.bill.getDynamicObject("org");
                break;
            }
            case "bd_customer": {
                keeper = this.bill.getDynamicObject("customer");
                break;
            }
        }
        return keeper;
    }

    @Override
    public DynamicObject getDefaultOutOwner(String type, DynamicObject entry) {
        DynamicObject bizOrg = (DynamicObject)this.getValue("bizorg");
        String outOwnerType = entry.getString("outownertype");
        if (StringUtils.isEmpty((CharSequence)outOwnerType)) {
            return null;
        }
        DynamicObject outOwner = null;
        switch (outOwnerType) {
            case "bos_org": {
                DynamicObject orgDyc = this.bill.getDynamicObject("org");
                if (bizOrg == null || orgDyc == null) break;
                Long orgId = this.getDefaultOwner(orgDyc, bizOrg);
                outOwner = this.getOrg(orgId);
                break;
            }
            case "bd_customer": {
                outOwner = this.bill.getDynamicObject("customer");
                break;
            }
        }
        return outOwner;
    }

    public DynamicObject getOrg(Long orgId) {
        if (orgId != null) {
            return BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        }
        return null;
    }

    @Override
    public DynamicObject getDefaultOutKeeper(String type, DynamicObject entry) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        DynamicObject outKeeper = null;
        switch (type) {
            case "bos_org": {
                outKeeper = this.bill.getDynamicObject("org");
                break;
            }
            case "bd_customer": {
                outKeeper = this.bill.getDynamicObject("customer");
                break;
            }
        }
        return outKeeper;
    }
}

