/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.mobim.business.helper.invscheme.service;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.im.business.helper.MetaDataHelper;
import kd.scmc.im.business.helper.OwnerHelper;
import kd.scmc.im.utils.CommonUtils;
import kd.scmc.mobim.business.helper.invscheme.service.AbstractSchemeService;
import org.apache.commons.lang3.StringUtils;

public class TransInvSchemeService
extends AbstractSchemeService {
    public TransInvSchemeService(DynamicObject bill) {
        super(bill);
    }

    public Object getDefaultOwner(String type, int i) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        DynamicObject inorg = null;
        inorg = MetaDataHelper.isExistField((IDataEntityType)this.bill.getDataEntityType(), (String)"inorg") ? (DynamicObject)this.getValue("inorg") : (DynamicObject)this.getValue("org");
        return this.getOwner(inorg, i);
    }

    protected Object getKeeper(String field, DynamicObject entryData) {
        DynamicObject keeper = null;
        DynamicObject org = null;
        if (field == null) {
            return keeper;
        }
        switch (field) {
            case "outkeepertype": {
                if (MetaDataHelper.isExistField((IDataEntityType)this.bill.getDataEntityType(), (String)"outorg")) {
                    org = (DynamicObject)this.getValue("outorg");
                    break;
                }
                org = (DynamicObject)this.getValue("org");
                break;
            }
            default: {
                org = MetaDataHelper.isExistField((IDataEntityType)this.bill.getDataEntityType(), (String)"inorg") ? (DynamicObject)this.getValue("inorg") : (DynamicObject)this.getValue("org");
            }
        }
        Object keeperTypeObj = entryData.get(field);
        if (keeperTypeObj != null) {
            switch (keeperTypeObj.toString()) {
                case "bos_org": {
                    keeper = org;
                    break;
                }
                case "bd_supplier": 
                case "bd_customer": {
                    keeper = null;
                    break;
                }
            }
        } else {
            keeper = null;
        }
        return keeper;
    }

    protected Object getOwner(DynamicObject org, int rowIndex) {
        Object ownerId = null;
        Object inOwnerType = this.getValue("ownertype", rowIndex);
        if (!"bos_org".equals(inOwnerType)) {
            return ownerId;
        }
        if (CommonUtils.isNull((Object)org)) {
            return ownerId;
        }
        Long orgId = (Long)org.getPkValue();
        ownerId = OwnerHelper.getOwnerDefValue((Long)orgId);
        return ownerId;
    }

    protected Object getOutOwner(DynamicObject org, DynamicObject entryData) {
        DynamicObject owner = null;
        Object inOwnerType = entryData.get("outownertype");
        if (!"bos_org".equals(inOwnerType)) {
            return owner;
        }
        if (CommonUtils.isNull((Object)org)) {
            return owner;
        }
        Long orgId = (Long)org.getPkValue();
        Long ownerId = (Long)OwnerHelper.getOwnerDefValue((Long)orgId);
        owner = BusinessDataServiceHelper.loadSingleFromCache((Object)ownerId, (String)"bos_org");
        return owner;
    }

    @Override
    public DynamicObject getDefaultOwner(String type, DynamicObject entry) {
        return null;
    }

    @Override
    public DynamicObject getDefaultKeeper(String type, DynamicObject entry) {
        return (DynamicObject)this.getKeeper("keepertype", entry);
    }

    @Override
    public DynamicObject getDefaultOutOwner(String type, DynamicObject entryData) {
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        DynamicObject outOrg = MetaDataHelper.isExistField((IDataEntityType)this.bill.getDataEntityType(), (String)"outorg") ? (DynamicObject)this.getValue("outorg") : (DynamicObject)this.getValue("org");
        return (DynamicObject)this.getOutOwner(outOrg, entryData);
    }

    @Override
    public DynamicObject getDefaultOutKeeper(String type, DynamicObject entryData) {
        return (DynamicObject)this.getKeeper("outkeepertype", entryData);
    }
}

